<?php
/*  ----------------------------------------------------------------------------
    the attachment template
*/

get_header(); ?>

	<div id="content">
		<div class="row inner-content">
			
			<!-- ===== Archive Content ======= -->
			<div id="main_content" class="col-sm-8 ub-list-archive">
				
				<?php rst_wp_bac_breadcrumb() ?>
				
				<?php if ( have_posts() ) : ?>
					
					<?php while ( have_posts() ) : the_post(); ?>
					
						<div class="ub-blog-post">
							<?php
								if ( wp_attachment_is_image( $post->id ) ) {
									$td_att_image = wp_get_attachment_image_src( $post->id, 'full');

									if (!empty($td_att_image[0])) {
										$td_att_url = $td_att_image[0];
									}

									if (empty($td_att_image[0])) {
										$td_att_image[0] = ''; //init the variable to not have problems
									}


									?>
									<a href="<?php echo wp_get_attachment_url($post->id); ?>" title="<?php the_title(); ?>" rel="attachment"><img class="td-attachment-page-image" src="<?php echo esc_url($td_att_image[0]);?>" alt="<?php echo esc_html($post->post_title) ?>" /></a>

									<div class="td-attachment-page-content">
										<?php the_content(); ?>
									</div>
									<?php
								}
							?>
						</div>
						
					<?php endwhile; ?>
					
					<?php rst_paging_nav(); ?>

				<?php else : ?>

					<?php get_template_part( 'content', 'none' ); ?>

				<?php endif; ?>

			</div>
			<!--End-Archive-Content-->
			<div id="sidebar" class="widget-area col-sm-4" role="complementary">
				<?php dynamic_sidebar( 'sidebar-default' ); ?>
			</div><!-- #secondary -->
			
		</div>
	</div>

<?php get_footer(); ?>
