<?php
/**
 * The template part for displaying a message that posts format video.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Ublog
 */
?>
<?php 
	$class_wrap = '';
	$class_col_1 = '';
	$class_col_2 = '';
	$size_image = 'large';
	
	global $ub_agrs;
	switch (true) {
		case ( $ub_agrs['type'] == 'box' ) :
			$size_image = array('width' => 490,'height' => 320);
			$class_wrap = 'col-sm-'. 12/absint($ub_agrs['column']);
		break;
		case ( $ub_agrs['type'] == 'grid' ) :
			$size_image = array('width' => 321);
			$class_wrap = 'col-sm-'. 12/absint($ub_agrs['column']);
		break;
		case ( $ub_agrs['type'] == 'large' ) :
			$class_wrap = 'col-sm-12';
			$size_image = array('width' => 1000,'height' => 490);
		break;
		case ( $ub_agrs['type'] == 'medium' ) :
			$class_wrap_inner = $ub_agrs['is_show_thumbnail'] ? 'row' : '';
			$class_col_1 = $ub_agrs['is_show_thumbnail'] ? 'col-sm-5' : '';
			$class_col_2 = $ub_agrs['is_show_thumbnail'] ? 'col-sm-7' : '';
			$size_image = array('width' => 321,'height' => 209);
		break;
	}

?>
<?php 
	$audio_type = rs::getField('ublog_audio_type',get_the_ID());
	$audio_iframe = rs::getField('ublog_audio_iframe',get_the_ID());
	$audio_upload = rs::getField('ublog_audio_upload',get_the_ID(),'audio','url');
?>
<div class="<?php echo sanitize_html_class($class_wrap) ?> post-<?php echo sanitize_html_class($ub_agrs['type']) ?> ub-blog-post">
	<div class="inner-content <?php echo sanitize_html_class($class_wrap_inner) ?>">
		<?php if( $ub_agrs['is_show_thumbnail'] ) { ?>
		<div class="<?php echo sanitize_html_class($class_col_1) ?> ub-post-thumbnail">
			<?php 
				if( $ub_agrs['type_show_thumbnail_video'] == 'more' ){
					if( $audio_type == 'iframe' && $audio_iframe ) {
						echo force_balance_tags($audio_iframe);
					}
					elseif( $audio_type == 'upload' && $audio_upload ) {
						echo do_shortcode( '[audio src="'. esc_url($audio_upload). '" ]' );
					}
				}
				if( get_post_thumbnail_id(get_the_ID()) && $ub_agrs['type_show_thumbnail_video'] == 'image' ) {
			?>
			<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
				<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()),'full'), $size_image ) ?>">
				<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
			</a>
			<?php } ?>
		</div>
		<?php } ?>
		<div class="<?php echo sanitize_html_class($class_col_2) ?> ub-information-post">
			<h4><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php echo get_the_title(get_the_ID()) ?></a></h4>
			<?php rst_display_post_information() ?>
			<?php
				if( $ub_agrs['is_show_excerpt'] )
					echo get_excerpt_by_id($post,absint($ub_agrs['excerpt_length']));
				
			?>
		</div>
	</div>
</div>