<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ublog
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('ub-blog-post'); ?>>
	<header class="entry-header">
		<?php 
			if( rs::getField('rst_show_title') )
			the_title( '<h1 class="archive-title">', '</h1>' ); 
		?>
		<div class="entry-meta">
		<?php 
			if( rs::getField('rst_show_infor') )
			rst_display_post_information();
		?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->
	
	<?php the_post_thumbnail(); ?>
	
	<?php
		if( rs::getField('is_dropcap') ) $dropcap = 'entry-dropcap';
	?>
	<div class="entry-content <?php echo !empty($dropcap) ? force_balance_tags($dropcap) : '' ?>">
		<?php
			the_content(); 
			
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'ublog' ),
				'after'  => '</div>',
			) );
		?>
		<?php if( rs::getField('page_is_show_rating') ) echo rst_render_rating(); ?>
		<?php if( rs::getField('page_is_show_share') ) { ?>
		<div class="ub-share-box">
			<div class="ub-share-this">
				<span class="ub-share-icon"><i class="fa fa-share-alt"></i> <?php rst_the_translate('Share this','share_this') ?></span>
				<a href="http://twitter.com/share?text=<?php the_title() ?>&url=<?php the_permalink() ?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-twitter"></i></a>
				<a  href="http://www.facebook.com/sharer/sharer.php?s=100&p[url]=<?php the_permalink() ?>&p[images][0]=<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)) ?>&p[title]=<?php echo str_replace(" ", "%20", $post->post_title) ?>&p[summary]=<?php echo str_replace(" ", "%20", get_the_excerpt() ) ?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-facebook"></i></a>
				<a href="https://plus.google.com/share?url=<?php the_permalink() ?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-google-plus"></i></a>
				<a href="https://pinterest.com/pin/create/button/?url=<?php the_permalink() ?>&media=<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)) ?>&description=<?php echo str_replace(" ", "%20", get_the_excerpt()) ;?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-pinterest"></i></a>
				<a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink() ?>&title=<?php echo str_replace(" ", "%20", $post->post_title) ?>&summary=<?php echo str_replace(" ", "%20", get_the_excerpt()) ;?>&source=LinkedIn" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-linkedin"></i></a>
				<a href="http://www.tumblr.com/share/link?url=<?php the_permalink() ?>&name=Sharing%20links%20to%20articles&description=<?php echo str_replace(" ", "%20", get_the_excerpt()) ;?>" onclick="javascript:window.open(this.href,
  '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="fa fa-tumblr"></i></a>
			</div>
		</div><!--End-share-box-->
		<?php } ?>
		<?php 
			if( rs::getField('page_is_show_author') ) { 
				the_author_box();
			}
		?>
		
		<?php comments_template( '', true ); ?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
