<div class="row ub-related-posts">
	<?php 
		//for use in the loop, list 5 post titles related to first tag on current post
		$tags = wp_get_post_tags($post->ID);
		if ( $tags || wp_get_post_categories($post->ID) ) {
			$tag_ids = array();
			foreach($tags as $individual_tag) $tag_ids[] = $individual_tag->term_id;
			$args=array(
				'tag__in' => $tag_ids,
				'post__not_in' => array($post->ID),
				'category__in' => wp_get_post_categories($post->ID),
				'posts_per_page'=> 3
			);
			$my_query = new WP_Query($args);
			if( $my_query->have_posts() ) {
			echo '<div class="col-sm-12"><h3 class="widget-title"><span>'. rst_get_translate('You Might Also Like','related_posts') .'</span></h3></div>';
			while ($my_query->have_posts()) : $my_query->the_post();
				$size_image = array('width' => 600,'height' => 360);
	?>
	<div class="col-sm-4 ub-blog-post">
		<?php if( get_post_thumbnail_id($post->ID) ) { ?>
		<div class="post-thumbnail">
			<a href="<?php the_permalink() ?>"><img alt="<?php echo get_the_title($post->ID) ?>" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id($post->ID),'full'), $size_image ) ?>"></a>
		</div>
		<?php } ?>
		<div class="info-post">
			<h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
			<span class="date">- on <?php echo get_post_date() ?></span>
		</div><!--End-info-post-->
	</div>
	<?php 
			endwhile;
		}
		wp_reset_query();
	}
?>
</div><!--End-related-posts-->