<?php
/**
 * @package Ublog
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('ub-blog-post'); ?>>
	
	<header class="entry-header">
		<?php 
			if( rs::getField('rst_show_title') )
			the_title( '<h1 class="archive-title">', '</h1>' ); 
		?>
		<div class="entry-meta">
		<?php 
			if( rs::getField('rst_show_infor') )
			rst_display_post_information();
		?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->
	
	<?php
		if( rs::getField('is_dropcap') ) $dropcap = 'entry-dropcap';
	?>
	<div class="entry-content <?php echo !empty($dropcap) ? force_balance_tags($dropcap) : '' ?>">
		<?php
			the_content(); 
			
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'ublog' ),
				'after'  => '</div>',
			) );
		?>
		<br />
		<?php if( rs::getField('single_is_show_rating') ) echo rst_render_rating(); ?>
		<?php 
			$posttags = get_the_tags();
			$key = 0;
			if( is_array($posttags) && sizeof($posttags) ) {
				the_tags( '<div class="ub-tags">Tags: ', '', '</div>' );
			}
		?>
		<div class="ub-share-box">
			<?php if( !get_theme_mod('singe_hide_share') ) {
				get_template_part( 'content', 'share' );
			} ?>
		</div><!--End-share-box-->
		
		<?php if( !get_theme_mod('singe_hide_paging') ) { ?>
		<div class="row ub-navs-links clearfix">
			<div class="col-sm-6 text-left pull-left">
				<?php if( get_previous_post() ) { ?>
				<a class="nav-previous" rel="prev" href="<?php echo get_permalink(get_previous_post()) ?>"><i class="fa fa-angle-left"></i> <?php rst_the_translate('PREVIOUS POST','previous_post') ?></a>
				<h3 class="empty-title"><a href="<?php echo get_permalink(get_previous_post()) ?>"><?php echo get_the_title(get_previous_post()) ?></a></h3>
				<?php } ?>
			</div>
			<div class="col-sm-6 text-right pull-right">
				<?php if( get_next_post() ) { ?>
				<a class="nav-next" rel="next" href="<?php echo get_permalink(get_next_post()) ?>"><?php rst_the_translate('NEXT POST','next_post') ?> <i class="fa fa-angle-right"></i></a>
				<h3 class="empty-title"><a href="<?php echo get_permalink(get_next_post()) ?>"><?php echo get_the_title(get_next_post()) ?></a></h3>
				<?php } ?>
			</div>
		</div>
		<?php } ?>
		
		<?php 
			if( !get_theme_mod('singe_hide_author_meta') ) { 
				the_author_box();
			}
		?>
		
		<?php if( !get_theme_mod('singe_hide_related') ) {
			get_template_part( 'content', 'related-post' );
		} ?>
		
		<?php comments_template( '', true ); ?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
