<?php
/**
 * Ublog functions and definitions
 *
 * @package Ublog
 */

if ( ! function_exists( 'rst_ublog_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function rst_ublog_setup() {
	
	
	if( !defined( 'LANGUAGE_ZONE' ) )
		define('LANGUAGE_ZONE', 'rst_ublog');
	
	
		// Add rslib.
		require get_template_directory() . '/rslib/rslib.php';
		
		// Convert Images
		get_template_part('extras/BFI_Thumb');
		// $params = array('width' => 229);
		// $img = bfi_thumb($image_attributes[0], $params);
		
		
		// Count Social Network
		require get_template_directory() . '/inc/count-social-network.php';
		
		// Custom Featured Image
		require get_template_directory() . '/inc/custom-featured-image.php';
		
		
		// Breadcrumbs
		require get_template_directory() . '/inc/breadcrumbs.php';
		
		// Rating
		require get_template_directory() . '/inc/rating/rating.php';
		
		// Comments
		require get_template_directory() . '/inc/comments.php';
		
		// Menu mage
		require get_template_directory() . '/inc/menu-mega/rst_menu.php';
		
		// Import
		require get_template_directory() . '/rslib/import/rst-import-data-demo.php';
		
		// Plugins
		require get_template_directory() . '/inc/plugins/setup-plugins.php';
		
		// Sidebar
		require get_template_directory() . '/inc/sidebar/class-sidebar-generator.php';
		if( class_exists( 'avia_sidebar' ) ) { 
			new avia_sidebar();
		}
		
		
		// Add Widgets
		require get_template_directory() . '/inc/widget/social-network.php';
		require get_template_directory() . '/inc/widget/news-tab.php';
		require get_template_directory() . '/inc/widget/post-list.php';
		require get_template_directory() . '/inc/widget/posts-smart-box.php';
		require get_template_directory() . '/inc/widget/twitter.php';
		require get_template_directory() . '/inc/widget/ads.php';
		require get_template_directory() . '/inc/widget/about.php';
		require get_template_directory() . '/inc/widget/widget-post.php';
		
		// ajax block/blog
		require get_template_directory() . '/inc/block.php';
		require get_template_directory() . '/inc/post-menu.php';
		require get_template_directory() . '/inc/blog.php';
		
		// ajax block
		require get_template_directory() . '/inc/ajax_action.php';
		
		
	function ublog_init() {
		
		// Customizer
		require get_template_directory() . '/inc/add-customizer.php';
		
		// Import/Export theme options
		require get_template_directory() . '/inc/import_data.php';
		
		// Add custom field
		require get_template_directory() . '/inc/custom-fields/post-formats.php';
		require get_template_directory() . '/inc/custom-fields/page-template.php';
		require get_template_directory() . '/inc/custom-fields/user.php';
		require get_template_directory() . '/inc/custom-fields/term.php';
		
	}
	add_action('init','ublog_init', 6);
	/**
	 * Set the content width based on the theme's design and stylesheet.
	 */
	if ( ! isset( $content_width ) ) {
		$content_width = 1020; /* pixels */
	}

	

	if ( class_exists('WPBakeryVisualComposerAbstract') ) {
		// Add Type
		require get_template_directory() . '/vc_extend/type/ublog_type.php';
		
		// Add Shortcode
		require get_template_directory() . '/vc_extend/breaking.php';
		require get_template_directory() . '/vc_extend/large.php';
		require get_template_directory() . '/vc_extend/box.php';
		require get_template_directory() . '/vc_extend/grid.php';
		require get_template_directory() . '/vc_extend/medium.php';
		require get_template_directory() . '/vc_extend/vertical.php';
		require get_template_directory() . '/vc_extend/horizontal-01.php';
		require get_template_directory() . '/vc_extend/horizontal-02.php';
		require get_template_directory() . '/vc_extend/scroll.php';
		require get_template_directory() . '/vc_extend/smart-box-01.php';
		require get_template_directory() . '/vc_extend/smart-box-02.php';
		require get_template_directory() . '/vc_extend/smart-box-03.php';
		// require get_template_directory() . '/vc_extend/smart-box-04.php';
	}

	function rst_is_ajax(){
		return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
	}

	
	function rst_backend_enqueue() {
		wp_enqueue_style( 'my_custom_script', esc_url( get_template_directory_uri() ) .'/inc/css/style-backend.css' );
	}
	add_action( 'admin_enqueue_scripts', 'rst_backend_enqueue', 10000 );
	
	
	function rst_scripts() {
		
		wp_enqueue_script( 'rst-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

		wp_enqueue_script( 'rst-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		/* Enqueue Script Awesome Photography on Header */
		wp_enqueue_script( 'jquery-header', esc_url( get_template_directory_uri()) . '/js/header.js', 'jquery', '', false );
		if( !get_theme_mod('rst_header_is_off_sticky') ) {
			wp_enqueue_script( 'jquery-header-sticky', esc_url( get_template_directory_uri()) . '/js/header-sticky.js', 'jquery', '', false );
		}
		wp_enqueue_script( 'jquery-html5shiv', esc_url( get_template_directory_uri()) . '/js/html5shiv-printshiv.js', 'jquery', '', false );
		wp_enqueue_script( 'jquery-bxslider', esc_url( get_template_directory_uri()) . '/js/bxslider/jquery.bxslider.min.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-backstretch', esc_url( get_template_directory_uri()) . '/js/jquery.backstretch.min.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-bootstrap', esc_url( get_template_directory_uri()) . '/js/bootstrap.min.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-holder', esc_url( get_template_directory_uri()) . '/js/holder.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-stickit', esc_url( get_template_directory_uri()) . '/js/jquery.stickit.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-stickit-kit', esc_url( get_template_directory_uri()) . '/js/jquery.sticky-kit.js', 'jquery', '', true );
		wp_enqueue_script( 'js-fancybox', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.js', 'jquery', '', true );
		wp_enqueue_script( 'js-fancybox-media', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-media.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-pgwslider', esc_url( get_template_directory_uri()) . '/js/PgwSlider-master/pgwslider.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-isotope', esc_url( get_template_directory_uri()) . '/js/isotope.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-royalslider', esc_url( get_template_directory_uri()) . '/js/royalslider/jquery.royalslider.min.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-fitvids', esc_url( get_template_directory_uri()) . '/js/jquery.fitvids.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-picturefill', esc_url( get_template_directory_uri()) . '/js/picturefill.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-vticker', esc_url( get_template_directory_uri()) . '/js/jquery.vticker.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-custom', esc_url( get_template_directory_uri()) . '/js/custom.js', 'jquery', '', true );
		wp_enqueue_script( 'jquery-ajax', esc_url( get_template_directory_uri()) . '/js/ajax.js', 'jquery', '', true );
		wp_enqueue_script('wp-mediaelement');
		
	}
	add_action( 'wp_enqueue_scripts', 'rst_scripts' );
	
	function rst_styles() {
		/* Bootstrap & Awesome Font */
		wp_enqueue_style( 'style-bootstrap', esc_url( get_template_directory_uri()) .'/css/bootstrap.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-pgwSlider', esc_url( get_template_directory_uri()) .'/js/PgwSlider-master/pgwslider.min.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-bxslider', esc_url( get_template_directory_uri()) .'/js/bxslider/jquery.bxslider.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-rswp', esc_url( get_template_directory_uri()) .'/css/rs-wp-v1.2.css','', '2015', 'screen', true );
		wp_enqueue_style( 'css-fancybox', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.css' );
		wp_enqueue_style( 'style-royalslider', esc_url( get_template_directory_uri()) .'/js/royalslider/royalslider.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-royalslider-default', esc_url( get_template_directory_uri()) .'/js/royalslider/skins/default/rs-default.css','', '2015', 'screen', true );
		wp_enqueue_style( 'font-awesome', esc_url( get_template_directory_uri()) .'/fonts/awesome/font-awesome.css','', '2015', 'screen', true );
		wp_enqueue_style('wp-mediaelement');
		
		/* Custom CSS */
		wp_enqueue_style( 'style-header', esc_url( get_template_directory_uri()) .'/css/header.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-main', esc_url( get_template_directory_uri()) .'/css/style.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-header-response', esc_url( get_template_directory_uri()) .'/css/header-response.css','', '2015', 'screen', true );
		wp_enqueue_style( 'style-responsiveness', esc_url( get_template_directory_uri()) .'/css/different-device.css','', '2015', 'screen', true );
		
		wp_enqueue_style( 'style', esc_url( get_stylesheet_uri()) );
	}
	add_action( 'wp_enqueue_scripts', 'rst_styles',9 );
	function rst_jquery_block() {
		echo "<script type='text/javascript'>
		function rst_blocks() {
			this.atts = '';
			this.url = '';
		}
		</script>";
	}
	add_action('wp_head', 'rst_jquery_block', 10);
	
	function rst_load_fonts() {
		wp_register_style('googleFonts-Open-Sans', 'http://fonts.googleapis.com/css?family=Open+Sans:400,400italic,600,700');
		wp_register_style('googleFonts-Lato', 'http://fonts.googleapis.com/css?family=Lato:400,700,900');
		wp_enqueue_style( 'googleFonts-Open-Sans');
		wp_enqueue_style( 'googleFonts-Lato');
	}
    
    add_action('wp_print_styles', 'rst_load_fonts');
	
	
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Ublog, use a find and replace
	 * to change 'ublog' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'ublog', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );
	
	add_editor_style();

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'top-header' => __( 'Top Header Menu', 'ublog' ),
		'primary' => __( 'Primary Menu', 'ublog' )
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'gallery', 'image', 'video', 'audio' 
	) );

	
	function rst_get_my_widgets() {
		$sidebar_options = array(
			'0' => 'Select Widget'
		);
		foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar) {
			$sidebar_options[$sidebar['id']] = $sidebar['name'];
		}
		return $sidebar_options;
	}

	add_action('init','rst_get_my_widgets');
	
		
	/**
	 * Register widget area.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
	 */
	 register_sidebar( array(
		'name'          => 'Default Sidebar',
		'id'            => 'sidebar-default',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	
	
	 register_sidebar( array(
		'name'          => 'Home Sidebar',
		'id'            => 'sidebar-home',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	 
	function rst_ublog_widgets_init() {
		for( $key=1;$key<=4;$key++ ) {
			register_sidebar( array(
				'name'          => 'Footer Column '.$key,
				'id'            => 'sidebar-footer-'.$key,
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			) );
		}
	}
	add_action( 'widgets_init', 'rst_ublog_widgets_init' );

	
	/**
	 * Implement the Custom Header feature.
	 */
	//require get_template_directory() . '/inc/custom-header.php';

	/**
	 * Custom template tags for this theme.
	 */
	require get_template_directory() . '/inc/template-tags.php';

	/**
	 * Custom functions that act independently of the theme templates.
	 */
	require get_template_directory() . '/inc/extras.php';

	/**
	 * Customizer additions.
	 */
	require get_template_directory() . '/inc/customizer.php';

	/**
	 * Load Jetpack compatibility file.
	 */
	require get_template_directory() . '/inc/jetpack.php';


	/**
	 * Function Format Date.
	 */
	function get_post_date(){
		global $post;
		if($post)
		return mysql2date('F d, Y', $post->post_date);
	}

	function ub_get_template_part( $slug, $name ) {
		ob_start();
		get_template_part( $slug, $name );
		return ob_get_clean();
	}

	/*
	 * Function Count View
	 */
	function ub_set_post_views($postID) {
		$count_key = 'ub_post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '1');
		}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
		}
	}
	function ub_track_post_views ($post_id) {
		if ( !is_single() ) return;
		if ( empty ( $post_id) ) {
			global $post;
			$post_id = $post->ID;    
		}
		ub_set_post_views($post_id);
	}

	//To keep the count accurate, lets get rid of prefetching
	add_action( 'wp_head', 'ub_track_post_views');

	function ub_get_post_views($postID){
		$count_key = 'ub_post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count=='' || $count <= 1 ){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '1');
			return 1;
		}
		return $count;
	}

	
	/**
	 * Translate.
	 */
	function rst_the_translate($text,$options_text) {
		$options_text = get_theme_mod($options_text);
		if($options_text) $text = $options_text;
		echo force_balance_tags($text);
	}
	
	function rst_get_translate($text,$options_text){
		$options_text = get_theme_mod($options_text);
		if($options_text) $text = $options_text;
		return force_balance_tags($text);
	}
	
	function rst_get_categories_ids($slug) {
		$str = '';
		$array_slug = explode(',',$slug);
		if( is_array($array_slug) ) {
			foreach($array_slug as $item) {
				$term = get_term_by('slug', $item, 'category');
				if( $term ) $str .= $term->term_id .',';
			}
		}
		return $str;
	}

	/**
	 * Function Get Excerpt.
	 */
	function rst_new_excerpt_more($more) {
		return ' ';
	}
	add_filter('excerpt_more', 'rst_new_excerpt_more');

	function get_excerpt_by_id($post, $length = 10, $tags = '<a><em><strong>', $extra = '...') {
		if(is_int($post)) {
			$post = get_post($post);
		} elseif(!is_object($post)) {
			return false;
		}
		setup_postdata($post);

		$the_excerpt = apply_filters( 'get_the_excerpt', $post->post_excerpt );
		
		$the_excerpt = strip_shortcodes(strip_tags($the_excerpt), $tags);
		
		$the_excerpt = preg_split('/\b/', $the_excerpt, $length * 2+1);
		$excerpt_waste = array_pop($the_excerpt);
		$the_excerpt = implode($the_excerpt);
		if( $the_excerpt != '' )
		$the_excerpt .= $extra;
		wp_reset_postdata();
		return apply_filters('the_content', $the_excerpt);
		
	}

	function ub_get_attachment_image_src( $attributes_id, $size ){
		$attributes = wp_get_attachment_image_src( $attributes_id, $size );
		return $attributes[0];
	}

	/* Setup Media */
	function ub_after_switch_theme(){
		//image size
		if ( function_exists( 'add_image_size' ) ) { 
			update_option('large_size_w', 1024);
			update_option('large_size_h', 720);
			update_option('medium_size_w', 320);
			update_option('medium_size_h', 192);
			update_option('thumbnail_size_w', 235);
			update_option('thumbnail_size_h', 164);
		}
	}
	add_action('after_switch_theme', 'ub_after_switch_theme');

	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size( 'ub_medium', '600', '360', true );
	}

	function rst_get_icon_postformat($post_id = 1) {
		if( get_post_format( $post_id ) == 'video' )
			return '<i class="fa fa-play-circle"></i>';
		if( get_post_format( $post_id ) == 'quote' )
			return '<i class="fa fa-quote-left"></i>';
		if( get_post_format( $post_id ) == 'link' )
			return '<i class="fa fa-link"></i>';
		if( get_post_format( $post_id ) == 'audio' )
			return '<i class="fa fa-music"></i>';
		if( get_post_format( $post_id ) == 'gallery' )
			return '<i class="fa fa-photo"></i>';
	}
	
	function ub_query_shortcode($ub_agrs) {
		$my_page = max( get_query_var('paged'), get_query_var('page'), 1);
		$args = array(
			'paged' 			=> $my_page,
			'posts_per_page'   	=> $ub_agrs['posts_per_page'],
			'order'            	=> $ub_agrs['order']
		);
		if( isset($ub_agrs['category']) )
			$args['category_name'] = $ub_agrs['category'];
		
		if( isset($ub_agrs['offset']) )
			$args['offset'] = $ub_agrs['offset'];
		
		if( isset($ub_agrs['suppress_filters']) )
			$args['suppress_filters'] = $ub_agrs['suppress_filters'] == 1 ? true : false ;
		
		if( isset($ub_agrs['tags']) )
			$args['tag'] = $ub_agrs['tags'];
		
		if( $ub_agrs['order_by'] == 'title' || $ub_agrs['order_by'] == 'date' || $ub_agrs['order_by'] == 'rand' )
			$args['orderby'] = $ub_agrs['order_by'];
			
		if( $ub_agrs['order_by'] == 'popular' ) {
			$args['meta_key'] = 'ub_post_views_count';
			$args['orderby'] = 'meta_value_num';
		}
		
		if( $ub_agrs['order_by'] == 'popular_week' ) {
			$args['meta_key'] = 'ub_post_views_count';
			$args['orderby'] = 'meta_value_num';
			$args['ignore_sticky_posts'] = 1;
			$args['date_query'] = array(
				array(
					'year' => date( 'Y' ),
					'week' => date( 'W' ),
				)
			);
		}
		
		if( $ub_agrs['order_by'] == 'popular_month' ) { 
			$args['meta_key'] = 'ub_post_views_count';
			$args['orderby'] = 'meta_value_num';
			$args['ignore_sticky_posts'] = 1;
			$args['date_query'] = array(
				array(
					'year' => date( 'Y' ),
					'month' => date( 'n' ),
				)
			);
		}
		
		if( $ub_agrs['order_by'] == 'high_rated' ) { 
			$args['meta_key'] = 'ub_post_rating_point_round';
			$args['orderby'] = 'meta_value_num';
		}
		return $args;
	}

	function rsthemes_get_iframe_postformat_video($post_id = 1) {
		global $post;
		if( !empty($post_id) )
			$post_id = $post->ID;
		$type = rs::getField('ublog_video_type',$post_id);
		$embed = rs::getField('ublog_video_embed',$post_id);
		$width = rs::getField('ublog_video_width',$post_id);
		$height = rs::getField('ublog_video_height',$post_id);
		$src = rs::getField('ublog_video_upload',$post_id,'video','url');
		$thumb = wp_get_attachment_url(get_post_thumbnail_id($post_id));
		if( get_post_format( $post_id ) != 'video' ) return;
		if( $type == 'youtube' && $embed != '' )
			return '<div class="ub-iframe"><iframe width="'. ($width ? absint($width) : '') .'" height="'. ($height ? absint($height) : '') .'" src="http://www.youtube.com/embed/'. esc_html($embed) .'" frameborder="0" allowfullscreen></iframe></div>';
		if( $type == 'vimeo' && $embed != '' )
			return '<div class="ub-iframe"><iframe src="http://player.vimeo.com/video/'. esc_html($embed) .'" width="'. ($width ? absint($width) : '') .'" height="'. ($height ? absint($height) : '') .'" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>';
		if( $type == 'upload' && $src )
			return do_shortcode('[video poster="'. esc_url($thumb) .'" src="'. esc_url($src) .'" ]');
		return 0;
	}
	
	
	function rst_display_post_information($slider=false) {
		global $ub_agrs, $post;
		echo '<div class="ub-post-infor">';
			if( 
				($ub_agrs['is_show_author'] && $slider == false) || 
				( !get_theme_mod('singe_hide_author')&& is_single() ) || 
				( !isset($ub_agrs['is_show_author']) && !get_theme_mod('rst_cat_is_hide_author')&& ( is_archive() || is_home() || is_front_page() ) ) ||
				( is_search() && !get_theme_mod('rst_search_is_hide_author') )
			) { ?>
		<span class="admin">by <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author_meta( 'display_name', get_the_author_meta( 'ID' ) ); ?></a></span>
		<?php }
			if( 
				($ub_agrs['is_show_author'] && $slider == true )
			) { ?> 
		<span class="admin">by <?php echo get_the_author_meta( 'display_name', get_the_author_meta( 'ID' ) ); ?></span>
		<?php } ?>
		<?php
			$tempURL = get_day_link(mysql2date('Y', $post->post_date),mysql2date('m', $post->post_date),mysql2date('j', $post->post_date));
			$tempDate = sprintf('%1$d-%2$02d-%3$02d 00:00:00', mysql2date('Y', $post->post_date), mysql2date('m', $post->post_date), mysql2date('j', $post->post_date));
			$tempText = mysql2date('F d, Y', $tempDate);
		?>
		<?php 
			if( 
				($ub_agrs['is_show_date'] && $slider == false) || 
				( !get_theme_mod('singe_hide_date') && is_single() ) || 
				( !isset($ub_agrs['is_show_date']) && !get_theme_mod('rst_cat_is_hide_date')&& ( is_archive() || is_home() || is_front_page() ) ) ||
				( is_search() && !get_theme_mod('rst_search_is_hide_date') )
			) { ?>
		<span class="date"><?php echo get_archives_link($tempURL, $tempText, 'custom', '', ''); ?></span>
		<?php }
		if( ($ub_agrs['is_show_date'] && $slider == true ) ) { ?>
		<span class="date"><?php echo get_post_date() ?></span>
		<?php } ?>
		<?php 
			if( 
				$ub_agrs['is_show_categories'] || 
				( !get_theme_mod('singe_hide_category') && is_single() ) || 
				( !isset($ub_agrs['is_show_categories']) && !get_theme_mod('rst_cat_is_hide_category')&& ( is_archive() || is_home() || is_front_page() ) ) ||
				( is_search() && !get_theme_mod('rst_search_is_hide_category') )
			) { ?>
		<span class="category"> <i class="fa fa-tag"></i> <?php the_category( ', ' ); ?></span>
		<?php } ?>
		<?php 
			if( 
				$ub_agrs['is_show_comment'] || 
				( !get_theme_mod('singe_hide_comment') && is_single() ) || 
				( !isset($ub_agrs['is_show_comment']) && !get_theme_mod('rst_cat_is_hide_comment')&& ( is_archive() || is_home() || is_front_page() ) ) ||
				( is_search() && !get_theme_mod('rst_search_is_hide_comment') )
			) { ?>
		<span class="comment"> <a href="<?php echo get_permalink(get_the_ID()) ?>/#comments"><i class="fa fa-comments"></i> <?php comments_number('0', '1', '%');?></a></span>
		<?php } ?>
		<?php 
			if( 
				$ub_agrs['is_show_view'] || 
				( !get_theme_mod('singe_hide_view') && is_single() ) || 
				( !isset($ub_agrs['is_show_view']) && !get_theme_mod('rst_cat_is_hide_view') && ( is_archive() || is_home() || is_front_page() ) ) ||
				( is_search() && !get_theme_mod('rst_search_is_hide_view') )
			) { ?>
		<span class="view"> <i class="fa fa-eye"></i> <?php echo ub_get_post_views(get_the_ID()) ?></span>
		<?php }
		echo '</div>';
	}

	if ( ! function_exists( 'string_limit_words' ) ) :
	function string_limit_words($string, $word_limit) {
		$words = explode(' ', $string, ($word_limit + 1));

		if(count($words) > $word_limit) {
			array_pop($words);
		}

		return implode(' ', $words);
	}
	endif;
	
	/**
	 * Paging Nav.
	 */
	function rst_paging_nav(){
		global $wp_query;
		$tf_big = 999999999;
		$my_page = max( get_query_var('paged'), get_query_var('page') );
		$tf_paginate_links = paginate_links( array(
			'base' => str_replace( $tf_big, '%#%', esc_url( get_pagenum_link( $tf_big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, $my_page ),
			'total' => $wp_query->max_num_pages,
			'prev_text'    => __('&#171;','yup'),
			'next_text'    => __('&#187;','yup'),
			'type'			=> 'array'
		 ));
		
		if( is_array( $tf_paginate_links ) ) {
			$paged = ( $my_page == 0 ) ? 1 : $my_page;
			echo '<ul class="wp-pagenavi">';
			foreach ( $tf_paginate_links as $page ) {
				echo force_balance_tags($page);
			}
			echo '</ul>';
		}
	}
	
	/**
	 * Paging Nav Vc.
	 */
	function workaroundpaginationampersandbug($link) {
		return str_replace('#038;', '&', $link);
	}
	add_filter('paginate_links', 'workaroundpaginationampersandbug');
	
	function rst_paging_nav_vc($wp_query,$ub_agrs,$rstkey=0){
		$html = '';
		global $paged;
		if( $ub_agrs['is_show_pavi'] == 'number' ) {
			$tf_big = 999999999;
			$my_page = max( get_query_var('paged'), get_query_var('page') );
			$tf_paginate_links = paginate_links( array(
				'base' => str_replace( $tf_big, '%#%', esc_url( get_pagenum_link( $tf_big ) ) ),
				'format' => '?paged=%#%',
				'current' => max( 1, $my_page ),
				'total' => $wp_query->max_num_pages,
				'prev_text'    => __('&#171;','yup'),
				'next_text'    => __('&#187;','yup'),
				'type'			=> 'array'
			 ));
			
			if( is_array( $tf_paginate_links ) ) {
				$paged = ( $my_page == 0 ) ? 1 : $my_page;
				$html .= '<ul class="wp-pagenavi">';
				foreach ( $tf_paginate_links as $page ) {
					$html .= $page;
				}
				$html .= '</ul>';
			}
		}
		if( $ub_agrs['is_show_pavi'] == 'next_prev' ) {
			ob_start();
			$args = ub_query_shortcode($ub_agrs);
			if ( $wp_query->max_num_pages > 1 ) :  ?>
			
			<nav class="row navigation" role="navigation">
				<div class="col-sm-6 nav-previous"><?php previous_posts_link( '<i class="fa fa-angle-double-left"></i> Prev Page', $wp_query ->max_num_pages ); ?></div>
				<div class="col-sm-6 nav-next"><?php next_posts_link( 'Next Page <i class="fa fa-angle-double-right"></i>', $wp_query ->max_num_pages ); ?></div>
			</nav>
			
			<?php endif;
			$html .= ob_get_contents();
			ob_end_clean();
		}
		if( $ub_agrs['is_show_pavi'] == 'load_more' ) {
			if( $wp_query->max_num_pages > 1 ) {
				$html .= '<a href="javascript:;" data-paged="2" data-disable="0"  data-max-paged="'. $wp_query->max_num_pages .'" data-key="rst_'. $rstkey .'" class="rst_ajax_load_more"><i class="fa fa-spinner fa-pulse"></i><span>Load more</span></a>';
			}
		}
		
		if( $ub_agrs['is_show_pavi'] == 'load_auto' ) {
			if( $wp_query->max_num_pages > 1 ) {
				$html .= '<a href="javascript:;" data-paged="2" data-disable="0" data-max-paged="'. $wp_query->max_num_pages .'" data-key="rst_'. $rstkey .'" class="rst_ajax_load_more rst_auto_load"><i class="fa fa-spinner fa-pulse"></i></a>';
			}
		}
		
		return $html;
	}
	
	
	
	function rst_get_menu() {
		$array_menu = array();
		$menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
		if( is_array($menus) && sizeof($menus) ){
			foreach( $menus as $menu ) {
				$array_menu[$menu->name] = $menu->name;
			}
		}
		return $array_menu;
	}
	
	if ( ! function_exists( 'formatWithSuffix' ) ) {
		function formatWithSuffix($input) {
			$suffixes = array('', 'K', 'M', 'G', 'T');
			$suffixIndex = 0;

			while(abs($input) >= 1000 && $suffixIndex < sizeof($suffixes))
			{
				$suffixIndex++;
				$input /= 1000;
			}
			return (
				$input > 0
					// precision of 3 decimal places
					? floor(floor($input) * 1000) / 1000
					: ceil(floor($input) * 1000) / 1000
				)
				. $suffixes[$suffixIndex];
		}
	}
	
	if ( ! function_exists( 'the_sub_categories' ) ) {
		function the_sub_categories($before='<div class="ub-sub-categories">',$after='</div>') {
			if( !is_category() ) return;
			$html = '';
			$categories = get_categories( array('child_of'=>get_query_var('cat')) );
			if( sizeof($categories) ) {
				$html = $before.'Sub Categories: ';
				foreach( $categories as $key=>$cat ) {
					$html .= '<a href="' . get_category_link( $cat->term_id ) . '">' . $cat->name . '</a>, ';
				}
				$html = rtrim($html, ", ");
				$html .= $after;
			}
			
			echo $html;
		}
	}
	
	function ub_get_the_archive_title() {
		if ( is_category() ) {
			$title = sprintf( __( '%s' ), single_cat_title( '', false ) );
		} elseif ( is_tag() ) {
			$title = sprintf( __( '%s' ), single_tag_title( '', false ) );
		} elseif ( is_author() ) {
			$title = '';
		} elseif ( is_year() ) {
			$title = rst_get_translate('Yearly Archives','yearly_archives').': '. get_the_date( 'Y');
		} elseif ( is_month() ) {
			$title = rst_get_translate('Monthly Archives','monthly_archives').': '. get_the_date( 'F Y');
		} elseif ( is_day() ) {
			$title = rst_get_translate('Daily Archives','daily_archives').': '. get_the_date( 'F j, Y');
		} elseif ( is_tax( 'post_format' ) ) {
			if ( is_tax( 'post_format', 'post-format-aside' ) ) {
				$title = _x( 'Asides', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
				$title = _x( 'Galleries', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
				$title = _x( 'Images', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
				$title = _x( 'Videos', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
				$title = _x( 'Quotes', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
				$title = _x( 'Links', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
				$title = _x( 'Statuses', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
				$title = _x( 'Audio', 'post format archive title' );
			} elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
				$title = _x( 'Chats', 'post format archive title' );
			}
		} elseif ( is_post_type_archive() ) {
			$title = sprintf( __( 'Archives: %s' ), post_type_archive_title( '', false ) );
		} elseif ( is_tax() ) {
			$tax = get_taxonomy( get_queried_object()->taxonomy );
			/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
			$title = sprintf( __( '%1$s: %2$s' ), $tax->labels->singular_name, single_term_title( '', false ) );
		} else {
			$title = __( 'Archives' );
		}
	 
		/**
		 * Filter the archive title.
		 *
		 * @since 4.1.0
		 *
		 * @param string $title Archive title to be displayed.
		 */
		return apply_filters( 'get_the_archive_title', $title );
	}
	
	if ( ! function_exists( 'the_author_box' ) ) {
		function the_author_box() {
			$user_info = get_userdata(get_the_author_meta( 'ID' ));
			global $wpdb;
			if( is_author() )
				$size_author = 140;
			else 
				$size_author = 90;
		?>
		<div class="ub-author-box">
			<div class="ub-author">
				<div class="author-thumbnail">
					<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), $size_author ); ?></a>
				</div><!--End-post-thumbnail-->
				<div class="info-author">
					<h4><span><?php echo (is_object($user_info) && !empty($user_info->display_name)) ? esc_html($user_info->display_name) : '' ?> </span><?php echo ( rs::getField('ublog_user_job','user_'.get_the_author_meta( 'ID' )) ? '- '.rs::getField('ublog_user_job','user_'.get_the_author_meta( 'ID' )) : '' ); ?></h4>
					<?php
						$comment_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) AS total FROM $wpdb->comments WHERE comment_approved = 1 AND user_id = %s", get_the_author_meta( 'ID' )));
						if( is_author() ) {
					?>
					<p>Writed <?php echo count_user_posts(get_the_author_meta( 'ID' )) ?> posts and <?php echo absint($comment_count) ?> comments</p>
					<?php } ?>
					<?php echo apply_filters('the_content', get_the_author_meta( 'description', get_the_author_meta( 'ID' ) )); ?>
					<div class="ub-author-link">
						<?php if( get_the_author_meta( 'url', get_the_author_meta( 'ID' ) ) ) { ?>
						<a href="<?php echo get_the_author_meta( 'url', get_the_author_meta( 'ID' ) ) ?>"><i class="fa fa-home"></i></a>
						<?php } ?>
						<?php if( rs::getField('ublog_user_facebook','user_'.get_the_author_meta( 'ID' )) ) { ?>
						<a target="_blank" href="<?php echo rs::getField('ublog_user_facebook','user_'.get_the_author_meta( 'ID' )) ?>"><i class="fa fa-facebook"></i></a>
						<?php } ?>
						<?php if( rs::getField('ublog_user_twitter','user_'.get_the_author_meta( 'ID' )) ) { ?>
						<a target="_blank" href="<?php echo rs::getField('ublog_user_twitter','user_'.get_the_author_meta( 'ID' )) ?>"><i class="fa fa-twitter"></i></a>
						<?php } ?>
						<?php if( rs::getField('ublog_user_google','user_'.get_the_author_meta( 'ID' )) ) { ?>
						<a target="_blank" href="<?php echo rs::getField('ublog_user_google','user_'.get_the_author_meta( 'ID' )) ?>"><i class="fa fa-google-plus"></i></a>
						<?php } ?>
						<?php if( rs::getField('ublog_user_linkedin','user_'.get_the_author_meta( 'ID' )) ) { ?>
						<a target="_blank" href="<?php echo rs::getField('ublog_user_linkedin','user_'.get_the_author_meta( 'ID' )) ?>"><i class="fa fa-linkedin"></i></a>
						<?php } ?>
					</div>
				</div><!--End-info-post-->
			</div>
		</div><!--End-author-box-->
		<?php
		}
	}
	add_filter( 'request', 'alter_the_query' );
	function alter_the_query( $request ) {
		if( isset($request['cat']) && !(is_admin()) ){
			$request['posts_per_page'] = 1;
		}
		return $request;
	}
	
	function rst_lightbox_regex($content){
        global $post;
		if( !is_object($post) ) return $content;
		
		$html = '<span class="inner-share ub-share-this">';
		if( !get_theme_mod('share_twitter') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="http://twitter.com/share?text='. str_replace(" ", "%20", $post->post_title) .'&url='. get_permalink($post->ID) .'"><i class="fa fa-twitter"></i></a>';
		}
		if( !get_theme_mod('share_facebook') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="http://www.facebook.com/sharer/sharer.php?s=100&p[url]='. get_permalink($post->ID) .'&p[title]='. str_replace(" ", "%20", $post->post_title) .'"><i class="fa fa-facebook"></i></a>';
		}
		if( !get_theme_mod('share_google') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="https://plus.google.com/share?url='. get_permalink($post->ID) .'"><i class="fa fa-google-plus"></i></a>';
		}
		if( !get_theme_mod('share_pinterest') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="https://pinterest.com/pin/create/button/?url='. get_permalink($post->ID) .'" ><i class="fa fa-pinterest"></i></a>';
		}
		if( !get_theme_mod('share_linkedin') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="http://www.linkedin.com/shareArticle?mini=true&url='. get_permalink($post->ID) .'&title='. str_replace(" ", "%20", $post->post_title) .'&source=LinkedIn"><i class="fa fa-linkedin"></i></a>';
		}
		if( !get_theme_mod('share_tumblr') ) {
			$html .= '<a onclick="javascript:window.open(this.href,
\'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600\');return false;" href="http://www.tumblr.com/share/link?url='. get_permalink($post->ID) .'&name='. str_replace(" ", "%20", $post->post_title) .'"><i class="fa fa-tumblr"></i></a>';
		}
		
		$html .= '</span>';
		
		$content = preg_replace("/(<a(?![^>]*?rel=['\"]lightbox.*)[^>]*?href=['\"][^'\"]+?\.(?:gif|jpg|jpeg|png)\?{0,1}\S{0,}['\"].*<\/a>)/i" , '<span class="wrap-share"> '. $html .' $1 </span>', $content); 
		
		$content = preg_replace("/(<a(?![^>]*?rel=['\"]lightbox.*)[^>]*?href=['\"][^'\"]+?\.(?:gif|jpg|jpeg|png)\?{0,1}\S{0,}['\"][^\>]*)>/i" , '$1 class="fancybox" rel="gallery['.$post->ID.']">', $content); 
		
		
		
        return $content;
    }
		 
	add_filter('the_content', 'rst_lightbox_regex', 1000);

	add_action('pre_get_posts', 'myprefix_query_offset', 1 );
	function myprefix_query_offset(&$query) {

		//Before anything else, make sure this is the right query...
		if ( ! $query->is_posts_page ) {
			return;
		}

		//First, define your desired offset...
		$offset = 10;
		
		//Next, determine how many posts per page you want (we'll use WordPress's settings)
		$ppp = get_option('posts_per_page');

		//Next, detect and handle pagination...
		if ( $query->is_paged ) {

			//Manually determine page query offset (offset + current page (minus one) x posts per page)
			$page_offset = $offset + ( ($query->query_vars['paged']-1) * $ppp );

			//Apply adjust page offset
			$query->set('offset', $page_offset );

		}
		else {

			//This is the first page. Just use the offset...
			$query->set('offset',$offset);

		}
	}
	
	// $posts = get_posts("posts_per_page=-1");
	// foreach( $posts as $item ) {
		// $my_post = array(
			// 'ID'           => $item->ID,
		  // 'post_content' => '',
	  // );

	// // Update the post into the database
	  // wp_update_post( $my_post );
	// }
	
}
endif; // rst_ublog_setup
add_action( 'after_setup_theme', 'rst_ublog_setup' );
add_action('wp_before_admin_bar_render', 'bloglite_adminbar_logo', 0);
function bloglite_adminbar_logo() { ?>
   <style type="text/css">
      #wpadminbar #wp-admin-bar-wp-logo > .ab-item .ab-icon:before {
         content: url('http://www.radiosfarcom.com.br/wp-content/uploads/2017/04/logofm.png') !important;
         top: 2px;
      }
      #wpadminbar #wp-admin-bar-wp-logo > a.ab-item {
         pointer-events: none;
         cursor: default;
      } 
   </style>
<?php }