<?php
function rst_display_block($agrs,$term=0) {
	$args = ub_query_shortcode($agrs);
	global $ub_agrs;
	$ub_agrs = $agrs;
	/*----- Vertical -----*/
	if( $agrs['type'] == 'vertical' ) :
		$the_query = new WP_Query( $args );
		ob_start();
	?>
		<div class="wrap-horizontal-news ub-vertical <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
		<?php
			if( !empty($agrs['title']) )
				echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
			$rst_key = 0;
		?>
				<div class="row horizontal-news">
			<?php 
				while ($the_query->have_posts() ) : $the_query->the_post();
					$rst_key++;
					if( $rst_key == 1 ){
				?>
					<div class="col-sm-12 item-horizontal-news ub-news-large">
						<?php if( get_post_thumbnail_id(get_the_ID()) ) { ?>
						<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
							<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'ub_medium' ) ?>">
							<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
						</a>
						<?php } ?>
						<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
						<?php rst_display_post_information() ?><div class="clear"></div>
						<?php
							if( $agrs['is_show_excerpt'] )
								echo get_excerpt_by_id(get_the_ID(),absint($agrs['excerpt_length']));
						?>
					</div>
				<?php
					}
					else {
						if( $rst_key == 2 ) echo '<div class="col-sm-12 list-item-horizontal-news">';
				?>
						<div class="row">
							<div class="col-sm-12 item-horizontal-news">
								<?php if( get_post_thumbnail_id(get_the_ID()) ) { ?>
								<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
									<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>">
									<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
								</a>
								<?php } ?>
								<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
								<?php rst_display_post_information() ?><div class="clear"></div>
							</div>
						</div>
				<?php
						if( $rst_key == $the_query->post_count ) echo '</div>';
					}
				endwhile;
				wp_reset_query(); wp_reset_postdata();
			?>
			</div>
		</div>
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
		
	endif;
	
	
	/*----- Horizontal 01 -----*/
	if( $agrs['type'] == 'horizontal_01' ) :
		$output = '';
		if( !empty($term) ) $agrs['category'] = $term;
		$args = ub_query_shortcode($agrs);
	
		$the_query = new WP_Query( $args );
		$rstkey = uniqid();
		ob_start();
		
		if( $agrs['is_show_thumbnail'] ) {
			$class_col_1 = 'col-sm-5';
			$class_col_2 = 'col-sm-7';
		}
		else {
			$class_col_1 = '';
			$class_col_2 = 'col-sm-12';
		}
		$rst_key = 0;
		if( rst_is_ajax() ){
	
			while ($the_query->have_posts() ) : $the_query->the_post();
				$rst_key++;
				global $post;
				if( $rst_key == 1 ){
		?>
				<div class="row ub-thumb-large">
					<div class="<?php echo sanitize_html_class($class_col_1) ?>">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
						<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large' ) ?>">
						<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
					</a>
					<?php } ?>
					</div>
					<div class="<?php echo sanitize_html_class($class_col_2) ?>">
						<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
						<?php rst_display_post_information() ?><div class="clear"></div>
						<?php
							if( $agrs['is_show_excerpt'] )
								echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
						?>
					</div>
				</div>
		<?php
				}
				else {
					if( $rst_key == 2 ) echo '<div class="row ub-list-thumb-small">';
		?>
					<div class="col-sm-<?php echo (12/absint($agrs['column'])) ?> ub-thumb-item">
						<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
						<a class="thumbnail-small thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
							<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>" />
							<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
						</a>
						<?php } ?>
						<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
						<?php rst_display_post_information() ?><div class="clear"></div>
					</div>
		<?php	
					if( ($rst_key-1)%absint($agrs['column']) == 0 ) echo '<div class="clear"></div>';
					if( $rst_key == $the_query->post_count ) echo '</div>';
				}
			endwhile;
			wp_reset_query(); wp_reset_postdata();
		
			$output .= ob_get_contents();
			ob_end_clean();
			return $output;
		}
	?>
		<script type="text/javascript">
			var rst_<?php echo esc_html($rstkey) ?> = new rst_blocks();
			rst_<?php echo esc_html($rstkey) ?>.atts = '<?php echo json_encode($agrs) ?>';
			rst_<?php echo esc_html($rstkey) ?>.url = '<?php echo admin_url( "admin-ajax.php" ); ?>';
		</script>
		<div class="ub-box-thumb-news wrap-ajax ub-horizontal-01 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
			
		<?php
			echo '<div class="clearfix link">';
			if( !empty($agrs['title']) )
				echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
			if( $agrs['is_type_categories'] != '0' ) {
				echo '<ul class="ub-list-category">';
					echo '<li><a data-key="rst_'. esc_html($rstkey) .'" class="rst_ajax" rst_slug="all" rst_term="-1" href="#">All</a></li>';
					$rst_categories = get_categories( array('include' => rst_get_categories_ids($agrs['category']), 'hide_empty' => 1, 'orderby' => 'term_group' ) );
					if( is_array($rst_categories) && sizeof($rst_categories) ) {
						$rst_ajax = '';
						foreach( $rst_categories as $category ) {
							if( $agrs['is_type_categories'] == 'ajax' ) $rst_ajax = 'class="rst_ajax" rst_slug="'. $category->slug .'" rst_term="'. $category->slug .'"';
							echo '<li><a data-key="rst_'. esc_html($rstkey) .'" '. $rst_ajax .' href="'. esc_url(get_category_link( $category->term_id )) .'">'. esc_html($category->name) .'</a></li>';
						}
					}
				echo '</ul>';
			}
			echo '</div>';
			$rst_key = 0;
			
		?>
		<div class="wrap-content-ajax">
			<div class="ub-loading">
				<div class="loader">
					<p><b>LOADING</b></p>
					<span></span>
					<span></span>
					<span></span>
				</div>
			</div>
			<div id="<?php echo 'rst_'.esc_html($rstkey) ?>-all" class="tab-ajax">
		<?php
			while ($the_query->have_posts() ) : $the_query->the_post();
				$rst_key++;
				global $post;
				if( $rst_key == 1 ){
		?>
				<div class="row ub-thumb-large">
					<div class="<?php echo sanitize_html_class($class_col_1) ?>">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
						<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large' ) ?>">
						<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
					</a>
					<?php } ?>
					</div>
					<div class="<?php echo sanitize_html_class($class_col_2) ?>">
						<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
						<?php rst_display_post_information() ?><div class="clear"></div>
						<?php
							if( $agrs['is_show_excerpt'] )
								echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
						?>
					</div>
				</div>
		<?php
				}
				else {
					if( $rst_key == 2 ) echo '<div class="row ub-list-thumb-small">';
		?>
					<div class="col-sm-<?php echo (12/absint($agrs['column'])) ?> ub-thumb-item">
						<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
						<a class="thumbnail-small thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
							<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>" />
							<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
						</a>
						<?php } ?>
						<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
						<?php rst_display_post_information() ?><div class="clear"></div>
					</div>
		<?php	
					if( ($rst_key-1)%absint($agrs['column']) == 0 ) echo '<div class="clear"></div>';
					if( $rst_key == $the_query->post_count ) echo '</div>';
				}
			endwhile;
			wp_reset_query(); wp_reset_postdata();
		?>
			</div>
		</div>
		</div>
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	
	/*----- Horizontal 02 -----*/
	if( $agrs['type'] == 'horizontal_02' ) :
		$output = '';
		if( !empty($term) ) $agrs['category'] = $term;
		$args = ub_query_shortcode($agrs);
		
		$the_query = new WP_Query( $args );
		ob_start();
		if( $agrs['column'] == 2 ) {
			$class_col_1 = 'col-sm-6';
			$class_col_2 = 'col-sm-6';
			$class_inner_col = 'col-sm-12';
		} else {
			$class_col_1 = 'col-sm-4';
			$class_col_2 = 'col-sm-8';
			$class_inner_col = 'col-sm-6';
		}
		$rstkey = uniqid();
		if( rst_is_ajax() ) {
	
			$rst_key = 0;
			while ($the_query->have_posts() ) : $the_query->the_post();
				$rst_key++;
				global $post;
				if( $rst_key == 1 ) {
		?>
			<div class="<?php echo sanitize_html_class($class_col_1) ?> item-horizontal-news ub-news-large">
				<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
				<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
					<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=> 1024, 'height' => 600) ) ?>">
					<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
				</a>
				<?php } ?>
				<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
				<?php rst_display_post_information() ?><div class="clear"></div>
				<?php
					if( $agrs['is_show_excerpt'] )
						echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
				?>
			</div>
		<?php } else {
			if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' list-item-horizontal-news"><div class="row">';
		?>
				<div class="<?php echo sanitize_html_class($class_inner_col) ?> item-horizontal-news">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
						<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>">
						<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
					</a>
					<?php } ?>
					<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
					<?php rst_display_post_information() ?><div class="clear"></div>
				</div>
		<?php 
				if( ($rst_key-1)%(absint($agrs['column'])-1) == 0 ) echo '<div class="clear"></div>';
			if( $rst_key == $the_query->post_count ) echo '</div></div>';
			} 
			endwhile;
			wp_reset_query(); wp_reset_postdata();
			
			$output .= ob_get_contents();
			ob_end_clean();
			return $output;
		}
	?>
		<script type="text/javascript">
			var rst_<?php echo esc_html($rstkey) ?> = new rst_blocks();
			rst_<?php echo esc_html($rstkey) ?>.atts = '<?php echo json_encode($agrs) ?>';
			rst_<?php echo esc_html($rstkey) ?>.url = '<?php echo admin_url( "admin-ajax.php" ); ?>';
		</script>
		<div class="ub-box-horizontal-news ub-horizontal-02 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
			<div class="wrap-horizontal-news wrap-ajax">
				<div class="clearfix link">
					<?php
					if( !empty($agrs['title']) )
						echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
					if( $agrs['is_type_categories'] != '0' ) {
						echo '<ul class="ub-list-category">';
							echo '<li><a data-key="rst_'. esc_html($rstkey) .'" class="rst_ajax" rst_slug="all" rst_term="-1" href="#">All</a></li>';
							$rst_categories = get_categories( array('include' => rst_get_categories_ids($agrs['category']), 'hide_empty' => 1, 'orderby' => 'term_group' ) );
							if( is_array($rst_categories) && sizeof($rst_categories) ) {
								$rst_ajax = '';
								foreach( $rst_categories as $category ) {
									if( $agrs['is_type_categories'] == 'ajax' ) $rst_ajax = 'class="rst_ajax" rst_slug="'. $category->slug .'" rst_term="'. $category->slug .'"';
									echo '<li><a data-key="rst_'. esc_html($rstkey) .'" '. $rst_ajax .' href="'. esc_url(get_category_link( $category->term_id )) .'">'. esc_html($category->name) .'</a></li>';
								}
							}
						echo '</ul>';
					}
					?>
				</div>
				<div class="row horizontal-news wrap-content-ajax">
					<div class="ub-loading">
						<div class="loader">
							<p><b>LOADING</b></p>
							<span></span>
							<span></span>
							<span></span>
						</div>
					</div>
					<div id="<?php echo 'rst_'.esc_html($rstkey) ?>-all" class="tab-ajax">
					<?php
						$rst_key = 0;
						while ($the_query->have_posts() ) : $the_query->the_post();
							$rst_key++;
							global $post;
							if( $rst_key == 1 ) {
					?>
						<div class="<?php echo sanitize_html_class($class_col_1) ?> item-horizontal-news ub-news-large">
							<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
							<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
								<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=> 1024, 'height' => 600) ) ?>">
								<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
							</a>
							<?php } ?>
							<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
							<?php rst_display_post_information() ?><div class="clear"></div>
							<?php
								if( $agrs['is_show_excerpt'] )
									echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
							?>
						</div>
					<?php } else {
						if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' list-item-horizontal-news"><div class="row">';
					?>
							<div class="<?php echo sanitize_html_class($class_inner_col) ?> item-horizontal-news">
								<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
								<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
									<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>">
									<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
								</a>
								<?php } ?>
								<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
								<?php rst_display_post_information() ?><div class="clear"></div>
							</div>
					<?php 
							if( ($rst_key-1)%(absint($agrs['column'])-1) == 0 ) echo '<div class="clear"></div>';
						if( $rst_key == $the_query->post_count ) echo '</div></div>';
						} 
						endwhile;
						wp_reset_query(); wp_reset_postdata();
					?>
					</div>
				</div>
			</div>
		</div>
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	
	/*----- Scroll -----*/
	if( $agrs['type'] == 'scroll' ) :
		$output = '';
		$args = ub_query_shortcode($agrs);
		
		if( $agrs['column'] == 4 ) $size_image = array('width' => 321,'height' => 209);
		if( $agrs['column'] == 3 ) $size_image = array('width' => 321,'height' => 209);
		if( $agrs['column'] == 2 ) $size_image = array('width' => 490,'height' => 320);
		if( $agrs['column'] == 1 ) $size_image = array('width' => 1000,'height' => 600);
		
		$the_query = new WP_Query( $args );
		
		$output = '';
		ob_start();
	?>
		<div class="<?php echo (isset($agrs['section_type']) ? 'ub-type-'.$agrs['section_type'] : '') ?><?php echo (empty($agrs['title']) ? 'ub-scroll-hide-control' : '') ?> ub-scroll-new ub-scroll <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
			<?php
			if( !empty($agrs['title']) )
				echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
			?>
			 <div class="ub-scroll-<?php echo absint($agrs['column']) ?>col">
				<?php 
					while ($the_query->have_posts() ) : $the_query->the_post();
					global $post;
				?>
				 <div class="rs-box-item rs-scroll-item">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
						<img alt="<?php echo get_the_title(get_the_ID()) ?>" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()),'full'), $size_image ) ?>">
						<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
					</a>
					<?php } ?>
					<h4 class="ub-post-title"><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h4>
					<?php rst_display_post_information() ?><div class="clear"></div>
					<?php
						if( $agrs['is_show_excerpt'] )
							echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
					?>
				 </div>
				<?php
					endwhile;
					wp_reset_query(); wp_reset_postdata();
				?>
			 </div><!--End-rs-sroll-box-->
			 <div class="clear"></div>
		 </div><!--End-sroll-new-->
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	/*----- Smart box 01 -----*/
	if( $agrs['type'] == 'smart_box_01' ) :
		$output = '';
		$args = ub_query_shortcode($agrs);
	
		$the_query = new WP_Query( $args );
		$rstkey = uniqid();
		ob_start();
	?>
	<?php
	if( !empty($agrs['title']) )
		echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
	?>
	<div class="ub-news-column smart-box-01 royalSlider ub-smart-box-01 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
		<?php 
			while ($the_query->have_posts() ) : $the_query->the_post();
			global $post;
		?>
		<div class="rsContent">	
			<?php if( get_post_thumbnail_id(get_the_ID()) ) { ?>
			<a class="rsImg" href="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large' ) ?>">
				<div class="rsTmb clearfix">
					<div class="ub-thumb"><img src="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ) ?>" alt="<?php echo get_the_title(get_the_ID()) ?>" /></div>
					<h4><?php the_title() ?></h4>
					<?php rst_display_post_information(true) ?><div class="clear"></div>
				</div>
			</a>
			<?php } ?>
			<div class="rsABlock sampleBlock">
				<h2><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h2>
				<?php
					if( $agrs['is_show_excerpt'] )
						echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
				?>
			</div>
		</div>
		<?php
			endwhile;
			wp_reset_query(); wp_reset_postdata();
		?>
	</div>
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	
	
	/*----- Smart box 02 -----*/
	if( $agrs['type'] == 'smart_box_02' ) :
		$output = '';
		$args = ub_query_shortcode($agrs);
	
		$the_query = new WP_Query( $args );
		$rstkey = uniqid();
		ob_start();
	?>
	<?php
	if( !empty($agrs['title']) )
		echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
	?>
	<div class="ub-news-slider royalSlider ub-smart-box-02 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">
		<?php 
			while ($the_query->have_posts() ) : $the_query->the_post();
			global $post;
			$size_image = array('width' => 215,'height' => 130);
		?>
		<div class="rsContent">	
			<?php if( get_post_thumbnail_id(get_the_ID()) ) { ?>
			<a class="rsImg" href="<?php echo ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large' ) ?>">
				<div class="rsTmb">
					<img class="ub-thumb" src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()),'full'), $size_image ) ?>" />
					<div class="ub-caption">
						<h4><?php the_title() ?></h4>
					</div>
				</div>
			</a>
			<?php } ?>
			<div class="rsABlock sampleBlock">
				<h2><a href="<?php echo get_permalink(get_the_ID()) ?>"><?php the_title() ?></a></h2>
				<?php rst_display_post_information() ?><div class="clear"></div>
				<?php
					if( $agrs['is_show_excerpt'] )
						echo get_excerpt_by_id($post,absint($agrs['excerpt_length']));
				?>
			</div>
		</div>
		<?php
			endwhile;
			wp_reset_query(); wp_reset_postdata();
		?>
	</div>
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	
	/*----- Smart box 03 -----*/
	if( $agrs['type'] == 'smart_box_03' ) :
		$output = '';
		if( !empty($term) ) $agrs['category'] = $term;
		$args = ub_query_shortcode($agrs);
	
		$the_query = new WP_Query( $args );
		$rstkey = uniqid();
		ob_start();
		
		$class_col_1 = 'col-sm-5';
		$class_col_2 = 'col-sm-7';
		$class_col_inner = 'col-sm-4 col-tb-4';
		if( $agrs['column'] == 3 ) {
			$class_col_1 = 'col-sm-6';
			$class_col_2 = 'col-sm-6';
			$class_col_inner = 'col-sm-6 col-tb-6';
		}
		
		$col = absint($agrs['column'])-1;
		
		
		if( rst_is_ajax() ) {
			$rst_key = 0;
			
			while ($the_query->have_posts() ) : $the_query->the_post();
			global $post;
			$rst_key++;
			if( $rst_key == 1 ) {
		?>
		<div class="<?php echo sanitize_html_class($class_col_1) ?> ub-hz-large">
			<div class="ub-hz-thumb">
				<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>745,'height'=>538)) ?>" alt="<?php the_title() ?>">
					<?php } ?>
					<div class="ub-caption">
						<h2><?php the_title() ?></h2>
						<?php rst_display_post_information(true) ?><div class="clear"></div>
					</div>
					<div class="ub-bg-opacity"></div>
					<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
				</a>
			</div>
		</div>
		<?php } else {
			if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' ub-hz-small">';
				if( ($rst_key-1)%$col == 1 ) echo '<div class="row">';
		?>
				<div class="<?php echo esc_attr($class_col_inner) ?> col-mb-12">
					<div class="ub-hz-thumb">
						<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
							<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
							<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>372,'height'=>268)) ?>" alt="<?php the_title() ?>" />
							<?php } ?>
							<div class="ub-caption">
								<h2><?php the_title() ?></h2>
							</div>
							<div class="ub-bg-opacity"></div>
							<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
						</a>
					</div>
				</div>
			
		<?php 
			if( ($rst_key-1)%$col == 0 ) echo '</div>';
			if( $rst_key == $the_query->post_count ) echo '</div>'; 
		
			}
			endwhile;
			if( ($rst_key-1)%$col != 0 ) echo '</div>';
			wp_reset_query(); wp_reset_postdata();
		
			$output .= ob_get_contents();
			ob_end_clean();
			return $output;
		}
	?>
	<script type="text/javascript">
		var rst_<?php echo esc_html($rstkey) ?> = new rst_blocks();
		rst_<?php echo esc_html($rstkey) ?>.atts = '<?php echo json_encode($agrs) ?>';
		rst_<?php echo esc_html($rstkey) ?>.url = '<?php echo admin_url( "admin-ajax.php" ); ?>';
	</script>
	<div class="ub-box-horizontal-news ub-smart-box-03 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?>">             	 
		<div class="wrap-horizontal-news wrap-ajax">
			<?php if( !empty($agrs['title']) || $agrs['is_type_categories'] != '0' ) { ?>
			<div class="clearfix link">
			<?php
				if( !empty($agrs['title']) )
					echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
				if( $agrs['is_type_categories'] != '0' ) {
					echo '<ul class="ub-list-category">';
							echo '<li><a data-key="rst_'. esc_html($rstkey) .'" class="rst_ajax" rst_slug="all" rst_term="-1" href="#">All</a></li>';
						$rst_categories = get_categories( array('include' => rst_get_categories_ids($agrs['category']), 'hide_empty' => 1, 'orderby' => 'term_group' ) );
						if( is_array($rst_categories) && sizeof($rst_categories) ) {
							$rst_ajax = '';
							foreach( $rst_categories as $category ) {
								if( $agrs['is_type_categories'] == 'ajax' ) $rst_ajax = 'class="rst_ajax" rst_slug="'. $category->slug .'" rst_term="'. $category->slug .'"';
								echo '<li><a data-key="rst_'. esc_html($rstkey) .'" '. $rst_ajax .' href="'. esc_url(get_category_link( $category->term_id )) .'">'. esc_html($category->name) .'</a></li>';
							}
						}
					echo '</ul>';
				}
			?>
			</div><!--End-link-->
			<?php } ?>
			<?php if( $the_query->have_posts() ) { ?>
			<div class="ub-content-horizontal-menu">
				<div class="row wrap-content-ajax smart-box-col-<?php echo absint($col) ?>">
					<div class="ub-loading">
						<div class="loader">
							<p><b>LOADING</b></p>
							<span></span>
							<span></span>
							<span></span>
						</div>
					</div>
					<div id="<?php echo 'rst_'.esc_html($rstkey) ?>-all" class="tab-ajax">
					<?php 
						$rst_key = 0;
						while ($the_query->have_posts() ) : $the_query->the_post();
						global $post;
						$rst_key++;
						if( $rst_key == 1 ) {
					?>
					<div class="<?php echo sanitize_html_class($class_col_1) ?> ub-hz-large">
						<div class="ub-hz-thumb">
							<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
								<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
								<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>745,'height'=>558)) ?>" alt="<?php the_title() ?>">
								<?php } ?>
								<div class="ub-caption">
									<h2><?php the_title() ?></h2>
									<?php rst_display_post_information(true) ?><div class="clear"></div>
								</div>
								<div class="ub-bg-opacity"></div>
								<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
							</a>
						</div>
					</div>
					<?php } else {
						if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' ub-hz-small">';
							if( ($rst_key-1)%$col == 1 ) echo '<div class="row">';
					?>
							<div class="<?php echo esc_attr($class_col_inner) ?> col-mb-12">
								<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
									<div class="ub-hz-thumb">
										<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
										<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>372,'height'=>268)) ?>" alt="<?php the_title() ?>" />
										<?php } ?>
										<div class="ub-caption">
											<h2><?php the_title() ?></h2>
										</div>
										<div class="ub-bg-opacity"></div>
										<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
									</div>
								</a>
							</div>
						
					<?php 
						if( ($rst_key-1)%$col == 0 ) echo '</div>';
						if( $rst_key == $the_query->post_count ) echo '</div>'; 
					?>
					<?php 
						}
						endwhile;
						if( ($rst_key-1)%$col != 0 ) echo '</div>';
						wp_reset_query(); wp_reset_postdata();
					?>
					</div>
				</div>
			</div>
			<?php 
			} else {
				echo apply_filters('the_content',rst_get_translate('It seems we can\'t find what you\'re looking for. Perhaps searching can help.','query_not_found'));
			}
			?>
		 </div><!--End-wrap-horizontal-news-->
	 </div><!--End-ub-box-horizontal-news-->
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
	
	
	/*----- Smart box 04 -----*/ 
	if( $agrs['type'] == 'smart_box_04' ) :
		$output = '';
		if( !empty($term) ) $agrs['category'] = $term;
		$args = ub_query_shortcode($agrs);
	
		$the_query = new WP_Query( $args );
		$rstkey = uniqid();
		ob_start();
		
		$class_col_1 = 'col-sm-12';
		$class_col_2 = 'col-sm-12';
		$class_col_inner = 'col-sm-6 col-tb-6';
		if( $agrs['column'] == 3 ) {
			$class_col_inner = 'col-sm-4 col-tb-4';
		}
		if( $agrs['column'] == 4 ) {
			$class_col_inner = 'col-sm-3 col-tb-3';
		}
		
		$col = absint($agrs['column']);
		
		
		if( rst_is_ajax() ) {
			$rst_key = 0;
			
			while ($the_query->have_posts() ) : $the_query->the_post();
			global $post;
			$rst_key++;
			if( $rst_key == 1 ) {
		?>
		<div class="<?php echo sanitize_html_class($class_col_1) ?> ub-hz-large">
			<div class="ub-hz-thumb">
				<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
					<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
					<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>1080,'height'=>655)) ?>" alt="<?php the_title() ?>">
					<?php } ?>
					<div class="ub-caption">
						<h2><?php the_title() ?></h2>
						<?php rst_display_post_information(true) ?><div class="clear"></div>
					</div>
					<div class="ub-bg-opacity"></div>
					<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
				</a>
			</div>
		</div>
		<?php } else {
			if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' ub-hz-small">';
				if( ($rst_key-1)%$col == 1 ) echo '<div class="row">';
		?>
				<div class="<?php echo esc_attr($class_col_inner) ?> col-mb-12">
					<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
						<div class="ub-hz-thumb">
							<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
							<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>540,'height'=>400)) ?>" alt="<?php the_title() ?>" />
							<?php } ?>
							<div class="ub-caption">
								<h2><?php the_title() ?></h2>
							</div>
							<div class="ub-bg-opacity"></div>
							<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
						</div>
					</a>
				</div>
			
		<?php 
			if( ($rst_key-1)%$col == 0 ) echo '</div>';
			if( $rst_key == $the_query->post_count ) echo '</div>'; 
		
			}
			endwhile;
			if( ($rst_key-1)%$col != 0 ) echo '</div>';
			wp_reset_query(); wp_reset_postdata();
		
			$output .= ob_get_contents();
			ob_end_clean();
			return $output;
		}
	?>
	<script type="text/javascript">
		var rst_<?php echo esc_html($rstkey) ?> = new rst_blocks();
		rst_<?php echo esc_html($rstkey) ?>.atts = '<?php echo json_encode($agrs) ?>';
		rst_<?php echo esc_html($rstkey) ?>.url = '<?php echo admin_url( "admin-ajax.php" ); ?>';
	</script>
	<div class="ub-box-horizontal-news ub-smart-box-04 <?php echo !empty($args['extra_class_name']) ? sanitize_html_class($args['extra_class_name']) : '' ?> <?php echo (isset($agrs['section_type']) ? 'ub-type-'.$agrs['section_type'] : '') ?>">             	 
		<div class="wrap-horizontal-news wrap-ajax">
			<?php if( !empty($agrs['title']) || $agrs['is_type_categories'] != '0' ) { ?>
			<div class="clearfix link">
			<?php
				if( !empty($agrs['title']) )
					echo '<h2 class="rs-title-box"><span>'. $agrs['title'] .'</span></h2>';
				if( $agrs['is_type_categories'] != '0' ) {
					echo '<ul class="ub-list-category">';
							echo '<li><a data-key="rst_'. esc_html($rstkey) .'" class="rst_ajax" rst_slug="all" rst_term="-1" href="#">All</a></li>';
						$rst_categories = get_categories( array('include' => rst_get_categories_ids($agrs['category']), 'hide_empty' => 1, 'orderby' => 'term_group' ) );
						if( is_array($rst_categories) && sizeof($rst_categories) ) {
							$rst_ajax = '';
							foreach( $rst_categories as $category ) {
								if( $agrs['is_type_categories'] == 'ajax' ) $rst_ajax = 'class="rst_ajax" rst_slug="'. $category->slug .'" rst_term="'. $category->slug .'"';
								echo '<li><a data-key="rst_'. esc_html($rstkey) .'" '. $rst_ajax .' href="'. esc_url(get_category_link( $category->term_id )) .'">'. esc_html($category->name) .'</a></li>';
							}
						}
					echo '</ul>';
				}
			?>
			</div><!--End-link-->
			<?php } ?>
			<?php if( $the_query->have_posts() ) { ?>
			<div class="ub-content-horizontal-menu">
				<div class="row wrap-content-ajax smart-box-col-<?php echo absint($col) ?>">
					<div class="ub-loading">
						<div class="loader">
							<p><b>LOADING</b></p>
							<span></span>
							<span></span>
							<span></span>
						</div>
					</div>
					<div id="<?php echo 'rst_'.esc_html($rstkey) ?>-all" class="tab-ajax">
					<?php 
						$rst_key = 0;
						while ($the_query->have_posts() ) : $the_query->the_post();
						global $post;
						$rst_key++;
						if( $rst_key == 1 ) {
					?>
					<div class="<?php echo sanitize_html_class($class_col_1) ?> ub-hz-large">
						<div class="ub-hz-thumb">
							<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
								<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
								<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>1080,'height'=>655)) ?>" alt="<?php the_title() ?>">
								<?php } ?>
								<div class="ub-caption">
									<h2><?php the_title() ?></h2>
									<?php rst_display_post_information(true) ?><div class="clear"></div>
								</div>
								<div class="ub-bg-opacity"></div>
								<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
							</a>
						</div>
					</div>
					<?php } else {
						if( $rst_key == 2 ) echo '<div class="'. sanitize_html_class($class_col_2) .' ub-hz-small">';
							if( ($rst_key-1)%$col == 1 ) echo '<div class="row">';
					?>
							<div class="<?php echo esc_attr($class_col_inner) ?> col-mb-12">
								<a class="thumbnail ub-thumbnail ub-post-format-<?php echo sanitize_html_class(get_post_format(get_the_ID())) ?>" href="<?php echo get_permalink(get_the_ID()) ?>">
									<div class="ub-hz-thumb">
										<?php if( get_post_thumbnail_id(get_the_ID()) && $agrs['is_show_thumbnail'] ) { ?>
										<img src="<?php echo bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' ),array('width'=>540,'height'=>400)) ?>" alt="<?php the_title() ?>" />
										<?php } ?>
										<div class="ub-caption">
											<h2><?php the_title() ?></h2>
										</div>
										<div class="ub-bg-opacity"></div>
										<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>
									</div>
								</a>
							</div>
						
					<?php 
						if( ($rst_key-1)%$col == 0 ) echo '</div>';
						if( $rst_key == $the_query->post_count ) echo '</div>'; 
					?>
					<?php 
						}
						endwhile;
						if( ($rst_key-1)%$col != 0 ) echo '</div>';
						wp_reset_query(); wp_reset_postdata();
					?>
					</div>
				</div>
			</div>
			<?php 
			} else {
				echo apply_filters('the_content',rst_get_translate('It seems we can\'t find what you\'re looking for. Perhaps searching can help.','query_not_found'));
			}
			?>
		 </div><!--End-wrap-horizontal-news-->
	 </div><!--End-ub-box-horizontal-news-->
	<?php
		$output .= ob_get_contents();
		ob_end_clean();
		return $output;
	endif;
}