<?php
global $RS;

$ub_widgets = rst_get_my_widgets();

// Page Setting
$RS->metabox(array(
	'name' => 'page_setting',
	'title' => 'Page Setting',
	'rules' => array(
		'post_type' => 'page',
	),
	'controls' => array(
		array(
			'name' => 'rst_show_title',
			'label'=> 'Show Title',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'page_is_show_breadcrumb',
			'label'=> 'Show Breadcrumb',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'is_dropcap',
			'label'=> 'Dropcap First Text',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'page_is_show_rating',
			'label'=> 'Show Rating',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'page_is_show_share',
			'label'=> 'Show Share',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'page_is_show_author',
			'label'=> 'Show Author Box',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'label' => 'Page Column Style',
			'type' => 'radio',
			'display' => 'inline',
			'name' => 'page_template_style',
			'description'	=> 'Choose your page column style to show on your page.',
			'items' => array(
				array(
					'value' => 1,
					'text' => 'Full Width',
					'image' => get_template_directory_uri() . '/inc/css/images/fullwidth.jpg'
				),
				array(
					'value' => 2,
					'text' => 'Sidebar Left',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_left.jpg'
				),
				array(
					'value' => 3,
					'text' => 'Sidebar Right',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_right.jpg'
				)
			),
			'default_value' => '1'
		),
		array(
			'name' => 'rst_show_widget',
			'label'=> 'Select Sidebar',
			'type' => 'select',
			'conditional_logic' => array('page_template_style' => '2|3'),
			'items' => $ub_widgets
		)
	)
));

// Post Setting
$RS->metabox(array(
	'name' => 'post_setting',
	'title' => 'Post Setting',
	'rules' => array(
		'post_type' => 'post',
	),
	'controls' => array(
		array(
			'name' => 'rst_show_title',
			'label'=> 'Show Title',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'single_is_show_rating',
			'label'=> 'Show Rating',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'rst_show_infor',
			'label'=> 'Show Information',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'name' => 'is_dropcap',
			'label'=> 'Dropcap First Text',
			'type' => 'switch',
			'style' => 'default',
			'default_value' => true
		),
		array(
			'label' => 'Page Column Style',
			'type' => 'radio',
			'display' => 'inline',
			'name' => 'template_style',
			'description'	=> 'Choose your page column style to show on your page.',
			'items' => array( 
				array(
					'value' => 0,
					'text' => 'Default',
					'image' => get_template_directory_uri() . '/inc/css/images/default.jpg'
				),
				array(
					'value' => 1,
					'text' => 'Full Width',
					'image' => get_template_directory_uri() . '/inc/css/images/fullwidth.jpg'
				),
				array(
					'value' => 2,
					'text' => 'Sidebar Left',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_left.jpg'
				),
				array(
					'value' => 3,
					'text' => 'Sidebar Right',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_right.jpg'
				)
			),
			'default_value' => '0'
		),
		array(
			'name' => 'rst_show_widget',
			'label'=> 'Select Sidebar',
			'type' => 'select',
			'conditional_logic' => array('template_style' => '2|3'),
			'items' => $ub_widgets
		),
		array(
			'label' 		=> 'Image Thumbnail Full Width',
			'type' 			=> 'switch',
			'name' 			=> 'singe_thumbnail_full',
			'conditional_logic' => array( 'template_style' => '2|3' )
		)
	)
));