<?php
global $RS;

// Video Setting
$RS->metabox(array(
	'name' => 'ublog_video_setting',
	'title' => 'Video Setting',
	'rules' => array(
		'post_format' => 'video',
	),
	'controls' => array(
		array(
			'name' => 'ublog_video_type',
			'label'=> 'Video Type',
			'type' => 'select',
			'items' => array('youtube' => 'Youtube', 'vimeo' => 'Vimeo', 'upload' => 'Upload' )
		),
		array(
			'name' => 'ublog_video_embed',
			'label'=> 'Embed Code',
			'derscription' => 'Just paste the ID of the video (E.g. http://www.youtube.com/watch?v=<strong>GUEZCxBcM78</strong>) you want to show, or insert own Embed Code. <br>This will show the Video <strong>INSTEAD</strong> of the Image Slider.<br><strong>Of course you can also insert your Audio Embedd Code!</strong><br><br><strong>Notice:</strong> The Preview Image will be the Image set as Featured Image..',
			'type' => 'textarea',
			'conditional_logic' => array('ublog_video_type' => 'youtube|vimeo')
		),
		array(
			'name' => 'ublog_video_upload',
			'label'=> 'Upload Video',
			'type' => 'video',
			'conditional_logic' => array('ublog_video_type' => 'upload')
		)
	)
));

// Gallery Setting
$RS->metabox(array(
	'name' => 'ublog_gallery_setting',
	'title' => 'Gallery Setting',
	'rules' => array(
		'post_format' => 'gallery',
	),
	'controls' => array(
		array(
			'name' => 'ublog_gallery',
			'type' => 'gallery',
			'label'=> 'Blog Post Images ',
			'derscription' => 'Upload up to 20 images for a slideshow - or only one to display a single image. <br><br><strong>Notice:</strong> The Preview Image will be the Image set as Featured Image.'
		)
	)
));

// Audio Setting
$RS->metabox(array(
	'name' => 'ublog_audio_setting',
	'title' => 'Audio Setting',
	'rules' => array(
		'post_format' => 'audio',
	),
	'controls' => array(
		array(
			'name' => 'ublog_audio_type',
			'label'=> 'Video Type',
			'type' => 'select',
			'items' => array('iframe' => 'Iframe', 'upload' => 'Upload' )
		),
		array(
			'name' => 'ublog_audio_iframe',
			'type' => 'textarea',
			'label'=> 'Audio Code',
			'derscription' => 'Enter your Audio URL(Oembed) or Embed Code.',
			'conditional_logic' => array('ublog_audio_type' => 'iframe')
		),
		array(
			'name' => 'ublog_audio_upload',
			'label'=> 'Audio Code',
			'type' => 'audio',
			'conditional_logic' => array('ublog_audio_type' => 'upload')
		)
	)
));

// Link Setting
$RS->metabox(array(
	'name' => 'ublog_link_setting',
	'title' => 'Link Setting',
	'rules' => array(
		'post_format' => 'link',
	),
	'controls' => array(
		array(
			'name' => 'ublog_link_title',
			'type' => 'text',
			'label'=> 'Link Title',
			'derscription' => 'Enter your title link here.'
		),
		array(
			'name' => 'ublog_link_url',
			'type' => 'text',
			'label'=> 'Link Url',
			'derscription' => 'Enter your URL here.'
		)
	)
));

// Quote Setting
$RS->metabox(array(
	'name' => 'ublog_quote_setting',
	'title' => 'Quote Setting',
	'rules' => array(
		'post_format' => 'quote',
	),
	'controls' => array(
		array(
			'name' => 'ublog_quote',
			'type' => 'textarea',
			'label'=> 'Quote',
			'derscription' => 'Enter Quote here.'
		),
		array(
			'name' => 'ublog_quotesource',
			'type' => 'text',
			'label'=> 'Quote Author/Source Link',
			'derscription' => 'Enter the Quote Source or Quote Author.'
		)
	)
));