<?php
global $RS;

// User Setting
$RS->metabox(array(
	'name' => 'ublog_category_layout_setting',
	'title' => 'Layout Setting',
	'rules' => array(
		'taxonomy' => 'category',
	),
	'controls' => array(
		array(
			'label' 		=> 'Layout Setting',
			'type' 			=> 'radio',
			'display' 		=> 'inline',
			'name' 			=> 'rst_cat_layout',
			'default_value'	=> 0,
			'items'        	=> array(
				array(
					'value' => 0,
					'text' => 'Default',
					'image' => get_template_directory_uri() . '/inc/css/images/default.jpg'
				),
				array(
					'value' => 1,
					'text' => 'Full Width',
					'image' => get_template_directory_uri() . '/inc/css/images/fullwidth.jpg'
				),
				array(
					'value' => 2,
					'text' => 'Sidebar Left',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_left.jpg'
				),
				array(
					'value' => 3,
					'text' => 'Sidebar Right',
					'image' => get_template_directory_uri() . '/inc/css/images/sidebar_right.jpg'
				)
			)
		),
		array(
			'name' => 'rst_cat_sidebar',
			'label'=> 'Select Sidebar',
			'type' => 'select',
			'items' => $rst_widgets,
			'conditional_logic' => array(
				'rst_cat_layout' => '2|3'
			)
		),
		array(
			'label' 		=> 'Template Setting',
			'type' 			=> 'radio',
			'display'		=> 'inline',
			'name' 			=> 'rst_cat_template',
			'default_value'	=> 'large',
			'items'        	=> array(
				array(
					'value' => 'box',
					'image' => get_template_directory_uri() . '/inc/icons/Box.jpg'
				),
				array(
					'value' => 'large',
					'image' => get_template_directory_uri() . '/inc/icons/large.jpg'
				),
				array(
					'value' => 'grid',
					'image' => get_template_directory_uri() . '/inc/icons/Grid.jpg'
				),
				array(
					'value' => 'medium',
					'image' => get_template_directory_uri() . '/inc/icons/medium.jpg'
				),
				array(
					'value' => 'large-box',
					'image' => get_template_directory_uri() . '/inc/icons/large-box.jpg'
				),
				array(
					'value' => 'large-medium',
					'image' => get_template_directory_uri() . '/inc/icons/large-medium.jpg'
				)
			),
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' 		=> 'Number Columns',
			'type' 			=> 'select',
			'default_value'	=> 2,
			'name'			=> 'rst_cat_column',
			'items'			=> array(
				'2' => '2 Columns',
				'3' => '3 Columns',
				'4' => '4 Columns'
			),
			'description'	=> 'Number columns for template grid &amp; box',
			'conditional_logic' => array(
				'rst_cat_template' => 'grid|box'
			)
		),
		array(
			'label' 		=> 'Posts Per Page',
			'type' 			=> 'text',
			'default_value'	=> 10,
			'name'			=> 'rst_cat_numberpost',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Thumbnail Type',
			'type' => 'radio',
			'name' => 'rst_cat_is_show_thumbnail',
			'items' => array(
				'image' => 'Thumbnail',
				'more'		=> 'Video/Gallery/Audio'
			),
			'default_value' => 'image',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' 		=> 'Excerpt Length',
			'type' 			=> 'text',
			'default_value'	=> 50,
			'name'			=> 'rst_cat_excerpt_length',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' 		=> 'Page Navi',
			'type' 			=> 'select',
			'default_value'	=> 1,
			'name'			=> 'rst_cat_pagenavi',
			'items'			=> array(
				'0' => 'No',
				'number' => 'Number',
				'load_more' => 'Load More',
				'load_auto' => 'Auto Load',
				'next_prev' => 'Next/Prev',
			),
			'default_value'	=> 'number',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Order By',
			'type' => 'select',
			'name' => 'rst_cat_orderby',
			'items' => array(
				'post_date' => 'Date Time',
				'post_title' => 'Title',
				'popular' => 'Popular',
				'popular_week' => 'Popular On Week',
				'popular_month' => 'Popular On Month',
				'featured' => 'Featured',
				'high_rated' => 'Highest rated',
				'rand' => 'Random'
			),
			'default_value'	=> 'post_date',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Order',
			'type' => 'select',
			'name' => 'rst_cat_order',
			'items' => array(
				'desc' => 'Descending',
				'asc' => 'Ascending'
			),
			'default_value'	=> 'desc',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Breadcrumb',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_breadcrumb',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Category Title',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_title',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Turn off Uppercase Category Title',
			'type' => 'switch',
			'name' => 'rst_cat_is_off_uppercase_title',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hiden Sub Category',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_sub_cat',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Date',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_date',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Category',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_category',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Excerpt',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_excerpt',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Author',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_author',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden Count Comment',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_comment',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
		array(
			'label' => 'Hidden View',
			'type' => 'switch',
			'name' => 'rst_cat_is_hide_view',
			'conditional_logic' => array(
				'rst_cat_layout:not:i' => '0'
			)
		),
	)
));