<?php
	if( !get_theme_mod('header_hide_topbar') ) {
		get_template_part( 'inc/header/header', 'topbar' );
	}
?>
<div class="top-header">
	<div class="row">
		<div class="col-sm-4">
			<?php 
				if( get_theme_mod('header_sidebar_left') ) {
					dynamic_sidebar( get_theme_mod('header_sidebar_left') );
				}
			?>
		</div>
		<div class="col-sm-4">
			<div class="rst-logo text-center">
				<?php if( get_theme_mod('rst_logo') ) { ?>
				<a href="<?php echo esc_url(home_url()) ?>"><img src="<?php echo get_theme_mod('rst_logo'); ?>" alt="<?php echo esc_attr(get_option('blogname')) ?>"></a>
				<?php } ?>
			</div>
		</div>
		<div class="col-sm-4 text-right">
			<?php 
				if( get_theme_mod('header_sidebar_right') ) {
					dynamic_sidebar( get_theme_mod('header_sidebar_right') );
				}
			?>
		</div>
	</div>
</div>
<div class="rows main-menu rst-top-main-menu-full <?php echo !get_theme_mod('main_menu_turn_off_border_line') ? 'border-line' : '' ?>">
	<?php 
		if( !get_theme_mod('header_hide_search') ) { 
			get_search_form();
		}
	?>
	<nav role="navigation" class="navbar navbar-default" id="myNavbar"> 
	 <div class="navbar-header">
		<button data-target="#navbarCollapse" data-toggle="collapse" class="navbar-toggle" type="button"> 
			<span class="sr-only">Toggle navigation</span> 
			<span class="icon-bar"></span> 
			<span class="icon-bar"></span> 
			<span class="icon-bar"></span>
			<span class="text-menu-mobile"><?php rst_the_translate('Menu','menu') ?></span>
		</button>
	 </div>
		<!-- Collect the nav links, forms, and other content for toggling -->
		<div id="navbarCollapse" class="collapse navbar-collapse">
			<div class="logo-fixed">
			<?php if( get_theme_mod('rst_logo') || get_theme_mod('rst_logo_mini') ) { ?>
				<a href="<?php echo esc_url(home_url()) ?>">
					<img src="<?php echo ( get_theme_mod('rst_logo_mini') ) ? get_theme_mod('rst_logo_mini') : get_theme_mod('rst_logo'); ?>" alt="<?php echo esc_attr(get_option('blogname')) ?>">
				</a>
			<?php } ?>
			</div>
			<?php 
				if ( has_nav_menu( 'primary' ) ) {
					wp_nav_menu(
						array(
							'theme_location' => 'primary',
							'menu_class'=> 'rst-nav-menu row',
							'container' => false
						)
					);
				}
			?>
		</div>
	</nav>
</div>