<?php
class ubtheme_widget_about extends WP_Widget {
	
	function ubtheme_widget_about() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_about', 'description' => 'A widget that show about' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-about-widget', 'Ublog About Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		$html .= $args['before_widget'];
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		
		if( !empty($instance['description']) )
			$html .= apply_filters('the_content', $instance['description']);
		
		if( !empty($instance['mail']) )
			$html .= '<p class="mail"><a href="mailto:'. $instance['mail'] .'"><i class="fa fa-envelope"></i> '. $instance['mail'] .'</a></p>';
			
		$html .= $args['after_widget'];
		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Description:
		<textarea name="<?php echo esc_attr($this->get_field_name( 'description' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'description' )); ?>" rows="7" style="width:100%"><?php echo isset($instance['description']) ? esc_attr($instance['description']) : ''; ?></textarea></label>
		<br/><br/>
		<label>Mail:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'mail' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'mail' )); ?>" value="<?php echo isset($instance['mail']) ? esc_attr($instance['mail']) : ''; ?>" style="width:100%"/></label>
		
		
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_widget_about' );

function create_widget_about(){
	return register_widget("ubtheme_widget_about");
}