<?php
class ubtheme_posts_smart_box_widget extends WP_Widget {
	
	function ubtheme_posts_smart_box_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_posts_smart_box', 'description' => 'A widget that show posts smart box' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-posts-smart-box-widget', 'Ublog Posts Smart Box Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		$html .= $args['before_widget'];
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		if( $instance['post_list'] ) {
		$html .= '<div class="row ub-box-horizontal-news ub-smart-box-04 ub-type-small">';
			
			foreach( $instance['post_list'] as $key=>$item ) {
			$post = get_post($item['post']);
			setup_postdata($post);
			
			if( $key == 0 && is_object($post) ) {
				$html .= '<div class="col-sm-12 ub-hz-large">';
					$html .= '<div class="ub-hz-thumb">';
						$html .= '<a href="'. get_permalink($post->ID) .'" class="thumbnail ub-thumbnail ub-post-format-video">';
							if( has_post_thumbnail($post->ID) ) {
								$html .= '<img alt="'. get_the_title($post->ID) .'" src="'. bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ),array('width'=>1080,'height'=>655)) .'">';
							}
							$html .= '<div class="ub-caption">';
								$html .= '<h2>'. get_the_title($post->ID) .'</h2>';
								$html .= '<div class="ub-post-infor">';
									$html .= '<span class="admin">- by '. get_the_author_meta( 'display_name', get_the_author_meta( 'ID' ) ) .'</span>';
									$html .= '<span class="date">- on '. get_post_date() .'</span>';
								$html .= '</div>';
								$html .= '<div class="clear"></div>';
							$html .= '</div>';
							$html .= '<div class="ub-bg-opacity"></div>';
							$html .= '<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>';
						$html .= '</a>';
					$html .= '</div>';
				$html .= '</div>';
			}
			else {
				if( $key == 1 ) {
					$html .= '<div class="col-sm-12 ub-hz-small">';
						$html .= '<div class="row">';
				}
				if( is_object($post) ) {
					$html .= '<div class="col-sm-6 col-tb-6 col-mb-12">';
						$html .= '<a href="'. get_permalink($post->ID) .'" class="thumbnail ub-thumbnail ub-post-format-video">';
							$html .= '<div class="ub-hz-thumb">';
								$html .= '<img alt="'. get_the_title($post->ID) .'" src="'. bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ),array('width'=>540,'height'=>400)) .'">';
								$html .= '<div class="ub-caption">';
									$html .= '<h2>'. get_the_title($post->ID) .'</h2>';
								$html .= '</div>';
								$html .= '<div class="ub-bg-opacity"></div>';
								$html .= '<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>';
							$html .= '</div>';
						$html .= '</a>';
					$html .= '</div>';
				}
		
				if( $key == sizeof( $instance['post_list'] )-1 ) {
						$html .= '</div>';
					$html .= '</div>';
				}
			
			}
			}
			wp_reset_postdata(); 
		$html .= '</div>';
		}
		
		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Select Posts:</label>
		<?php 
			rs::repeater(array(
				'name' => $this->get_field_name( 'post_list' ),
				'type' => 'repeater',
				'add_row_text' => 'Add Post',
				'min_rows' => 0,
				'controls' => array(
				  array(
					 'name' => 'post',
					 'type'  => 'postlist',
				  )
			   ),
			   'value' => isset($instance['post_list']) ? $instance['post_list'] : ''
			));
		?>
		<br/><br/>
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_posts_smart_box_widget' );

function create_posts_smart_box_widget(){
	return register_widget("ubtheme_posts_smart_box_widget");
}