<?php
class ubtheme_social_widget extends WP_Widget {
	
	function ubtheme_social_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_social', 'description' => 'A widget that show social network' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-social-widget', 'Ublog Social Network Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		$html .= $args['before_widget'];
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		
		if( !empty($instance['description']) )
			$html .= apply_filters('the_content', $instance['description']);
			$html .= '<ul class="ss_social clearfix">';
			
				if( !empty($instance['twitter']) ) {
					$html .= '<li><a target="_blank" title="Twitter" class="twitter" href="'. esc_url($instance['twitter']) .'"><span class="sr-only">twitter</span></a></li>';
				}
				if( !empty($instance['facebook']) ) {
					$html .= '<li><a target="_blank" title="Facebook" class="facebook" href="'. esc_url($instance['facebook']) .'"><span class="sr-only">facebook</span></a></li>';
				}
				if( !empty($instance['linkedin']) ) {
					$html .= '<li><a target="_blank" title="LinkedIn" class="in" href="'. esc_url($instance['linkedin']) .'"><span class="sr-only">linkedin</span></a></li>';
				}
				if( !empty($instance['google']) ) {
					$html .= '<li><a target="_blank" title="Google Plus" class="gplus" href="'. esc_url($instance['google']) .'"><span class="sr-only">google plus</span></a></li>';
				}
				if( !empty($instance['yahoo']) ) {
					$html .= '<li><a target="_blank" title="yahoo" class="yahoo" href="'. esc_url($instance['yahoo']) .'"><span class="sr-only">yahoo</span></a></li>';
				}
				if( !empty($instance['delicious']) ) {
					$html .= '<li><a target="_blank" title="Delicious" class="delicious" href="'. esc_url($instance['delicious']) .'"><span class="sr-only">delicious</span></a></li>';
				}
				if( !empty($instance['flickr']) ) {
					$html .= '<li><a target="_blank" title="Flickr" class="flickr" href="'. esc_url($instance['flickr']) .'"><span class="sr-only">flickr</span></a></li>';
				}
				if( !empty($instance['skype']) ) {
					$html .= '<li><a target="_blank" title="Skype" class="skype" href="'. esc_url($instance['skype']) .'"><span class="sr-only">skype</span></a></li>';
				}
				if( !empty($instance['vimeo']) ) {
					$html .= '<li><a target="_blank" title="Vimeo" class="vimeo" href="'. esc_url($instance['vimeo']) .'"><span class="sr-only">vimeo</span></a></li>';
				}
				if( !empty($instance['youtube']) ) {
					$html .= '<li><a target="_blank" title="YouTube" class="utube" href="'. esc_url($instance['youtube']) .'"><span class="sr-only">youtube</span></a></li>';
				}
				if( !empty($instance['pinterest']) ) {
					$html .= '<li><a target="_blank" title="Pinterest" class="pint" href="'. esc_url($instance['pinterest']) .'"><span class="sr-only">pinterest</span></a></li>';
				}
				if( !empty($instance['vkontakte']) ) {
					$html .= '<li><a target="_blank" title="VK" class="vk" href="'. esc_url($instance['vkontakte']) .'"><span class="sr-only">vk</span></a></li>';
				}
				if( !empty($instance['tumblr']) ) {
					$html .= '<li><a target="_blank" title="Tumblr" class="tumblr" href="'. esc_url($instance['tumblr']) .'"><span class="sr-only">tumblr</span></a></li>';
				}
				if( !empty($instance['soundcloud']) ) {
					$html .= '<li><a target="_blank" title="SoundCloud" class="soundcloud" href="'. esc_url($instance['soundcloud']) .'"><span class="sr-only">soundcloud</span></a></li>';
				}
				if( !empty($instance['vine']) ) {
					$html .= '<li><a target="_blank" title="Vine" class="vine" href="'. esc_url($instance['vine']) .'"><span class="sr-only">vine</span></a></li>';
				}
					$html .= '<li><a target="_blank" title="RSS" class="rss" href="'. esc_url(get_bloginfo_rss('rss2_url')) .'"><span class="sr-only">rss</span></a></li>';

			$html .= '</ul>';
			
		$html .= $args['after_widget'];
		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Description:
		<textarea name="<?php echo esc_attr($this->get_field_name( 'description' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'description' )); ?>" rows="7" style="width:100%"><?php echo isset($instance['description']) ? esc_attr($instance['description']) : ''; ?></textarea></label>
		<br/><br/>
		<label>Twitter:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'twitter' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'twitter' )); ?>" value="<?php echo isset($instance['twitter']) ? esc_attr($instance['twitter']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Facebook:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'facebook' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'facebook' )); ?>" value="<?php echo isset($instance['facebook']) ? esc_attr($instance['facebook']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Linkedin:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'linkedin' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'linkedin' )); ?>" value="<?php echo isset($instance['linkedin']) ? esc_attr($instance['linkedin']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Google plus:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'google' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'google' )); ?>" value="<?php echo isset($instance['google']) ? esc_attr($instance['google']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Yahoo mail:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'yahoo' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'yahoo' )); ?>" value="<?php echo isset($instance['yahoo']) ? esc_attr($instance['yahoo']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Delicious:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'delicious' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'delicious' )); ?>" value="<?php echo isset($instance['delicious']) ? esc_attr($instance['delicious']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Flickr:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'flickr' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'flickr' )); ?>" value="<?php echo isset($instance['flickr']) ? esc_attr($instance['flickr']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Skype:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'skype' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'skype' )); ?>" value="<?php echo isset($instance['skype']) ? esc_attr($instance['skype']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Vimeo:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'vimeo' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vimeo' )); ?>" value="<?php echo isset($instance['vimeo']) ? esc_attr($instance['vimeo']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Youtube:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'youtube' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'youtube' )); ?>" value="<?php echo isset($instance['youtube']) ? esc_attr($instance['youtube']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Pinterest:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'pinterest' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'pinterest' )); ?>" value="<?php echo isset($instance['pinterest']) ? esc_attr($instance['pinterest']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>VKontakte:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'vkontakte' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vkontakte' )); ?>" value="<?php echo isset($instance['vkontakte']) ? esc_attr($instance['vkontakte']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Tumblr:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'tumblr' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tumblr' )); ?>" value="<?php echo isset($instance['tumblr']) ? esc_attr($instance['tumblr']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Soundcloud:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'soundcloud' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'soundcloud' )); ?>" value="<?php echo isset($instance['soundcloud']) ? esc_attr($instance['soundcloud']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Vine:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'vine' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vine' )); ?>" value="<?php echo isset($instance['vine']) ? esc_attr($instance['vine']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_social_widget' );

function create_social_widget(){
	return register_widget("ubtheme_social_widget");
}