<?php
add_action('widgets_init', 'post_widgets');

function post_widgets()
{
	register_widget('Post_Widget');
}

class Post_Widget extends WP_Widget {

	function Post_Widget()
	{
		$widget_ops = array('classname' => 'widget_post', 'description' => '');

		$control_ops = array('id_base' => 'post-widget');

		$this->WP_Widget('post-widget', 'Ublog Post Widget', $widget_ops, $control_ops);
	}

	function widget($args, $instance)
	{
		extract($args);

		echo $before_widget;
		if(isset($instance['title'])) {
			echo force_balance_tags($before_title.$instance['title'].$after_title);
		}
		$html = '';
		if(isset($instance['post_id'])) {
			$post = get_post($instance['post_id']);
			setup_postdata($post);
			$html = '<h4><a href="'. get_permalink($post->ID) .'">'. get_the_title($post->ID) .'</a></h4>';
			if( get_post_thumbnail_id($post->ID) ) {
				$html .= '<a class="thumbnail ub-thumbnail ub-post-format-'. sanitize_html_class(get_post_format($post->ID)) .'" href="'. get_permalink($post->ID) .'"><img alt="'. get_the_title($post->ID) .'" src="'. ub_get_attachment_image_src(get_post_thumbnail_id($post->ID),'ub_medium') .'" /><span class="wrap-overlay"><span class="fa overlay-icon"></span></span></a>';
			}
			$html .= get_excerpt_by_id($post,20);
			wp_reset_postdata();
		}
		echo force_balance_tags($html);
		echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		return $new_instance;		
	}

	function form($instance)
	{ 
	?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">Title:</label>
			<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('post_id')); ?>">Select Post Show Widget:</label>
			<?php 
				rs::postlist(array(
					'name' => $this->get_field_name( 'post_id' ),
					'value' => isset($instance['post_id']) ? $instance['post_id'] : ''
				));
			?>
		</p>
	<?php
	}
}
?>