<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Ublog
 */

get_header(); ?>

	<div id="content">
		<div class="row inner-content">
			<!-- ===== Left Content ======= -->
			<div id="main_content" class="col-sm-8 ub-list-archive">
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'loop', 'single' ); ?>

					<?php
						// If comments are open or we have at least one comment, load up the comment template
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;
					?>

				<?php endwhile; // end of the loop. ?>
				
				<?php rst_paging_nav() ?>
			</div>
			<!--End-Left-Content-->
			<!-- ===== Sidebar ======= -->
			<div id="sidebar" class="widget-area col-sm-4" role="complementary">
				 <?php 
					if ( ! dynamic_sidebar('sidebar-home') ) {
						$instance = 'sortby=post_modified';
						$args = 'before_title=<h3 class="widget-title">&after_title=</h3>';
						
						the_widget( 'WP_Widget_Search',$instance,$args );
						the_widget( 'WP_Widget_Recent_Posts',$instance,$args );
						the_widget( 'WP_Widget_Recent_Comments',$instance,$args );
						the_widget( 'WP_Widget_Archives',$instance,$args );
						the_widget( 'WP_Widget_Categories',$instance,$args );
						the_widget( 'WP_Widget_Meta',$instance,$args );
					}
					else {
						dynamic_sidebar('sidebar-home');
					}
				?>
			</div>
			<!--End-Sidebar-->
		</div>
	</div>

<?php get_footer(); ?>
