<?php
/**
 * The template for displaying all single posts.
 *
 * @package Ublog
 */

get_header(); ?>

	<div id="content">
		
		<?php
			$layout_thumbnail = ( rs::getField('template_style') == 2 || rs::getField('template_style') == 3 ) ? rs::getField('singe_thumbnail_full') : ( get_theme_mod('singe_thumbnail_full') ? get_theme_mod('singe_thumbnail_full') : false );
			
			if( !get_theme_mod('singe_hide_breadcrumb') ) {
				rst_wp_bac_breadcrumb();
			}
		?>

		<?php
			if( $layout_thumbnail ) {
				get_template_part( 'thumbnail' );
			}
		?>
		
		<div class="row inner-content">
			<?php
				$single_style = rs::getField('template_style') ? rs::getField('template_style') : ( get_theme_mod('rst_single_layout') ? get_theme_mod('rst_single_layout') : 3 );
				$sidebar = rs::getField('template_style') ? rs::getField('rst_show_widget') : get_theme_mod('rst_single_sidebar');
				
				$class = 'col-sm-12';
				if( $single_style == 2 || $single_style == 3 )
					$class = 'col-sm-8';
				if( $single_style == 2 && $sidebar ) {
			?>
				<div id="sidebar" class="widget-area col-sm-4" role="complementary">
					<?php dynamic_sidebar( $sidebar ); ?>
				</div><!-- #secondary -->
			<?php
				}
			?>
			
			<!-- ===== Archive Content ======= -->
			<div id="main_content" class="<?php echo sanitize_html_class($class) ?> ub-list-archive">
			
			
			<?php if ( have_posts() ) : ?>

				<?php 
					if( !$layout_thumbnail ) {
						get_template_part( 'thumbnail' );
					}
				?>
			
				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php
						/* Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'content', 'single' );
					?>

				<?php endwhile; ?>

				
				<?php rst_paging_nav(); ?>

			<?php else : ?>

				<?php get_template_part( 'content', 'none' ); ?>

			<?php endif; ?>

			</div>
			<!--End-Archive-Content-->
			<?php
				if( $single_style == 3 && $sidebar ) {
			?>
				<div id="sidebar" class="widget-area col-sm-4" role="complementary">
					<?php dynamic_sidebar( $sidebar ); ?>
				</div><!-- #secondary -->
			<?php
				}
			?>
		</div>
	</div>

<?php get_footer(); ?>
