<?php
if( ! function_exists( 'ub_vc_large' ) ) {
	function ub_vc_large( $attr, $content = null )
	{
		extract(shortcode_atts(array(
			'title'							=> '',
			'terms'							=> '',
			'tags'							=> '',
			'sort_order_by' 				=> '',
			'sort_order' 					=> '',
			'posts_per_page'				=> '',
			'section_type'					=> '',
			'is_show_thumbnail'				=> '',
			'type_show_thumbnail_video'		=> '',
			'type_show_thumbnail_gallery' 	=> '',
			'is_show_pavi' 					=> '',
			'is_show_categories'			=> '',
			'is_show_date' 					=> '',
			'is_show_comment' 				=> '',
			'is_show_view' 					=> '',
			'is_show_author' 				=> '',
			'is_show_excerpt' 				=> '',
			'excerpt_length' 				=> '',
			'extra_class_name' 				=> ''
		), $attr));
		
		global $ub_agrs;
		$ub_agrs['type'] = 'large';
		
		$ub_agrs['category'] = isset($attr['terms']) ? $attr['terms'] : '';
		$ub_agrs['tags'] = isset($attr['tags']) ? $attr['tags'] : ''; $ub_agrs['tags'] = str_replace(",", "+", $ub_agrs['tags']);
		$ub_agrs['order_by'] = isset($attr['sort_order_by']) ? $attr['sort_order_by'] : 'post_date';
		$ub_agrs['order'] = isset($attr['sort_order']) ? $attr['sort_order'] : 'DESC';
		$ub_agrs['posts_per_page'] = isset($attr['posts_per_page']) ? $attr['posts_per_page'] : get_option('posts_per_page');
		$ub_agrs['section_type'] = isset($attr['section_type']) ? $attr['section_type'] : 'large';
		$ub_agrs['is_show_thumbnail'] = isset($attr['is_show_thumbnail']) ? $attr['is_show_thumbnail'] : true;
		$ub_agrs['type_show_thumbnail_video'] = isset($attr['type_show_thumbnail_video']) ? $attr['type_show_thumbnail_video'] : 'image';
		$ub_agrs['type_show_thumbnail_gallery'] = isset($attr['type_show_thumbnail_gallery']) ? $attr['type_show_thumbnail_gallery'] : 'image';
		$ub_agrs['is_show_pavi'] = isset($attr['is_show_pavi']) ? $attr['is_show_pavi'] : false;
		$ub_agrs['is_show_categories'] = isset($attr['is_show_categories']) ? $attr['is_show_categories'] : false;
		$ub_agrs['is_show_date'] = isset($attr['is_show_date']) ? $attr['is_show_date'] : false;
		$ub_agrs['is_show_comment'] = isset($attr['is_show_comment']) ? $attr['is_show_comment'] : false;
		$ub_agrs['is_show_view'] = isset($attr['is_show_view']) ? $attr['is_show_view'] : false;
		$ub_agrs['is_show_author'] = isset($attr['is_show_author']) ? $attr['is_show_author'] : false;
		$ub_agrs['is_show_excerpt'] = isset($attr['is_show_excerpt']) ? $attr['is_show_excerpt'] : false;
		$ub_agrs['excerpt_length'] = isset($attr['excerpt_length']) ? $attr['excerpt_length'] : 60;
		$ub_agrs['extra_class_name'] = isset($attr['extra_class_name']) ? $attr['extra_class_name'] : '';
		
		$output = '';
		
		$rstkey = uniqid();
		$output .= '<script type="text/javascript">';
			$output .= 'var rst_'. esc_html($rstkey) .' = new rst_blocks();';
			$output .= 'rst_'. esc_html($rstkey) .'.atts = \''. json_encode($ub_agrs) .'\';';
			$output .= 'rst_'. esc_html($rstkey) .'.url = \''. admin_url( "admin-ajax.php" ) .'\';';
		$output .= '</script>';
		
		$args = ub_query_shortcode($ub_agrs);
	
		$the_query = new WP_Query( $args );
		if( !empty($attr['title']) )
			$output .= '<h2 class="rs-title-box">'. $attr['title'] .'</h2>';
		$output .= '<div class="'. (isset($attr['extra_class_name']) ? sanitize_html_class($attr['extra_class_name']) : '') .' ub-blog-box wrap_ajax ub-blog-large '. (isset($attr['section_type']) ? 'ub-type-'.$attr['section_type'] : '') .'">';
		$output .= '<div class="wrap_inner_ajax">';
		while ($the_query->have_posts() ) : $the_query->the_post();
			$output .= ub_get_template_part( 'content', get_post_format()  ); 
		endwhile;
		$output .= '</div>';
		if( $ub_agrs['is_show_pavi'] ) $output .= rst_paging_nav_vc($the_query,$ub_agrs,$rstkey);
		wp_reset_query(); wp_reset_postdata();
		$output .= '</div>';
		
		return $output;
	}
}
add_shortcode( 'ub_large', 'ub_vc_large' );


vc_map( array (
	'base' 			=> 'ub_large',
	'name' 			=> __('Large', 'mfn-opts'),
	'category' 		=> __('Content', 'mfn-opts'),
	'icon' 			=> 'ub_icon_shortcode',
	'params' 		=> array (

		array (
			'param_name' 	=> 'title',
			'type' 			=> 'textfield',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Title', 'mfn-opts'),
			'admin_label'	=> true,
		),
		array (
			'param_name' 	=> 'terms',
			'type' 			=> 'terms',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Categories', 'mfn-opts'),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'tags',
			'type' 			=> 'textfield',
			'heading' 		=> __('Filter by tag slug', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'Example: tag1,tag2,tag3...'
		),
		
		array (
			'param_name' 	=> 'sort_order_by',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Sort Order', 'mfn-opts'),
			'value'			=> array(
									'Date Time' => 'date',
									'Title' => 'title',
									'Popular' => 'popular',
									'Popular On Week' => 'popular_week',
									'Popular On Month' => 'popular_month',
									'Highest rated' => 'reviews',
									'Random' => 'random'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'sort_order',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Order', 'mfn-opts'),
			'value'			=> array(
									'DESC' => 'DESC',
									'ASC' => 'ASC'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'posts_per_page',
			'type' 			=> 'textfield',
			'heading' 		=> __('Posts Per Page', 'mfn-opts'),
			'admin_label'	=> true,
			'value'			=> 10,
			'description' 	=> 'Input integer value for Posts Per Page.'
		),
		
		array (
			'param_name' 	=> 'section_type',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Section Type', 'mfn-opts'),
			'admin_label'	=> true,
			'value'			=> array(
									'Large' => 'large',
									'Medium' => 'medium',
									'Small' => 'small'
								)
		),
		
		array (
			'param_name' 	=> 'is_show_thumbnail',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Thumbnail', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'type_show_thumbnail_video',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Video/Audio Thumbnail Type', 'mfn-opts'),
			'value'			=> array(
									'Thumbnail Image' => 'image',
									'Video/Audio' => 'more'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'type_show_thumbnail_gallery',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Gallery Thumbnail Type', 'mfn-opts'),
			'value'			=> array(
									'Thumbnail Image' => 'image',
									'Slider' => 'slider'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_pavi',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Navi', 'mfn-opts'),
			'value'			=> array(
									'No' => '0',
									'Number' => 'number',
									'Load More' => 'load_more',
									'Auto Load' => 'load_auto',
									'Next/Prev' => 'next_prev',
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_categories',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Categories', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_date',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Date', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_comment',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Comment Count', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_view',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show View Count', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_author',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Author', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_excerpt',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Excerpt ', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'excerpt_length',
			'type' 			=> 'textfield',
			'heading' 		=> __('Excerpt Length', 'mfn-opts'),
			'value'			=> 60,
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'extra_class_name',
			'type' 			=> 'textfield',
			'heading' 		=> __('Extra class name', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.'
		)
	)
));
