<?php
if( ! function_exists( 'ub_vc_smart_box_02' ) ) {
	function ub_vc_smart_box_02( $attr, $content = null )
	{
		extract(shortcode_atts(array(
			'title'							=> '',
			'terms'							=> '',
			'tags'							=> '',
			'sort_order_by' 				=> '',
			'sort_order' 					=> '',
			'column' 						=> '',
			'posts_per_page'				=> '',
			'is_type_categories'			=> '',
			'is_show_thumbnail'				=> '',
			'is_show_categories' 			=> '',
			'is_show_date' 					=> '',
			'is_show_comment' 				=> '',
			'is_show_view' 					=> '',
			'is_show_author' 				=> '',
			'is_show_excerpt' 				=> '',
			'excerpt_length' 				=> '',
			'extra_class_name' 				=> '',
		), $attr));
		
		global $ub_agrs;
		$ub_agrs['type'] = 'smart_box_02';
		
		$ub_agrs['title'] = isset($attr['title']) ? $attr['title'] : '';
		$ub_agrs['category'] = isset($attr['terms']) ? $attr['terms'] : '';
		$ub_agrs['tags'] = isset($attr['tags']) ? $attr['tags'] : ''; $ub_agrs['tags'] = str_replace(",", "+", $ub_agrs['tags']);
		$ub_agrs['order_by'] = isset($attr['sort_order_by']) ? $attr['sort_order_by'] : 'post_date';
		$ub_agrs['order'] = isset($attr['sort_order']) ? $attr['sort_order'] : 'DESC';
		$ub_agrs['column'] = isset($attr['column']) ? $attr['column'] : 3;
		$ub_agrs['posts_per_page'] = isset($attr['posts_per_page']) ? $attr['posts_per_page'] : get_option('posts_per_page');
		$ub_agrs['is_type_categories'] = isset($attr['is_type_categories']) ? $attr['is_type_categories'] : 0;
		$ub_agrs['is_show_thumbnail'] = isset($attr['is_show_thumbnail']) ? $attr['is_show_thumbnail'] : true;
		$ub_agrs['is_show_categories'] = isset($attr['is_show_categories']) ? $attr['is_show_categories'] : false;
		$ub_agrs['is_show_date'] = isset($attr['is_show_date']) ? $attr['is_show_date'] : false;
		$ub_agrs['is_show_comment'] = isset($attr['is_show_comment']) ? $attr['is_show_comment'] : false;
		$ub_agrs['is_show_view'] = isset($attr['is_show_view']) ? $attr['is_show_view'] : false;
		$ub_agrs['is_show_author'] = isset($attr['is_show_author']) ? $attr['is_show_author'] : false;
		$ub_agrs['is_show_excerpt'] = isset($attr['is_show_excerpt']) ? $attr['is_show_excerpt'] : false;
		$ub_agrs['excerpt_length'] = isset($attr['excerpt_length']) ? $attr['excerpt_length'] : 60;
		$ub_agrs['extra_class_name'] = isset($attr['extra_class_name']) ? $attr['extra_class_name'] : '';
		
		return rst_display_block($ub_agrs);
	}
}
add_shortcode( 'ub_smart_box_02', 'ub_vc_smart_box_02' );


vc_map( array (
	'base' 			=> 'ub_smart_box_02',
	'name' 			=> __('Smart Box 02', 'mfn-opts'),
	'category' 		=> __('Content', 'mfn-opts'),
	'icon' 			=> 'ub_icon_shortcode',
	'params' 		=> array (
		array (
			'param_name' 	=> 'title',
			'type' 			=> 'textfield',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Title', 'mfn-opts'),
			'admin_label'	=> true,
		),
		array (
			'param_name' 	=> 'terms',
			'type' 			=> 'terms',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Categories', 'mfn-opts'),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'tags',
			'type' 			=> 'textfield',
			'heading' 		=> __('Filter by tag slug', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'Example: tag1,tag2,tag3...'
		),
		
		array (
			'param_name' 	=> 'sort_order_by',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Sort Order', 'mfn-opts'),
			'value'			=> array(
									'Date Time' => 'date',
									'Title' => 'title',
									'Popular' => 'popular',
									'Popular On Week' => 'popular_week',
									'Popular On Month' => 'popular_month',
									'Featured' => 'featured',
									'Highest rated' => 'reviews',
									'Random' => 'random'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'sort_order',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Order', 'mfn-opts'),
			'value'			=> array(
									'DESC' => 'DESC',
									'ASC' => 'ASC'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'posts_per_page',
			'type' 			=> 'textfield',
			'heading' 		=> __('Number Posts', 'mfn-opts'),
			'admin_label'	=> true,
			'value'			=> 10,
			'description' 	=> 'Input integer value for Number Posts.'
		),
		
		array (
			'param_name' 	=> 'is_show_categories',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Categories', 'mfn-opts'),
			'value'			=> array(
									'No' => '0',
									'Yes' => '1'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_date',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Date', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_comment',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Comment Count', 'mfn-opts'),
			'value'			=> array(
									'No' => '0',
									'Yes' => '1'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_view',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show View Count', 'mfn-opts'),
			'value'			=> array(
									'No' => '0',
									'Yes' => '1'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_author',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Author', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'is_show_excerpt',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Show Excerpt ', 'mfn-opts'),
			'value'			=> array(
									'Yes' => '1',
									'No' => '0'
								),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'excerpt_length',
			'type' 			=> 'textfield',
			'heading' 		=> __('Excerpt Length', 'mfn-opts'),
			'value'			=> 15,
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'extra_class_name',
			'type' 			=> 'textfield',
			'heading' 		=> __('Extra class name', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.'
		)
	)
));
