<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package Ublog
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

<?php if ( have_comments() ) : ?>

	<?php // You can start editing here -- including this comment! ?>
	<h3 class="comment-reply-title"><span><?php rst_the_translate('Comment','comment') ?></span></h4>
	<div class="space"></div>
	<?php rst_comments(get_the_ID()); ?>
	
<?php endif; ?>
	
	<?php
	$commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
	$args = array(
		'id_form' => 'contactForm',
		'fields' => apply_filters(
			'comment_form_default_fields', array(
				'author' => '<div class="form-group wow fadeIn">
								<input id="author" placeholder="'. rst_get_translate('Name','name') .':" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' />
							</div>',
				'email' => '<div class="form-group wow fadeIn">
								<input id="email" placeholder="'. rst_get_translate('Email','email') .':" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' />
							</div>',
				'url' => '<div class="form-group wow fadeIn">
								<input id="url" placeholder="'. rst_get_translate('Website','website') .':" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" />
							</div>'
			)
		),
		'comment_field' => '<div class="form-group">
								<textarea id="comment" name="comment" placeholder="'. rst_get_translate('Message','your_message') .':" cols="45" rows="8" aria-required="true"></textarea>
							</div>',
		'comment_notes_after' => '',
		'comment_notes_before' => '',
		'title_reply' => '<span>'. rst_get_translate('Leave a Comment','leave_a_comment') .'</span>',
		'label_submit' => rst_get_translate('Post a Comment','sent_comment')
	);
  ?>
  <?php comment_form($args, get_the_ID()); ?>

</div><!-- #comments -->
