<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Ublog
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	
	<?php if( get_theme_mod('des_seo') ) { ?>
	<meta name="description" content="<?php echo esc_attr(get_theme_mod('des_seo')) ?>">
	<?php } ?>
	<?php if( get_theme_mod('keywords_seo') ) { ?>
	<meta name="keywords" content="<?php echo esc_attr(get_theme_mod('keywords_seo')) ?>">
	<?php } ?>
	<?php if( get_theme_mod('author_seo') ) { ?>
	<meta name="author" content="<?php echo esc_attr(get_theme_mod('author_seo')) ?>">
	<?php } ?>
	
	<!-- Mobile Specific Metas
	================================================== -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	
	<!-- Favicons
    ================================================== -->
	<?php if( get_theme_mod('favicon') ) { ?>
	<link rel="shortcut icon" href="<?php echo esc_url(get_theme_mod('favicon')) ?>" type="image/x-icon">
	<?php } else { ?>
	<link rel="shortcut icon" href="<?php echo get_template_directory_uri() ?>/images/favicon.ico" type="image/x-icon">
	<?php } ?>

	<?php if( get_theme_mod('favicon_iphone') ) { ?>
	<link rel="apple-touch-icon" href="<?php echo esc_url(get_theme_mod('favicon_iphone')) ?>">
	<?php } else { ?>
	<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri() ?>/images/apple-touch-icon.png">
	<?php } ?>

	<?php if( get_theme_mod('favicon_ipad') ) { ?>
	<link rel="apple-touch-icon" sizes="72x72" href="<?php echo esc_url(get_theme_mod('favicon_ipad')) ?>">
	<?php } else { ?>
	<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri() ?>/images/apple-touch-icon-72x72.png">
	<?php } ?>

	<?php if( get_theme_mod('favicon_ipad_retina') ) { ?>
	<link rel="apple-touch-icon" sizes="114x114" href="<?php echo esc_url(get_theme_mod('favicon_ipad_retina')) ?>">
	<?php } else { ?>
	<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri() ?>/images/apple-touch-icon-114x114.png">
	<?php } ?>
	
	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
   
    <![endif]-->

	<?php wp_head(); ?>
</head>


<body <?php body_class(); ?>>
<div id="wrapper">
	<!--========================= Header ========================= -->	
	<?php
		$header_layout = 'layout-1';
		if( get_theme_mod('rst_header_layout') ) $header_layout = get_theme_mod('rst_header_layout');
	?>
	<div id="header" class="header-<?php echo sanitize_html_class($header_layout) ?>">
		<?php get_template_part( 'inc/header/header', $header_layout ); ?>
	</div><!--End-header-->
	<?php if( !get_theme_mod('rst_header_is_off_sticky') ) get_template_part( 'inc/header/header', 'sticky' ); ?>