<?php
	// type use: text, checkbox, radio, select, dropdown-pages, textarea, color, gallery, image, rsbackground
	
	$rst_widgets = rst_get_my_widgets();
	
	//Background Body
	rs::addCustomizeTab(array(
		'title' => 'Background', 
		'name' => 'rst_customize_bg',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Background Body',
				'type' 			=> 'rsbackground',
				'name' 			=> 'bg_body',
				'css_selector'	=> 'body',
				'default_value'	=> array(
					'background-color' => '#eaeaea'
				)
			),
			array(
				'label' 		=> 'Background Wrapper',
				'type' 			=> 'rsbackground',
				'name' 			=> 'bg_wrapper',
				'css_selector'	=> '#wrapper',
				'default_value'	=> array(
					'background-color' => '#fff'
				)
			)
		)
	));
	
	
	rs::addCustomizePanel(array(
		'name' => 'panel_fonts',
		'title' => 'Custom Fonts'
	) );
		
	//Fonts > Font Site
	rs::addCustomizeTab(array(
		'title' => 'Font on Site', 
		'name' => 'rst_customize_fonts',
		'panel'	=> 'panel_fonts',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Body',
				'type'			=> 'font',
				'name'			=> 'font_body',
				'css_selector'	=> 'body,p',
				'default_value'	=> array(
					'font-family' => 'Open Sans',
					'font-size'	=> '13px',
					'font-weight' => '400'
				)
			),
			array(
				'label' 		=> 'H1',
				'type'			=> 'font',
				'name'			=> 'font_h1',
				'css_selector'	=> 'h1',
				'default_value'	=> array(
					'font-size'	=> '32px',
					'line-height' => '36px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			),
			array(
				'label' 		=> 'H2',
				'type'			=> 'font',
				'name'			=> 'font_h2',
				'css_selector'	=> 'h2',
				'default_value'	=> array(
					'font-size'	=> '28px',
					'line-height' => '32px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			),
			array(
				'label' 		=> 'H3',
				'type'			=> 'font',
				'name'			=> 'font_h3',
				'css_selector'	=> 'h3',
				'default_value'	=> array(
					'font-size'	=> '24px',
					'line-height' => '28px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			),
			array(
				'label' 		=> 'H4',
				'type'			=> 'font',
				'name'			=> 'font_h4',
				'css_selector'	=> 'h4',
				'default_value'	=> array(
					'font-size'	=> '20px',
					'line-height' => '24px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			),
			array(
				'label' 		=> 'H5',
				'type'			=> 'font',
				'name'			=> 'font_h5',
				'css_selector'	=> 'h5',
				'default_value'	=> array(
					'font-size'	=> '18px',
					'line-height' => '22px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			),
			array(
				'label' 		=> 'H6',
				'type'			=> 'font',
				'name'			=> 'font_h6',
				'css_selector'	=> 'h6',
				'default_value'	=> array(
					'font-size'	=> '14px',
					'line-height' => '18px',
					'font-family' => 'Lato',
					'font-weight' => '700',
				)
			)
		)
	));
	
	//Fonts > Topbar
	rs::addCustomizeTab(array(
		'title' => 'Top bar Menu', 
		'name' => 'rst_customize_fonts_topbar',
		'panel'	=> 'panel_fonts',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Top bar Menu',
				'type'			=> 'font',
				'name'			=> 'font_top_bar',
				'css_selector'	=> '#header .rst-topbar .nav-topbar li a',
				'default_value'	=> array(
					'font-size'	=> '13px',
					'line-height' => '18px',
					'font-family' => 'Open Sans',
					'font-weight' => '400',
				)
			)
		)
	));
	
	//Fonts > Main Menu
	rs::addCustomizeTab(array(
		'title' => 'Main Menu Font', 
		'name' => 'rst_customize_fonts_main_menu',
		'panel'	=> 'panel_fonts',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Main Menu Font',
				'type'			=> 'font',
				'name'			=> 'font_main_menu',
				'css_selector'	=> '.rst-nav-menu .menu-item > a',
				'default_value'	=> array(
					'font-size'	=> '14px',
					'line-height' => '18px',
					'font-family' => 'Open Sans',
					'font-weight' => '600',
				)
			),
			array(
				'label' 		=> 'Sub Menu Font',
				'type'			=> 'font',
				'name'			=> 'font_sub_menu',
				'css_selector'	=> '.rst-nav-menu .rst-not-mega .menu-item > a, .rst-nav-menu li .ub-mega-grid .ub-mega-child-cats a, .rst-nav-menu .category_with_sub .rst-list-post-of-category span',
				'default_value'	=> array(
					'font-size'	=> '14px',
					'line-height' => '18px',
					'font-family' => 'Open Sans',
					'font-weight' => '400',
				)
			)
		)
	));
	
	
	//Fonts > Footer
	rs::addCustomizeTab(array(
		'title' => 'Footer', 
		'name' => 'rst_customize_fonts_widget',
		'panel'	=> 'panel_fonts',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Footer',
				'type'			=> 'font',
				'name'			=> 'font_footer',
				'css_selector'	=> '.top-footer .widget,.top-footer .widget p, .bottom-footer p',
				'default_value'	=> array(
					'font-size'	=> '13px',
					'line-height' => '25px',
					'font-family' => 'Open Sans',
					'font-weight' => '400',
				)
			),
			array(
				'label' 		=> 'Color',
				'type' 			=> 'color',
				'default_value' => '#cccccc',
				'name' 			=> 'rst_footer_color',
				'css'			=> '.top-footer .widget, .bottom-footer p, .widget_about .mail a, #footer .widget_tag_cloud .tagcloud a{ color: $value }'
			)
		)
	));
	
	// Theme Color
	rs::addCustomizeTab(array(
		'title' => 'Theme Color', 
		'name' => 'rst_customize_theme_color',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Theme Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'rst_theme_color',
				'css'			=> '
					h3.widget-title,
					h3.widget-title a,
					h1.entry-title,
					h1.page-title,
					.td-search-query,
					.social .fa:hover,
					h2.rs-title-box span,
					h3.widget-title span,
					#header .rst-topbar .nav-topbar li a:hover, 
					#header .social .rst-list-social li a:hover,
					.comment-reply-title span,
					.rst-nav-menu li li:hover > a,
					.rst-nav-menu li .ub-mega-grid a:hover,
					.widget_news ul.tab-post-new li.active a,
					.comment-reply-link,
					h2.rs-title-box,
					.error-404 header h1,
					.error-404 header h3 {
						color: $value;
					}
					blockquote,
					h2.rs-title-box span:after,
					h3.widget-title span:after,
					.comment-reply-title span:after,
					.widget_news ul.tab-post-new li.active a:before,
					.main-menu.border-line,
					.wp-pagenavi span.current, .wp-pagenavi a:hover {
						border-color: $value;
					}
					.breadcrumb > li.home:before {
						border-left-color: $value;
					}
					.rst-nav-menu > li:hover,
					.rst-nav-menu > li.current-menu-item,
					.ub-scroll-new .bx-wrapper .bx-next:hover,
					.ub-scroll-new .bx-wrapper .bx-prev:hover,
					.thumbnail-slider .bx-wrapper .bx-prev:hover,
					.thumbnail-slider .bx-wrapper .bx-next:hover,
					.top-footer .newsletter-widget form input[type="submit"],
					.fancybox-button:hover,
					.ub-tags a:hover,
					.breadcrumb li.home,
					.social .rst-breaking-news span.breaking,
					.wp-pagenavi span.current, .wp-pagenavi a:hover,
					.rst_ajax_load_more,
					.error-404 .ub-button, 
					.comment-respond form input[type="submit"] {
						background-color: $value;
					}
				'
			),
			array(
				'label' 		=> 'Link Color',
				'type' 			=> 'color',
				'default_value' => '#428bca',
				'name' 			=> 'rst_link_color',
				'css'			=> 'a{ color: $value }'
			),
			array(
				'label' 		=> 'Hover Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'rst_link_hover_color',
				'css'			=> 'a:hover, 
					.widget a:hover, 
					span.admin a:hover, 
					span.date a:hover, 
					span.category a:hover, 
					span.comment a:hover, 
					.ub-blog-post h4 a:hover, 
					.widget_news .comment-text-side:hover,
					.widget_news .info-post-new h5 a:hover,
					.ub-box-horizontal-news .link ul li a:hover,
					.rst-nav-menu a:hover, 
					.rst-nav-menu li.rst-not-mega > ul li a:hover, 
					.navigation a:hover, 
					.comment-reply-link:hover{ color: $value }'
			)
		)
	) );
	
	// Favicon
	rs::addCustomizeTab(array(
		'title' => 'Favicon', 
		'name' => 'rst_customize_favicon',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Favicon',
				'type' 			=> 'image',
				'description'	=> '16x16 px.',
				'name' 			=> 'favicon'
			),
			array(
				'label' 		=> 'Apple iPad Retina Icon',
				'type' 			=> 'image',
				'description'	=> '144x144 px.',
				'name' 			=> 'favicon_ipad_retina'
			),
			array(
				'label' 		=> 'Apple iPad Icon',
				'type' 			=> 'image',
				'description'	=> '75x75 px.',
				'name' 			=> 'favicon_ipad'
			),
			array(
				'label' 		=> 'Apple iPhone Icon',
				'type' 			=> 'image',
				'description'	=> '57x57 px.',
				'name' 			=> 'favicon_iphone'
			)
		)
	) );
	
	
	// Header Panel
	rs::addCustomizePanel(array(
		'name' => 'panel_header',
		'title' => 'Header'
	) );
	
	// Header 
	rs::addCustomizeTab(array(
		'title' => 'Header Setting',
		'name' => 'rst_customize_header',
		'priority' => 30,
		'panel'		=> 'panel_header',
		'controls' => array(
			array(
				'label' => 'Turn off Header Sticky',
				'type' => 'checkbox',
				'name' => 'rst_header_is_off_sticky'
			),
			array(
				'label' 		=> 'Header Layout',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_header_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'layout-1' => get_template_directory_uri() .'/inc/css/images/header_layout_1.jpg',
					'layout-2' => get_template_directory_uri() .'/inc/css/images/header_layout_2.jpg',
					'layout-3' => get_template_directory_uri() .'/inc/css/images/header_layout_3.jpg',
					'layout-4' => get_template_directory_uri() .'/inc/css/images/header_layout_4.jpg',
				)
			),
			array(
				'label' => 'Left Header Sections',
				'name' => 'header_sidebar_left',
				'type' => 'select',
				'items' => $rst_widgets,
				'conditional_logic' => array(
					'items' => array(
						'rst_header_layout' => 'layout-2|layout-4'
					)
				)
			),
			array(
				'label' => 'Right Header Sections',
				'name' => 'header_sidebar_right',
				'type' => 'select',
				'items' => $rst_widgets
			),
			array(
				'label' 		=> 'Header Background',
				'type' 			=> 'rsbackground',
				'name' 			=> 'bg_header',
				'css_selector'	=> '#header',
				'default_value'	=> array(
					'background-color' => '#f5f5f5'
				)
			),
			array(
				'label' 		=> 'Header Height',
				'type' 			=> 'text',
				'name' 			=> 'header_height',
				'css'			=> '.top-header { height: $value }'
			),
			array(
				'label' 		=> 'Header Padding Top',
				'type' 			=> 'text',
				'name' 			=> 'header_padding_top',
				'css'			=> '.top-header { padding-top: $value }'
			),
			array(
				'label' 		=> 'Header Padding Bottom',
				'type' 			=> 'text',
				'name' 			=> 'header_padding_bottom',
				'css'			=> '.top-header { padding-bottom: $value }'
			),
			array(
				'label' 		=> 'Header Padding Left',
				'type' 			=> 'text',
				'name' 			=> 'header_padding_left',
				'css'			=> '.top-header { padding-left: $value }'
			),
			array(
				'label' 		=> 'Header Padding Right',
				'type' 			=> 'text',
				'name' 			=> 'header_padding_right',
				'css'			=> '.top-header { padding-right: $value }'
			),
			array(
				'label' 		=> 'Hide Search',
				'type' 			=> 'checkbox',
				'name' 			=> 'header_hide_search'
			),
		)
	) );
	
	
	// Header > Topbar
	rs::addCustomizeTab(array(
		'title' => 'Top Bar',
		'name' => 'rst_customize_header_topbar',
		'priority' => 30,
		'panel'		=> 'panel_header',
		'controls' => array(
			array(
				'label' 		=> 'Hide Top Bar',
				'type' 			=> 'checkbox',
				'name' 			=> 'header_hide_topbar'
			),
			array(
				'label' 		=> 'Background Color',
				'type' 			=> 'color',
				'default_value' => '#f8f8f8',
				'name' 			=> 'bg_header_topbar_color',
				'css'			=> '#header .rst-topbar{ background-color: $value }'
			),
			array(
				'label' 		=> 'Font Color',
				'type' 			=> 'color',
				'default_value' => '#404040',
				'name' 			=> 'text_header_topbar_color',
				'css'			=> '#header .rst-topbar .nav-topbar li a, #header .social .rst-list-social li a{ color: $value }'
			),
			array(
				'label' 		=> 'Hover Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'text_header_topbar_hover_color',
				'css'			=> '#header .rst-topbar .nav-topbar li a:hover, #header .social .rst-list-social li a:hover{ color: $value }'
			),
		)
	) );
	
	
	// Header > Main Menu
	rs::addCustomizeTab(array(
		'title' => 'Main Menu',
		'name' => 'rst_customize_header_main_menu',
		'priority' => 30,
		'panel'		=> 'panel_header',
		'controls' => array(
			array(
				'label' 		=> 'Background Color',
				'type' 			=> 'color',
				'default_value' => '#404040',
				'name' 			=> 'bg_header_menu_color',
				'css'			=> '.main-menu{ background-color: $value }'
			),
			array(
				'label' 		=> 'Hover BackGround Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'bg_header_menu_hover_color',
				'css'			=> '.rst-nav-menu > li:hover,
									.rst-nav-menu > li.current-menu-item{ background-color: $value }'
			),
			array(
				'label' 		=> 'Turn off Border Line',
				'type' 			=> 'checkbox',
				'name' 			=> 'main_menu_turn_off_border_line'
			),
			array(
				'label' 		=> 'Border line Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'main_menu_border_line_color',
				'css'			=> '.main-menu.border-line { border-color: $value; }'
			),
			array(
				'label' 		=> 'Font Color',
				'type' 			=> 'color',
				'default_value' => '#fff',
				'name' 			=> 'text_header_menu_color',
				'css'			=> '.rst-nav-menu a { border-color: $value; }'
			),
			array(
				'label' 		=> 'Hover Color',
				'type' 			=> 'color',
				'default_value' => '#fff',
				'name' 			=> 'text_header_menu_hover_color',
				'css'			=> '.rst-nav-menu > li:hover > a, .rst-nav-menu > li.current-menu-item > a { color: $value; }'
			),
			array(
				'label' 		=> 'Sub Menu Color',
				'type' 			=> 'color',
				'default_value' => '#404040',
				'name' 			=> 'text_header_sub_menu_color',
				'css'			=> '.rst-nav-menu li.rst-not-mega ul li a, .rst-nav-menu li .ub-mega-grid a { color: $value; }'
			),
			array(
				'label' 		=> 'Sub Menu Hover Color',
				'type' 			=> 'color',
				'default_value' => '#ffba00',
				'name' 			=> 'text_header_sub_menu_hover_color',
				'css'			=> '.rst-nav-menu li.rst-not-mega ul li a:hover, .rst-nav-menu li .ub-mega-grid a:hover { color: $value; }'
			),
		)
	) );
	
	
	// Logo
	rs::addCustomizeTab(array(
		'title' => 'Logo', 
		'name' => 'rst_customize_logo',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Main Logo',
				'type' 			=> 'image',
				'name' 			=> 'rst_logo'
			),
			array(
				'label' 		=> 'Max Width',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_max_width',
				'css'			=> '.rst-logo img { max-width: $value }'
			),
			array(
				'label' 		=> 'Max Height',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_max_height',
				'css'			=> '.rst-logo img { max-height: $value }'
			),
			array(
				'label' 		=> 'Padding Top',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_padding_top',
				'default_value'	=> '10px',
				'css'			=> '.rst-logo { padding-top: $value }'
			),
			array(
				'label' 		=> 'Padding Bottom',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_padding_bottom',
				'default_value'	=> '0',
				'css'			=> '.rst-logo { padding-bottom: $value }'
			),
			array(
				'label' 		=> 'Padding Left',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_padding_bottom',
				'default_value'	=> '0',
				'css'			=> '.rst-logo { padding-left: $value }'
			),
			array(
				'label' 		=> 'Padding Right',
				'type' 			=> 'text',
				'name' 			=> 'rst_logo_padding_bottom',
				'default_value'	=> '0',
				'css'			=> '.rst-logo { padding-right: $value }'
			),
			array(
				'label' 		=> 'Mini Logo',
				'type' 			=> 'image',
				'name' 			=> 'rst_logo_mini'
			),
		)
	) );
	
	
	// Category
	rs::addCustomizeTab(array(
		'title' => 'Category Page', 
		'name' => 'rst_customize_category',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Layout Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_cat_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'1' => get_template_directory_uri() .'/inc/css/images/fullwidth.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/sidebar_left.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/sidebar_right.jpg'
				)
			),
			array(
				'name' => 'rst_cat_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $rst_widgets,
				'conditional_logic' => array(
					'items' => array(
						'rst_cat_layout' => '2|3'
					)
				)
			),
			array(
				'label' 		=> 'Template Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_cat_template',
				'default_value'	=> 'large',
				'items'        	=> array(
					'box' => get_template_directory_uri() .'/inc/icons/Box.jpg',
					'large' => get_template_directory_uri() .'/inc/icons/large.jpg',
					'grid' => get_template_directory_uri() .'/inc/icons/Grid.jpg',
					'medium' => get_template_directory_uri() .'/inc/icons/medium.jpg',
					'large-box' => get_template_directory_uri() .'/inc/icons/large-box.jpg',
					'large-medium' => get_template_directory_uri() .'/inc/icons/large-medium.jpg',
				)
			),
			array(
				'label' 		=> 'Number Columns',
				'type' 			=> 'select',
				'default_value'	=> 2,
				'name'			=> 'rst_cat_column',
				'items'			=> array(
					'2' => '2 Columns',
					'3' => '3 Columns',
					'4' => '4 Columns'
				),
				'description'	=> 'Number columns for template grid &amp; box',
				'conditional_logic' => array(
					'items' => array(
						'rst_cat_template' => 'grid|box'
					)
				)
			),
			array(
				'label' 		=> 'Posts Per Page',
				'type' 			=> 'text',
				'default_value'	=> 10,
				'name'			=> 'rst_cat_numberpost'
			),
			array(
				'label' => 'Thumbnail Type',
				'type' => 'radio',
				'name' => 'rst_cat_is_show_thumbnail',
				'items' => array(
					'image' => 'Thumbnail',
					'more'		=> 'Video/Gallery/Audio'
				),
				'default_value' => 'image',
			),
			array(
				'label' 		=> 'Excerpt Length',
				'type' 			=> 'text',
				'default_value'	=> 50,
				'name'			=> 'rst_cat_excerpt_length'
			),
			array(
				'label' 		=> 'Page Navi',
				'type' 			=> 'select',
				'default_value'	=> 1,
				'name'			=> 'rst_cat_pagenavi',
				'items'			=> array(
					'0' => 'No',
					'number' => 'Number',
					'load_more' => 'Load More',
					'load_auto' => 'Auto Load',
					'next_prev' => 'Next/Prev',
				),
				'default_value'	=> 'number',
			),
			array(
				'label' => 'Order By',
				'type' => 'select',
				'name' => 'rst_cat_orderby',
				'items' => array(
			      	'post_date' => 'Date Time',
			      	'post_title' => 'Title',
			      	'popular' => 'Popular',
			      	'popular_week' => 'Popular On Week',
			      	'popular_month' => 'Popular On Month',
			      	'featured' => 'Featured',
			      	'high_rated' => 'Highest rated',
			      	'rand' => 'Random'
			   	),
				'default_value'	=> 'post_date',
			),
			array(
				'label' => 'Order',
				'type' => 'select',
				'name' => 'rst_cat_order',
				'items' => array(
					'desc' => 'Descending',
			      	'asc' => 'Ascending'
			   	),
				'default_value'	=> 'desc',
			),
			array(
				'label' => 'Hidden Breadcrumb',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_breadcrumb'
			),
			array(
				'label' => 'Hidden Category Title',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_title'
			),
			array(
				'label' => 'Turn off Uppercase Category Title',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_off_uppercase_title'
			),
			array(
				'label' => 'Hiden Sub Category',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_sub_cat'
			),
			array(
				'label' => 'Hidden Date',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_date'
			),
			array(
				'label' => 'Hidden Category',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_category'
			),
			array(
				'label' => 'Hidden Excerpt',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_excerpt'
			),
			array(
				'label' => 'Hidden Author',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_author'
			),
			array(
				'label' => 'Hidden Count Comment',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_comment'
			),
			array(
				'label' => 'Hidden View',
				'type' => 'checkbox',
				'name' => 'rst_cat_is_hide_view'
			),
		)
	) );
	
	// Author
	rs::addCustomizeTab(array(
		'title' => 'Author Page', 
		'name' => 'rst_customize_author',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Layout Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_author_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'1' => get_template_directory_uri() .'/inc/css/images/fullwidth.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/sidebar_left.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/sidebar_right.jpg'
				)
			),
			array(
				'name' => 'rst_author_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $rst_widgets,
				'conditional_logic' => array(
					'items' => array(
						'rst_author_layout' => '2|3'
					)
				)
			),
			array(
				'label' 		=> 'Template Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_author_template',
				'default_value'	=> 'large',
				'items'        	=> array(
					'box' => get_template_directory_uri() .'/inc/icons/Box.jpg',
					'large' => get_template_directory_uri() .'/inc/icons/large.jpg',
					'grid' => get_template_directory_uri() .'/inc/icons/Grid.jpg',
					'medium' => get_template_directory_uri() .'/inc/icons/medium.jpg',
					'large-box' => get_template_directory_uri() .'/inc/icons/large-box.jpg',
					'large-medium' => get_template_directory_uri() .'/inc/icons/large-medium.jpg',
				)
			),
			array(
				'label' 		=> 'Number Columns',
				'type' 			=> 'select',
				'default_value'	=> 2,
				'name'			=> 'rst_author_column',
				'items'			=> array(
					'2' => '2 Columns',
					'3' => '3 Columns',
					'4' => '4 Columns'
				),
				'description'	=> 'Number columns for template grid &amp; box',
				'conditional_logic' => array(
					'items' => array(
						'rst_author_template' => 'grid|box'
					)
				)
			),
			array(
				'label' 		=> 'Posts Per Page',
				'type' 			=> 'text',
				'default_value'	=> 10,
				'name'			=> 'rst_author_numberpost'
			),
			array(
				'label' => 'Thumbnail Type',
				'type' => 'radio',
				'name' => 'rst_author_is_show_thumbnail',
				'items' => array(
					'image' => 'Thumbnail',
					'more'		=> 'Video/Gallery/Audio'
				),
				'default_value' => 'image',
			),
			array(
				'label' 		=> 'Excerpt Length',
				'type' 			=> 'text',
				'default_value'	=> 50,
				'name'			=> 'rst_author_excerpt_length'
			),
			array(
				'label' 		=> 'Page Navi',
				'type' 			=> 'select',
				'default_value'	=> 1,
				'name'			=> 'rst_author_pagenavi',
				'items'			=> array(
					'0' => 'No',
					'number' => 'Number',
					'load_more' => 'Load More',
					'load_auto' => 'Auto Load',
					'next_prev' => 'Next/Prev',
				),
				'default_value'	=> 'number',
			),
			array(
				'label' => 'Order By',
				'type' => 'select',
				'name' => 'rst_author_orderby',
				'items' => array(
			      	'post_date' => 'Date Time',
			      	'post_title' => 'Title',
			      	'popular' => 'Popular',
			      	'popular_week' => 'Popular On Week',
			      	'popular_month' => 'Popular On Month',
			      	'featured' => 'Featured',
			      	'high_rated' => 'Highest rated',
			      	'rand' => 'Random'
			   	),
				'default_value'	=> 'post_date',
			),
			array(
				'label' => 'Order',
				'type' => 'select',
				'name' => 'rst_author_order',
				'items' => array(
					'desc' => 'Descending',
			      	'asc' => 'Ascending'
			   	),
				'default_value'	=> 'desc',
			),
			array(
				'label' => 'Hidden Breadcrumb',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_breadcrumb'
			),
			array(
				'label' => 'Hidden Author Infomation',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_author_info'
			),
			array(
				'label' => 'Hidden Date',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_date'
			),
			array(
				'label' => 'Hidden Category',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_category'
			),
			array(
				'label' => 'Hidden Excerpt',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_excerpt'
			),
			array(
				'label' => 'Hidden Author',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_author'
			),
			array(
				'label' => 'Hidden Count Comment',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_comment'
			),
			array(
				'label' => 'Hidden View',
				'type' => 'checkbox',
				'name' => 'rst_author_is_hide_view'
			),
		)
	) );
	
	// Search
	rs::addCustomizeTab(array(
		'title' => 'Search', 
		'name' => 'rst_customize_search',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Layout Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_search_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'1' => get_template_directory_uri() .'/inc/css/images/fullwidth.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/sidebar_left.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/sidebar_right.jpg'
				)
			),
			array(
				'name' => 'rst_search_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $rst_widgets,
				'conditional_logic' => array(
					'items' => array(
						'rst_cat_layout' => '2|3'
					)
				)
			),
			array(
				'label' 		=> 'Template Setting',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_search_template',
				'default_value'	=> 'large',
				'items'        	=> array(
					'box' => get_template_directory_uri() .'/inc/icons/Box.jpg',
					'large' => get_template_directory_uri() .'/inc/icons/large.jpg',
					'grid' => get_template_directory_uri() .'/inc/icons/Grid.jpg',
					'medium' => get_template_directory_uri() .'/inc/icons/medium.jpg'
				)
			),
			array(
				'label' 		=> 'Number Columns',
				'type' 			=> 'select',
				'default_value'	=> 2,
				'name'			=> 'rst_search_column',
				'items'			=> array(
					'2' => '2 Columns',
					'3' => '3 Columns',
					'4' => '4 Columns'
				),
				'description'	=> 'Number columns for template grid &amp; box',
				'conditional_logic' => array(
					'items' => array(
						'rst_search_template' => 'grid|box'
					)
				)
			),
			array(
				'label' 		=> 'Posts Per Page',
				'type' 			=> 'text',
				'default_value'	=> 10,
				'name'			=> 'rst_search_numberpost'
			),
			array(
				'label' => 'Thumbnail Type',
				'type' => 'radio',
				'name' => 'rst_search_is_show_thumbnail',
				'items' => array(
					'image' => 'Thumbnail',
					'more'		=> 'Video/Gallery/Audio'
				),
				'default_value' => 'image',
			),
			array(
				'label' 		=> 'Excerpt Length',
				'type' 			=> 'text',
				'default_value'	=> 50,
				'name'			=> 'rst_search_excerpt_length'
			),
			array(
				'label' 		=> 'Page Navi',
				'type' 			=> 'select',
				'default_value'	=> 1,
				'name'			=> 'rst_search_pagenavi',
				'items'			=> array(
					'0' => 'No',
					'number' => 'Number',
					'load_more' => 'Load More',
					'load_auto' => 'Auto Load',
					'next_prev' => 'Next/Prev',
				)
			),
			array(
				'label' => 'Order By',
				'type' => 'select',
				'name' => 'rst_search_orderby',
				'items' => array(
			      	'post_date' => 'Date Time',
			      	'post_title' => 'Title',
			      	'popular' => 'Popular',
			      	'popular_week' => 'Popular On Week',
			      	'popular_month' => 'Popular On Month',
			      	'featured' => 'Featured',
			      	'high_rated' => 'Highest rated',
			      	'rand' => 'Random'
			   	)
			),
			array(
				'label' => 'Order',
				'type' => 'select',
				'name' => 'rst_search_order',
				'items' => array(
					'desc' => 'Descending',
			      	'asc' => 'Ascending'
			   	)
			),
			array(
				'label' => 'Hidden Breadcrumb',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_breadcrumb'
			),
			array(
				'label' => 'Hidden Date',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_date'
			),
			array(
				'label' => 'Hidden Category',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_category'
			),
			array(
				'label' => 'Hidden Excerpt',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_excerpt'
			),
			array(
				'label' => 'Hidden Author',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_author'
			),
			array(
				'label' => 'Hidden Count Comment',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_comment'
			),
			array(
				'label' => 'Hidden View',
				'type' => 'checkbox',
				'name' => 'rst_search_is_hide_view'
			),
		)
	) );
	
	// Page
	rs::addCustomizeTab(array(
		'title' => 'Page', 
		'name' => 'rst_customize_page',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Page Layout Default',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_page_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'1' => get_template_directory_uri() .'/inc/css/images/fullwidth.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/sidebar_left.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/sidebar_right.jpg'
				)
			),
			array(
				'name' => 'rst_page_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'conditional_logic' => array(
					'items' => array(
						'rst_page_layout' => '2|3'
					)
				),
				'items' => $rst_widgets
			),
			array(
				'label' 		=> 'Hide Thumbnail',
				'type' 			=> 'checkbox',
				'name' 			=> 'page_hide_thumbnail'
			),
			array(
				'label' 		=> 'Hide Share',
				'type' 			=> 'checkbox',
				'name' 			=> 'page_hide_share'
			),
			array(
				'label' 		=> 'Hide Author Box',
				'type' 			=> 'checkbox',
				'default_value'	=> true,
				'name' 			=> 'page_hide_author'
			),
			array(
				'label' 		=> 'Hide Comment Box',
				'type' 			=> 'checkbox',
				'name' 			=> 'page_hide_comment'
			),
		)
	));
	
	// Post
	rs::addCustomizeTab(array(
		'title' => 'Post', 
		'name' => 'rst_customize_post',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Post Layout Default',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_single_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'1' => get_template_directory_uri() .'/inc/css/images/fullwidth.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/sidebar_left.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/sidebar_right.jpg'
				)
			),
			array(
				'name' => 'rst_single_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'conditional_logic' => array(
					'items' => array(
						'rst_single_layout' => '2|3'
					)
				),
				'items' => $rst_widgets
			),
			array(
				'label' 		=> 'Image Thumbnail Full Width',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_thumbnail_full',
				'conditional_logic' => array(
					'items' => array(
						'rst_single_layout' => '2|3'
					)
				)
			),
			array(
				'label' 		=> 'Hide Breadcrumb',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_breadcrumb'
			),
			array(
				'label' 		=> 'Hide Category',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_category'
			),
			array(
				'label' 		=> 'Hide Date',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_date'
			),
			array(
				'label' 		=> 'Hide Author',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_author'
			),
			array(
				'label' 		=> 'Hide Comment',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_comment'
			),
			array(
				'label' 		=> 'Hide View',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_view'
			),
			array(
				'label' 		=> 'Hide Share Box',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_share'
			),
			array(
				'label' 		=> 'Hide Author Meta',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_author_meta'
			),
			array(
				'label' 		=> 'Hide Post Paging',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_paging'
			),
			array(
				'label' 		=> 'Hide Related Posts',
				'type' 			=> 'checkbox',
				'name' 			=> 'singe_hide_related'
			),
		)
	));
	
	// Share Link Post
	rs::addCustomizeTab(array(
		'title' => 'Share Post Link', 
		'name' => 'rst_customize_share_post',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Hide Share Facebook',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_facebook'
			),
			array(
				'label' 		=> 'Hide Share Google plus',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_google'
			),
			array(
				'label' 		=> 'Hide Share Twitter',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_twitter'
			),
			array(
				'label' 		=> 'Hide Share Tumblr',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_tumblr'
			),
			array(
				'label' 		=> 'Hide Share Linkedin',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_linkedin'
			),
			array(
				'label' 		=> 'Hide Share Pinterest',
				'type' 			=> 'checkbox',
				'name' 			=> 'share_pinterest'
			)
		)
	));
	
	// 404
	rs::addCustomizeTab(array(
		'title' => '404', 
		'name' => 'rst_customize_404',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Title',
				'type' 			=> 'text',
				'name'			=> 'title_404',
				'default_value'	=> '404'
			),
			array(
				'label' 		=> 'Sub Title',
				'type' 			=> 'text',
				'name'			=> 'subtitle_404',
				'default_value'	=> 'Page not found'
			),
			array(
				'label' 		=> 'Content',
				'type' 			=> 'textarea',
				'name'			=> 'content_404',
				'default_value'	=> ''
			)
		)
	) );
	
	
	// Seo
	rs::addCustomizeTab(array(
		'title' => 'Seo', 
		'name' => 'rst_customize_seo',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Meta Description',
				'type' 			=> 'textarea',
				'description'	=> 'Enter your website meta description for SEO.',
				'name' 			=> 'des_seo'
			),
			array(
				'label' 		=> 'Meta Keywords',
				'type' 			=> 'textarea',
				'description'	=> 'Enter your keywords here separated by a comma.',
				'name' 			=> 'keywords_seo'
			),
			array(
				'label' 		=> 'Meta Author',
				'type' 			=> 'textarea',
				'description'	=> '',
				'name' 			=> 'author_seo'
			),
		)
	) );
	
	// Social Network
	rs::addCustomizeTab(array(
		'title' => 'Social Network', 
		'name' => 'rst_customize_social',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Facebook',
				'type' 			=> 'text',
				'name' 			=> 'social_facebook'
			),
			array(
				'label' 		=> 'Google plus',
				'type' 			=> 'text',
				'name' 			=> 'social_google'
			),
			array(
				'label' 		=> 'Twitter',
				'type' 			=> 'text',
				'name' 			=> 'social_twitter'
			),
			array(
				'label' 		=> 'Tumblr',
				'type' 			=> 'text',
				'name' 			=> 'social_tumblr'
			),
			array(
				'label' 		=> 'Instagram',
				'type' 			=> 'text',
				'name' 			=> 'social_instagram'
			),
			array(
				'label' 		=> 'Youtube',
				'type' 			=> 'text',
				'name' 			=> 'social_youtube'
			),
			array(
				'label' 		=> 'Linkedin',
				'type' 			=> 'text',
				'name' 			=> 'social_linkedin'
			),
			array(
				'label' 		=> 'Flickr',
				'type' 			=> 'text',
				'name' 			=> 'social_flickr'
			),
			array(
				'label' 		=> 'Vimeo',
				'type' 			=> 'text',
				'name' 			=> 'social_vimeo'
			),
			array(
				'label' 		=> 'Pinterest',
				'type' 			=> 'text',
				'name' 			=> 'social_pinterest'
			),
			array(
				'label' 		=> 'Dribbble',
				'type' 			=> 'text',
				'name' 			=> 'social_dribbble'
			),
			array(
				'label' 		=> 'Digg',
				'type' 			=> 'text',
				'name' 			=> 'social_digg'
			),
			array(
				'label' 		=> 'Skype',
				'type' 			=> 'text',
				'name' 			=> 'social_skype'
			),
			array(
				'label' 		=> 'Deviantart',
				'type' 			=> 'text',
				'name' 			=> 'social_deviantart'
			),
			array(
				'label' 		=> 'Yahoo',
				'type' 			=> 'text',
				'name' 			=> 'social_yahoo'
			),
			array(
				'label' 		=> 'Reddit',
				'type' 			=> 'text',
				'name' 			=> 'social_reddit'
			),
			array(
				'label' 		=> 'Soundcloud',
				'type' 			=> 'text',
				'name' 			=> 'social_soundcloud'
			),
			array(
				'label' 		=> 'Delicious',
				'type' 			=> 'text',
				'name' 			=> 'social_delicious'
			),
			array(
				'label' 		=> 'VK',
				'type' 			=> 'text',
				'name' 			=> 'social_vk'
			),
			array(
				'label' 		=> 'Vine',
				'type' 			=> 'text',
				'name' 			=> 'social_vine'
			)
		)
	) );
	
	// Footer
	rs::addCustomizeTab(array(
		'title' => 'Footer', 
		'name' => 'rst_customize_footer',
		'priority' => 30,
		'controls' => array(
			array(
				'label' 		=> 'Footer Layout',
				'type' 			=> 'radio-image',
				'name' 			=> 'rst_footer_layout',
				'default_value'	=> 1,
				'items'        	=> array(
					'default' => get_template_directory_uri() .'/inc/css/images/default.jpg',
					'1' => get_template_directory_uri() .'/inc/css/images/layout_1.jpg',
					'2' => get_template_directory_uri() .'/inc/css/images/layout_2.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/layout_3.jpg',
					'3' => get_template_directory_uri() .'/inc/css/images/layout_4.jpg'
				)
			),
			array(
				'label' 		=> 'Copyright',
				'type' 			=> 'textarea',
				'default_value'	=> 'Copyright 2015 LazaTheme. All Rights Reserved.',
				'name'			=> 'footer_copyright'
			),
			array(
				'label' 		=> 'Hidden Footer Top on Table/Mobie',
				'type' 			=> 'checkbox',
				'name'			=> 'hidden_footer'
			),
			array(
				'label' 		=> 'Footer Background',
				'type' 			=> 'rsbackground',
				'name' 			=> 'bg_footer',
				'css_selector'	=> '#footer',
				'default_value'	=> array(
					'background-color' => '#333333'
				)
			)
		)
	) );
	
	// Translations
	rs::addCustomizeTab(array(
		'title' => 'Translations / ReName Text', 
		'name' => 'rst_customize_translations',
		'priority' => 30,
		'controls' => array(
			array(
				'label' => 'Search',
				'type' => 'text',
				'name' => 'search'
			),
			array(
				'label' => 'Followers',
				'type' => 'text',
				'name' => 'followers'
			),
			array(
				'label' => 'Likes',
				'type' => 'text',
				'name' => 'likes'
			),
			array(
				'label' => 'Subscriber',
				'type' => 'text',
				'name' => 'subscriber'
			),
			array(
				'label' => 'Comment',
				'type' => 'text',
				'name' => 'comment'
			),
			array(
				'label' => 'Leave a Comment',
				'type' => 'text',
				'name' => 'leave_a_comment'
			),
			array(
				'label' => 'Post a Comment',
				'type' => 'text',
				'name' => 'sent_comment'
			),
			array(
				'label' => 'Message',
				'type' => 'text',
				'name' => 'your_message'
			),
			array(
				'label' => 'Name',
				'type' => 'text',
				'name' => 'name'
			),
			array(
				'label' => 'Email',
				'type' => 'text',
				'name' => 'email'
			),
			array(
				'label' => 'Website',
				'type' => 'text',
				'name' => 'website'
			),
			array(
				'label' => 'You Might Also Like',
				'type' => 'text',
				'name' => 'related_posts'
			),
			array(
				'label' => 'Share this',
				'type' => 'text',
				'name' => 'share_this'
			),
			array(
				'label' => 'Was This Post Helpful',
				'type' => 'text',
				'name' => 'was_this_post_helpful'
			),
			array(
				'label' => 'Breaking',
				'type' => 'text',
				'name' => 'breaking'
			),
			array(
				'label' => 'Menu',
				'type' => 'text',
				'name' => 'menu'
			),
			array(
				'label' => 'Error 404',
				'type' => 'text',
				'name' => 'error_404'
			),
			array(
				'label' => 'Page Not Found',
				'type' => 'text',
				'name' => 'page_not_found'
			),
			array(
				'label' => 'Please go back to home or try again.',
				'type' => 'text',
				'name' => 'please_back_home'
			),
			array(
				'label' => 'Go home',
				'type' => 'text',
				'name' => 'go_home'
			),
			array(
				'label' => 'Posts by',
				'type' => 'text',
				'name' => 'posts_by'
			),
			array(
				'label' => 'Daily Archives',
				'type' => 'text',
				'name' => 'daily_archives'
			),
			array(
				'label' => 'Monthly Archives',
				'type' => 'text',
				'name' => 'monthly_archives'
			),
			array(
				'label' => 'Yearly Archives',
				'type' => 'text',
				'name' => 'yearly_archives'
			),
			array(
				'label' => 'search results',
				'type' => 'text',
				'name' => 'search_results'
			),
			array(
				'label' => 'If you\'re not happy with the results, please do another search',
				'type' => 'text',
				'name' => 'search_not_happy'
			),
			array(
				'label' => 'It seems we can\'t find what you\'re looking for. Perhaps searching can help.',
				'type' => 'text',
				'name' => 'query_not_found'
			),
			array(
				'label' => 'Previous Post',
				'type' => 'text',
				'name' => 'previous_post'
			),
			array(
				'label' => 'Next Post',
				'type' => 'text',
				'name' => 'next_post'
			),
			array(
				'label' => 'Browsing Category',
				'type' => 'text',
				'name' => 'browsing_category'
			),
		)
	) );
	
	// Custom CSS
	rs::addCustomizeTab(array(
		'title' => 'Custom CSS', 
		'name' => 'rst_customize_css',
		'priority' => 30,
		'controls' => array(
			array(
				'label' => 'Enter your custom CSS styling here.',
				'type' => 'textarea',
				'name' => 'rst_custom_css',
				'css'	=> '$value'
			)
		)
	));
?>