<?php

//function to get array to comparse to get title column
function rst_get_all_wordpress_menu_for_comparse(){
	//$exclude = absint( get_user_option( 'nav_menu_recently_edited' ) );
    //$array_nav_menu = get_terms( 'nav_menu', array( 'hide_empty' => false ,'exclude' => $exclude ) );
    $array_nav_menu = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
	//return $array_nav_menu;
	$array_nav_menu_out = array();
	if($array_nav_menu) foreach($array_nav_menu as $items){
		$array_nav_menu_out[$items->term_taxonomy_id] = $items->name;
	}
	return $array_nav_menu_out;
}
global $array_to_comparse;
$array_to_comparse = rst_get_all_wordpress_menu_for_comparse();

class rst_global_blocks {
    private static $global_instances = array();
    static function add_instance($block_name, $block_instance) {
        self::$global_instances[$block_instance->block_id] = array (
            'id' => $block_instance->block_id,
            'name' => $block_name,
            'instance' => $block_instance
        );
    }
    static function get_instance($block_id) {
        return self::$global_instances[$block_id]['instance'];
    }
    /**
     * map all the blocks in the pagebuilder
     */
    static function wpb_map_all() {
        foreach (self::$global_instances as $block_array) {
            //map in visual composer only classes that have get_map!
            //the mega menu block doesn't have map
            if (method_exists($block_array['instance'], 'get_map')) {
                wpb_map($block_array['instance']->get_map());
            }
        }
    }
    static function debug_get_all_instances() {
        return self::$global_instances;
    }
}
// the menu
class rst_menu {
    var $is_header_menu_mobile = true;
    function __construct() {
        if (is_admin()) {
            add_action('wp_update_nav_menu_item', array( $this, 'hook_wp_update_nav_menu_item'), 10, 3);
            add_filter('wp_edit_nav_menu_walker', array($this, 'hook_wp_edit_nav_menu_walker'));
        }
        add_filter('wp_nav_menu_objects', array($this, 'hook_wp_nav_menu_objects'),  10, 2);
    }
    function hook_wp_edit_nav_menu_walker () {
		require get_template_directory() . '/inc/menu-mega/rst_menu_back.php';
        return 'rst_nav_menu_edit_walker';
    }
    function hook_wp_update_nav_menu_item ($menu_id, $menu_item_db_id, $args) {
        if (isset($_POST['rst_mega_menu_cat'][$menu_item_db_id])) {
            update_post_meta($menu_item_db_id, 'rst_mega_menu_cat', $_POST['rst_mega_menu_cat'][$menu_item_db_id]);
        }
		if (isset($_POST['rst_menu_location_array'][$menu_item_db_id])) {
			update_post_meta($menu_item_db_id, 'rst_menu_location_array', $_POST['rst_menu_location_array'][$menu_item_db_id]);
		}
    }
    function hook_wp_nav_menu_objects($items, $args = '') {
        $items_buffy = array();
        $rst_is_firstMenu = true;
        foreach ($items as &$item) {
            $item->is_mega_menu = false;
            // first menu fix
            if ($rst_is_firstMenu) {
                $item->classes[] = 'menu-item-first';
                $rst_is_firstMenu = false;
            }
            // fix the down arros + shortcodes
            if (strpos($item->title,'[') === false) {
            } else {
                //on shortcodes [home] etc.. do not show down arrow
                $item->classes[] = 'rs-no-down-arrow';
            }
            //run shortcodes
            $item->title = do_shortcode($item->title);
            //is mega menu?
            $rst_mega_menu_cat = get_post_meta($item->ID, 'rst_mega_menu_cat', true);
			if(isset($rst_mega_menu_cat) && $rst_mega_menu_cat != ''){
				$item->classes[] = 'menu-item-has-children';
				require get_template_directory() . "/inc/menu-mega/rst_menu_$rst_mega_menu_cat.php";
			}
			else{
				$item->classes[] = 'rst-not-mega';
				$items_buffy[] = $item;
			}
        } //end foreach
        // we have two header-menu locations and the fist one is the mobile menu
        // the second one is the header menu
        if ($args->theme_location == 'header-menu') {
            $this->is_header_menu_mobile = false;
        }
        //print_r($items_buffy);
        //die;
        return $items_buffy;
    }
}
new rst_menu();
/**
 * Proper way to enqueue scripts and styles
 */
function menu_mega_scripts() {
	wp_enqueue_script( 'script-menu-mega', get_template_directory_uri() . '/inc/menu-mega/js/custom.js', array(), '1.0.0', true );
	wp_enqueue_style( 'style-admin-menu-mega', get_template_directory_uri() . '/inc/menu-mega/css/custom.css');
}
add_action( 'admin_enqueue_scripts', 'menu_mega_scripts' );

function menu_mega_front_scripts() {
	wp_enqueue_script( 'script-menu-mega', get_template_directory_uri() . '/inc/menu-mega/js/custom-front.js', array(), '1.0.0', true );
	wp_enqueue_style( 'style-menu-mega-animate', get_template_directory_uri() . '/inc/menu-mega/css/animate.css');
}
add_action( 'wp_enqueue_scripts', 'menu_mega_front_scripts' );