<?php

function rst_rating_scripts() {
	wp_enqueue_script( 'jquery-rating', esc_url( get_template_directory_uri()) . '/inc/rating/js/rating.js', 'jquery', '', true );
	wp_enqueue_style( 'css-rating', esc_url( get_template_directory_uri() ) .'/inc/rating/rating.css' );
}
add_action( 'wp_enqueue_scripts', 'rst_rating_scripts' );

add_action('wp_ajax_rst_ajax_rating', 'rst_ajax_rating_action');
add_action('wp_ajax_nopriv_rst_ajax_rating', 'rst_ajax_rating_action');

function rst_ajax_rating_action() { 
	if( empty($_POST['postID']) && empty($_POST['point']) ) return false;
	$postID = absint($_POST['postID']);
	$point = absint($_POST['point']);
	rst_set_post_rating($postID);
	rst_set_post_rating_point($postID,$point);
	echo rst_render_rating($postID,true);
	exit;
}

function rst_render_rating($postID=0,$ajax=false) {
	$html = '';
	if( $postID == 0 ) $postID = get_the_ID();
	$count = get_post_meta($postID, 'ub_post_rating_count', true);
	$count_point = get_post_meta($postID, 'ub_post_rating_point_count', true);
	if( $ajax == false ) {
		$html .= '<script type="text/javascript">
			var rating_'.$postID.' = new rst_blocks();
			rating_'.$postID.'.url = \''. admin_url( "admin-ajax.php" ) .'\';
		</script>';
	}
	$html .= '<div class="ub-rate-post" postID="'.$postID.'">';
	$html .= '<strong>'. rst_get_translate('Was This Post Helpful','was_this_post_helpful') .':</strong>';
	ob_start();
	$check = 5;
	if( isset($_COOKIE['ub_cookie_rating_'.$postID]) && $_COOKIE['ub_cookie_rating_'.$postID] == 1 ) $check = 0;
	rs::rating(array(
		'name' => 'rating_post',
		'type' => 'rating',
		'default_value' => rst_get_post_rating($postID),
		'max_rates' => $check,
		'options' => array(
			'starWidth' => 16,
			'starHeight' => 16,
			'type' => 2
		)
	));
	$html .= ob_get_contents();
	ob_end_clean();
	$html .= '<p class="ub-rate-meta">
		<strong class="votes">'. absint($count) .'</strong>
		votes,
		<strong>'. rst_get_post_rating($postID) .'</strong>
		avg. rating
	</p>';
	$html .= '</div>';
	return $html;
}

function rst_set_post_rating($postID) {
	if( !isset($postID) ) $postID = get_the_ID();
	$count_key = 'ub_post_rating_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count==''){
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, '0');
	}else{
		$count++;
		update_post_meta($postID, $count_key, $count);
	}
}
function rst_set_post_rating_point($postID,$point) {
	$count_key = 'ub_post_rating_point_count';
	$count_key_round = 'ub_post_rating_point_round';
	$count = get_post_meta($postID, $count_key, true);
	$count_point = get_post_meta($postID, 'ub_post_rating_count', true);
	if($count==''){
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, $point);
	}else{
		$count += $point;
		update_post_meta($postID, $count_key, $count);
	}
	update_post_meta($postID, $count_key_round, round($count/$count_point,2));
}


function rst_get_post_rating($postID){
	$count_key = 'ub_post_rating_count';
	$count_point_key = 'ub_post_rating_point_count';
	$count = get_post_meta($postID, $count_key, true);
	$count_point = get_post_meta($postID, $count_point_key, true);
	if($count=='' || $count <= 0 ){
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, '0');
		return 0;
	}
	if( $count != 0 )
		return round($count_point/$count,2);
	return 0;
}