<?php
	$ub_widgets = rst_get_my_widgets();

	// Font size list
	$list_size = array();
	$list_size[] = array('value'=> '0','text'=> 'Default');
	for($size=9;$size<=150;$size++) {
		$list_size[] = array('value'=>$size,'text'=>$size);
	}
	// General Option
	rs::addOptionTab(array(
		'title' => 'General',
		'name' => 'general-option',
		'icon' => 'flaticon-settings20',
		'controls' => array(
			array(
				'type' => 'script',
				'name' => 'document_support',
				'callback' => 'document_support'
			),
			array(
				'label' => 'Icon',
				'type' => 'group',
				'layout' => 'none',
				'show_controls' => true,
				'controls' => array(
					array(
						'label' => 'Favicon',
						'type' => 'image',
						'name' => 'favicon',
						'description' => '16x16 px.'
					),
					array(
						'label' => 'Apple iPad Retina Icon',
						'type' => 'media',
						'name' => 'favicon_ipad_retina',
						'mediaType' => 'image',
						'description' => '144x144 px.'
					),
					array(
						'label' => 'Apple iPad Icon',
						'type' => 'media',
						'name' => 'favicon_ipad',
						'mediaType' => 'image',
						'description' => '75x75 px.'
					),
					array(
						'label' => 'Apple iPhone Icon',
						'type' => 'media',
						'name' => 'favicon_iphone',
						'mediaType' => 'image',
						'description' => '57x57 px.'
					)
				)
			),
			array(
				'label' => 'Theme Style',
				'type' => 'group',
				'layout' => 'none',
				'controls' => array(
					array(
						'label' => 'Theme Color',
						'type' => 'color',
						'name' => 'color_theme',
						'default_value' => '#ffba00',
						'description' => 'Select theme accent color'
					),
					array(
						'label' => 'Body Background Image',
						'type' => 'image',
						'name' => 'bg_body_image'
					),
					
					array(
						'label' => 'Body Background Color',
						'type' => 'color',
						'name' => 'bg_body_color',
						'default_value' => '#f1f1f1',
						'description' => 'Select theme background color'
					),
					
					array(
						'label' => 'Body Background Repeat',
						'type' => 'select',
						'name' => 'bg_body_repeat',
						'items' => array(
							'no-repeat' => 'No Repeat',
							'repeat' => 'Repeat',
							'repeat-x' => 'Repeat x',
							'repeat-y' => 'Repeat y'
						)
					),
					array(
						'label' => 'Body Background Position',
						'type' => 'select',
						'name' => 'bg_body_position',
						'items' => array(
							'left top' => 'Left Top',
							'left bottom' => 'Left Bottom',
							'left center' => 'Left Center',
							'center top' => 'Center Top',
							'center bottom' => 'Center Bottom',
							'center center' => 'Center Center',
							'right top' => 'Right Top',
							'right bottom' => 'Right Bottom',
							'right center' => 'Right Center'
						)
					),
					array(
						'label' => 'Body Background Attachment',
						'type' => 'select',
						'name' => 'bg_body_attachment',
						'items' => array(
							'' => 'None',
							'fixed' => 'Fixed',
							'scroll' => 'Scroll'
						)
					),
					
					array(
						'label' => 'Link Color',
						'type' => 'color',
						'name' => 'color_link',
						'default_value' => '#428bca',
						'description' => 'Select theme link color'
					),
					
					array(
						'label' => 'Link Hover Color',
						'type' => 'color',
						'name' => 'color_link_hover',
						'default_value' => '#ffba00',
						'description' => 'Select theme link hover color'
					)
				)
			),
			array(
				'type' => 'script',
				'name' => 'import_demo',
				'callback' => 'import_demo'
			)
		)
	));
	
	// Header option
	rs::addOptionTab(array(
		'title' => 'Header',
		'name' => 'header_option',
		'icon' => 'flaticon-ruler9',
		'controls' => array(
			array(
				'label' => 'Layout',
				'type' => 'group',
				'layout' => 'none',
				'show_controls' => true,
				'controls' => array(
					array(
						'label' => 'Header Layout',
						'type' => 'radio',
						'name' => 'header_layout',
						'items' => array(
							'layout-1' => 'Header 1',
							'layout-2' => 'Header 2',
							'layout-3' => 'Header 3',
							'layout-4' => 'Header 4'
						),
						'default_value' => 'layout-1'
					),
					
					array(
						'label' => 'Right Header Sections',
						'name' => 'header_ads',
						'type' => 'select',
						// 'conditional_logic' => array('header_layout' => 'layout-1|layout-2'),
						'items' => $ub_widgets
					)
				)
			),
			
			array(
				'label' => 'Logo',
				'type' => 'group',
				'layout' => 'none',
				'controls' => array(
					array(
						'label' => 'Logo',
						'type' => 'image',
						'name' => 'header_logo'
					),
					array(
						'label' => 'Logo Padding Top',
						'type' => 'text',
						'name' => 'header_logo_padding',
						'description' => 'Input integer value for logo padding top (px).'
					),
					array(
						'label' => 'Mini Logo',
						'type' => 'image',
						'name' => 'header_logo_mini'
					)
				)
			),
			
			array(
				'label' => 'Style',
				'type' => 'group',
				'layout' => 'none',
				'controls' => array(
			
					array(
						'label' => 'Header Height',
						'type' => 'text',
						'name' => 'header_height',
						'description' => 'Input integer value for Header height (px).'
					),
					
					array(
						'label' => 'Header Padding',
						'type' => 'group',
						'show_controls' => true,
						'description' => 'Input integer value for Header padding (px).',
						'controls' => array(
							array(
								'label' => 'Padding Top',
								'type' => 'text',
								'name' => 'header_padding_top'
							),
							array(
								'label' => 'Padding Right',
								'type' => 'text',
								'name' => 'header_padding_right'
							),
							array(
								'label' => 'Padding Bottom',
								'type' => 'text',
								'name' => 'header_padding_bottom'
							),
							array(
								'label' => 'Padding Left',
								'type' => 'text',
								'name' => 'header_padding_left'
							)
						)
					),
					
					array(
						'label' => 'Background Image',
						'type' => 'image',
						'name' => 'bg_header_image'
					),
					array(
						'label' => 'Background Repeat',
						'type' => 'select',
						'name' => 'bg_header_repeat',
						'items' => array(
							'no-repeat' => 'No Repeat',
							'repeat' => 'Repeat',
							'repeat-x' => 'Repeat x',
							'repeat-y' => 'Repeat y'
						)
					),
					array(
						'label' => 'Background Position',
						'type' => 'select',
						'name' => 'bg_header_position',
						'items' => array(
							'left top' => 'Left Top',
							'left bottom' => 'Left Bottom',
							'left center' => 'Left Center',
							'center top' => 'Center Top',
							'center bottom' => 'Center Bottom',
							'center center' => 'Center Center',
							'right top' => 'Right Top',
							'right bottom' => 'Right Bottom',
							'right center' => 'Right Center'
						)
					),
					array(
						'label' => 'Background Attachment',
						'type' => 'select',
						'name' => 'bg_header_attachment',
						'items' => array(
							'' => 'None',
							'fixed' => 'Fixed',
							'scroll' => 'Scroll'
						)
					),
					
					array(
						'label' => 'Header Background Color',
						'type' => 'color',
						'name' => 'color_header',
						'default_value' => '#ffffff',
						'description' => 'Select theme header background color'
					),
				)
			),
			
			array(
				'label' => 'Breaking',
				'type' => 'group',
				'layout' => 'none',
				'controls' => array(
					array(
						'label' => 'Show Breaking Section',
						'type' => 'switch',
						'name' => 'breaking_show',
						'default_value' => '1'
					),
					array(
						'label' => 'Breaking – Choose Categories',
						'type' => 'termlist',
						'name' => 'breaking_terms'
					),
					array(
						'label' => 'Breaking – Filter By Tag Slug',
						'type' => 'text',
						'name' => 'breaking_tags',
						'description' => 'Example: tag1,tag2,tag3...'
					),
					array(
						'label' => 'Breaking – Order By',
						'type' => 'select',
						'name' => 'breaking_sort',
						'items' => array(
							'date' => 'Date Time',
							'title' => 'Title',
							'popular' => 'Popular',
							'popular_week' => 'Popular On Week',
							'popular_month' => 'Popular On Month',
							'titlfeaturede' => 'Featured',
							'reviews' => 'Highest rated',
							'random' => 'Random',
						),
						'default_value' => 'date'
					),
					array(
						'label' => 'Breaking – Sort By',
						'type' => 'select',
						'name' => 'breaking_order',
						'items' => array(
							'DESC' => 'DESC',
							'ASC' => 'ASC'
						),
						'default_value' => 'DESC'
					),
					array(
						'label' => 'Breaking – Number Posts Show',
						'type' => 'text',
						'name' => 'breaking_numberpost',
						'description' => 'Input integer value for Number Posts.',
						'default_value' => '10'
					),
					array(
						'label' => 'Breaking – Right Section',
						'type' => 'select',
						'name' => 'breaking_right_type',
						'description' => '',
						'items' => array(
							'0' => 'None',
							'social' => 'Social Icon',
							'text'	=> 'Text',
							'menu' 	=> 'Menu'
						),
						'default_value' => '0'
					),
					array(
						'label' => 'Breaking Section Text Right',
						'type' => 'textarea',
						'name' => 'breaking_right_text',
						'conditional_logic' => array('breaking_right_type' => 'text')
					),
					array(
						'label' => 'Breaking Section Menu Right',
						'type' => 'select',
						'name' => 'breaking_right_menu',
						'items' => rst_get_menu(),
						'conditional_logic' => array('breaking_right_type' => 'menu')
					)
				)
			)
		)
	));
	
	
	// Footer option
	rs::addOptionTab(array(
		'title' => 'Footer',
		'name' => 'footer_option',
		'icon' => 'flaticon-bullet4',
		'controls' => array(
			array(
				'label' => 'Layout',
				'type' => 'group',
				'layout' => 'none',
				'show_controls' => true,
				'controls' => array(
					array(
						'label' => 'Footer Layout',
						'type' => 'radio',
						'name' => 'footer_layout',
						'description'	=> 'Set footer layout.',
						'items' => array( 
							'default' => 'Deafault <br/> 1/3 1/4 1/6 1/4', 
							'1' => '4 Columns <br/> 1/4 1/4 1/4 1/4 ', 
							'2' => '3 Columns <br/> 1/3 1/3 1/3',
							'3' => '3 Columns <br/> 1/2 1/4 1/4',
							'4' => '2 Columns <br/> 1/2 1/2',
						),
						'default_value' => 'default'
					),
					array(
						'label' => 'Footer Copyright',
						'type' => 'textarea',
						'name' => 'text_footer',
						'description'	=> 'Enter your copyright text here.'
					)
				)
			),
			array(
				'label' => 'Style',
				'type' => 'group',
				'layout' => 'none',
				'controls' => array(
					array(
						'label' => 'Hidden Footer Top on Table/Mobie',
						'type' => 'switch',
						'name' => 'hidden_footer'
					),
					array(
						'label' => 'Background Image',
						'type' => 'image',
						'name' => 'bg_footer_image'
					),
					array(
						'label' => 'Background Repeat',
						'type' => 'select',
						'name' => 'bg_footer_repeat',
						'items' => array(
							'no-repeat' => 'No Repeat',
							'repeat' => 'Repeat',
							'repeat-x' => 'Repeat x',
							'repeat-y' => 'Repeat y'
						)
					),
					array(
						'label' => 'Background Position',
						'type' => 'select',
						'name' => 'bg_footer_position',
						'items' => array(
							'left top' => 'Left Top',
							'left bottom' => 'Left Bottom',
							'left center' => 'Left Center',
							'center top' => 'Center Top',
							'center bottom' => 'Center Bottom',
							'center center' => 'Center Center',
							'right top' => 'Right Top',
							'right bottom' => 'Right Bottom',
							'right center' => 'Right Center'
						)
					),
					array(
						'label' => 'Background Attachment',
						'type' => 'select',
						'name' => 'bg_footer_attachment',
						'items' => array(
							'' => 'None',
							'fixed' => 'Fixed',
							'scroll' => 'Scroll'
						)
					),
					
					array(
						'label' => 'Footer Background Color',
						'type' => 'color',
						'name' => 'bg_footer_color',
						'default_value' => '#333333'
					),
					
					array(
						'label' => 'Footer Title Text Color',
						'type' => 'color',
						'name' => 'color_footer_text_title',
						'default_value' => '#fff'
					),
					
					array(
						'label' => 'Footer Text Color',
						'type' => 'color',
						'name' => 'color_footer_text',
						'default_value' => '#9b9999'
					)
				)
			)
		)
	));
	 
	// Search option
	rs::addOptionTab(array(
		'title' => 'Search',
		'name' => 'search_option',
		'icon' => 'flaticon-zoom22',
		'controls' => array(
			array(
				'label' => 'Column Style',
				'type' => 'radio',
				'name' => 'search_style',
				'description'	=> 'Choose your search column style to show on your search page.',
				'items' => array( 
					'1' => 'Full Width', 
					'2' => 'Sidebar Left', 
					'3' => 'Sidebar Right'
				),
				'default_value' => '3'
			),
			
			array(
				'name' => 'search_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $ub_widgets
			),
			
			array(
				'name' => 'search_template',
				'label'=> 'Choose Template',
				'type' => 'select',
				'items' => array( 
					'box' => 'Box', 
					'grid' => 'Grid',
					'large' => 'Large',
					'medium' => 'Medium',
				),
				'default_value' => 'box'
			),
			array(
				'label' => 'Number Columns',
				'type' => 'select',
				'name' => 'search_number_column',
				'description'	=> 'Set category number columns.',
				'items' => array( 
					'1' => '1 Columns', 
					'2' => '2 Columns',
					'3' => '3 Columns',
					'4' => '4 Columns',
				),
				'default_value' => '2',
				'conditional_logic' => array('search_template' => 'box|grid'),
			),
			array(
				'name' => 'search_posts_per_paged',
				'label'=> 'Number Posts',
				'type' => 'text',
				'description' => 'Input integer value for Number Posts.',
				'default_value' => '10'
			),
			array(
				'label' => 'Type Thumbnail',
				'type' => 'radio',
				'name' => 'search_is_show_thumbnail',
				'items' => array(
					'image' => 'Thumbnail',
					'more'		=> 'Video/Gallery/Audio'
				),
				'default_value' => 'thumbnail',
			),
			array(
				'label' => 'Show Breadcrumb',
				'type' => 'switch',
				'name' => 'search_is_show_breadcrumb',
				'default_value' => true,
				'description'	=> 'Turn on/off to show breadcrumb.'
			),
			
			array(
				'label' => 'Show Excerpt',
				'type' => 'switch',
				'name' => 'search_is_show_excerpt',
				'default_value' => true,
				'description'	=> 'Turn on/off to show excerpt.'
			),
			
			array(
				'label' => 'Excerpt Length',
				'type' => 'text',
				'name' => 'search_excerpt_length',
				'default_value' => 30
			),
			
			array(
				'label' => 'Show Navi',
				'type' => 'select',
				'name' => 'search_is_show_navi',
				'items' => array(
					'0' => 'No',
					'number' => 'Number',
					'load_more' => 'Load More',
					'load_auto' => 'Auto Load',
					'next_prev' => 'Next/Prev',
				),
				'default_value' => 'number'
			),
			
			array(
				'label' => 'Show Date',
				'type' => 'switch',
				'name' => 'search_is_show_date',
				'default_value' => true,
				'description'	=> 'Turn on/off to show date.'
			),
			
			array(
				'label' => 'Show Category',
				'type' => 'switch',
				'name' => 'search_is_show_category',
				'default_value' => false,
				'description'	=> 'Turn on/off to show categories.'
			),
			
			array(
				'label' => 'Show Author',
				'type' => 'switch',
				'name' => 'search_is_show_author',
				'default_value' => true,
				'description'	=> 'Turn on/off to show author.'
			),
			array(
				'label' => 'Show Count Comment',
				'type' => 'switch',
				'name' => 'search_is_show_comment',
				'default_value' => false,
				'description'	=> 'Turn on/off to show count comment.'
			),
			array(
				'label' => 'Show View',
				'type' => 'switch',
				'name' => 'search_is_show_view',
				'default_value' => false,
				'description'	=> 'Turn on/off to show view.'
			),
			array(
				'label' => 'Order By',
				'type' => 'select',
				'name' => 'search_orderby',
				'items' => array(
			      	'post_date' => 'Date Time',
			      	'post_title' => 'Title',
			      	'popular' => 'Popular',
			      	'popular_week' => 'Popular On Week',
			      	'popular_month' => 'Popular On Month',
			      	'featured' => 'Featured',
			      	'high_rated' => 'Highest rated',
			      	'rand' => 'Random'
			   	)
			),
			array(
				'label' => 'Order',
				'type' => 'select',
				'name' => 'search_order',
				'items' => array(
					'desc' => 'Descending',
			      	'asc' => 'Ascending'
			   	)
			)
		)
	));
	
	 // Category option
	rs::addOptionTab(array(
		'title' => 'Category',
		'name' => 'blog_option',
		'icon' => 'flaticon-bullet3',
		'controls' => array(
			array(
				'label' => 'Column Style',
				'type' => 'radio',
				'name' => 'blog_style',
				'description'	=> 'Choose your category column style to show on your category page, post category page and archives.',
				'items' => array( 
					'1' => 'Full Width', 
					'2' => 'Sidebar Left', 
					'3' => 'Sidebar Right'
				),
				'default_value' => '3'
			),
			
			array(
				'name' => 'blog_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $ub_widgets
			),
			
			array(
				'name' => 'blog_template',
				'label'=> 'Choose Template',
				'type' => 'select',
				'items' => array( 
					'box' => 'Box', 
					'grid' => 'Grid',
					'large' => 'Large',
					'medium' => 'Medium',
				),
				'default_value' => 'box'
			),
			array(
				'label' => 'Number Columns',
				'type' => 'select',
				'name' => 'blog_number_column',
				'description'	=> 'Set category number columns.',
				'items' => array( 
					'1' => '1 Columns', 
					'2' => '2 Columns',
					'3' => '3 Columns',
					'4' => '4 Columns',
				),
				'default_value' => '2',
				'conditional_logic' => array('blog_template' => 'box|grid'),
			),
			array(
				'name' => 'blog_posts_per_paged',
				'label'=> 'Number Posts',
				'type' => 'text',
				'description' => 'Input integer value for Number Posts.',
				'default_value' => '10'
			),
			array(
				'label' => 'Type Thumbnail',
				'type' => 'radio',
				'name' => 'blog_is_show_thumbnail',
				'items' => array(
					'image' => 'Thumbnail',
					'more'		=> 'Video/Gallery/Audio'
				),
				'default_value' => 'thumbnail',
			),
			array(
				'label' => 'Show Breadcrumb',
				'type' => 'switch',
				'name' => 'blog_is_show_breadcrumb',
				'default_value' => true,
				'description'	=> 'Turn on/off to show breadcrumb.'
			),
			
			array(
				'label' => 'Show Excerpt',
				'type' => 'switch',
				'name' => 'blog_is_show_excerpt',
				'default_value' => true,
				'description'	=> 'Turn on/off to show excerpt.'
			),
			
			array(
				'label' => 'Excerpt Length',
				'type' => 'text',
				'name' => 'blog_excerpt_length',
				'default_value' => 30
			),
			
			array(
				'label' => 'Show Navi',
				'type' => 'select',
				'name' => 'blog_is_show_navi',
				'items' => array(
					'0' => 'No',
					'number' => 'Number',
					'load_more' => 'Load More',
					'load_auto' => 'Auto Load',
					'next_prev' => 'Next/Prev',
				),
				'default_value' => 'number'
			),
			
			array(
				'label' => 'Show Date',
				'type' => 'switch',
				'name' => 'blog_is_show_date',
				'default_value' => true,
				'description'	=> 'Turn on/off to show date.'
			),
			
			array(
				'label' => 'Show Category',
				'type' => 'switch',
				'name' => 'blog_is_show_category',
				'default_value' => false,
				'description'	=> 'Turn on/off to show categories.'
			),
			
			array(
				'label' => 'Show Author',
				'type' => 'switch',
				'name' => 'blog_is_show_author',
				'default_value' => true,
				'description'	=> 'Turn on/off to show author.'
			),
			array(
				'label' => 'Show Count Comment',
				'type' => 'switch',
				'name' => 'blog_is_show_comment',
				'default_value' => false,
				'description'	=> 'Turn on/off to show count comment.'
			),
			array(
				'label' => 'Show View',
				'type' => 'switch',
				'name' => 'blog_is_show_view',
				'default_value' => false,
				'description'	=> 'Turn on/off to show view.'
			),
			array(
				'label' => 'Order By',
				'type' => 'select',
				'name' => 'blog_orderby',
				'items' => array(
			      	'post_date' => 'Date Time',
			      	'post_title' => 'Title',
			      	'popular' => 'Popular',
			      	'popular_week' => 'Popular On Week',
			      	'popular_month' => 'Popular On Month',
			      	'featured' => 'Featured',
			      	'high_rated' => 'Highest rated',
			      	'rand' => 'Random'
			   	)
			),
			array(
				'label' => 'Order',
				'type' => 'select',
				'name' => 'blog_order',
				'items' => array(
					'desc' => 'Descending',
			      	'asc' => 'Ascending'
			   	)
			)
		)
	));
	
	 
	// Single option
	rs::addOptionTab(array(
		'title' => 'Single',
		'name' => 'single_option',
		'icon' => 'flaticon-minus16',
		'controls' => array(
			array(
				'label' => 'Single Column Style',
				'type' => 'radio',
				'name' => 'single_style',
				'description'	=> 'Choose your single column style to show on your single.',
				'items' => array( 
					'1' => 'Full Width', 
					'2' => 'Sidebar Left', 
					'3' => 'Sidebar Right'
				),
				'default_value' => '3'
			),
			array(
				'name' => 'single_sidebar',
				'label'=> 'Select Sidebar',
				'type' => 'select',
				'items' => $ub_widgets
			),
			array(
				'label' => 'Show Breadcrumb',
				'type' => 'switch',
				'name' => 'single_is_show_breadcrumb',
				'default_value' => true,
				'description'	=> 'Turn on/off to show breadcrumb.'
			),
			array(
				'label' => 'Show Category',
				'type' => 'switch',
				'name' => 'single_is_show_category',
				'default_value' => true,
				'description'	=> 'Turn on/off to show categories.'
			),
			array(
				'label' => 'Show Date',
				'type' => 'switch',
				'name' => 'single_is_show_date',
				'default_value' => true,
				'description'	=> 'Turn on/off to show date.'
			),
			array(
				'label' => 'Show Author',
				'type' => 'switch',
				'name' => 'single_is_show_author',
				'default_value' => true,
				'description'	=> 'Turn on/off to show author.'
			),
			array(
				'label' => 'Show Comment',
				'type' => 'switch',
				'name' => 'single_is_show_comment',
				'default_value' => true,
				'description'	=> 'Turn on/off to show comment.'
			),
			array(
				'label' => 'Show View',
				'type' => 'switch',
				'name' => 'single_is_show_view',
				'default_value' => true,
				'description'	=> 'Turn on/off to show view.'
			),
			array(
				'label' => 'Show Share Box',
				'type' => 'switch',
				'name' => 'single_is_show_share',
				'default_value' => true,
				'description'	=> 'Turn on/off to show share.'
			),
			array(
				'label' => 'Show Author Meta',
				'type' => 'switch',
				'name' => 'single_is_show_author_meta',
				'default_value' => true,
				'description'	=> 'Turn on/off to show author meta.'
			),
			array(
				'label' => 'Show Post Paging',
				'type' => 'switch',
				'name' => 'single_is_show_navi',
				'default_value' => true,
				'description'	=> 'Turn on/off to show post paging.'
			),
			array(
				'label' => 'Show Related Posts',
				'type' => 'switch',
				'name' => 'single_is_show_related',
				'default_value' => true,
				'description'	=> 'Turn on/off to show related posts.'
			)
		)
	));
	
	
	 
	// Sidebar option
	rs::addOptionTab(array(
		'title' => 'Sidebar',
		'name' => 'sidebar_option',
		'icon' => 'flaticon-right25',
		'controls' => array(
			array(
				'label' => 'List Sidebar',
				'type' => 'repeater',
				'name' => 'list_sidebar',
				'add_row_text' => 'Add Sidebar',
				'min_rows' => 0,
				'controls' => array(
					array(
						'name' => 'sidebar',
						'label'  => 'Name Sidebar',
						'type' => 'text'
					)
				),
				'description'	=> 'Add new sidebar.'
			),
		)
	));
	
	
	
	// Translations option
	rs::addOptionTab(array(
		'title' => 'Translate / ReName Text',
		'name' => 'translations_option',
		'icon' => 'flaticon-globe14',
		'controls' => array(
			array(
				'type' => 'script',
				'name' => 'translate_header',
				'callback' => 'translate_header'
			),
			array(
				'label' => 'Search',
				'type' => 'text',
				'name' => 'search'
			),
			array(
				'label' => 'Followers',
				'type' => 'text',
				'name' => 'followers'
			),
			array(
				'label' => 'Likes',
				'type' => 'text',
				'name' => 'likes'
			),
			array(
				'label' => 'Subscriber',
				'type' => 'text',
				'name' => 'subscriber'
			),
			array(
				'label' => 'Comment',
				'type' => 'text',
				'name' => 'comment'
			),
			array(
				'label' => 'Leave a Comment',
				'type' => 'text',
				'name' => 'leave_a_comment'
			),
			array(
				'label' => 'Send Comment',
				'type' => 'text',
				'name' => 'sent_comment'
			),
			array(
				'label' => 'Your Message',
				'type' => 'text',
				'name' => 'your_message'
			),
			array(
				'label' => 'Name',
				'type' => 'text',
				'name' => 'name'
			),
			array(
				'label' => 'Email',
				'type' => 'text',
				'name' => 'email'
			),
			array(
				'label' => 'Website',
				'type' => 'text',
				'name' => 'website'
			),
			array(
				'label' => 'Related Posts',
				'type' => 'text',
				'name' => 'related_posts'
			),
			array(
				'label' => 'Share this',
				'type' => 'text',
				'name' => 'share_this'
			),
			array(
				'label' => 'Was This Post Helpful',
				'type' => 'text',
				'name' => 'was_this_post_helpful'
			),
			array(
				'label' => 'Breaking',
				'type' => 'text',
				'name' => 'breaking'
			),
			array(
				'label' => 'Menu',
				'type' => 'text',
				'name' => 'menu'
			),
			array(
				'label' => 'Error 404',
				'type' => 'text',
				'name' => 'error_404'
			),
			array(
				'label' => 'Page Not Found',
				'type' => 'text',
				'name' => 'page_not_found'
			),
			array(
				'label' => 'Please go back to home or try again.',
				'type' => 'text',
				'name' => 'please_back_home'
			),
			array(
				'label' => 'Go home',
				'type' => 'text',
				'name' => 'go_home'
			),
			array(
				'label' => 'Posts by',
				'type' => 'text',
				'name' => 'posts_by'
			),
			array(
				'label' => 'Daily Archives',
				'type' => 'text',
				'name' => 'daily_archives'
			),
			array(
				'label' => 'Monthly Archives',
				'type' => 'text',
				'name' => 'monthly_archives'
			),
			array(
				'label' => 'Yearly Archives',
				'type' => 'text',
				'name' => 'yearly_archives'
			),
			array(
				'label' => 'search results',
				'type' => 'text',
				'name' => 'search_results'
			),
			array(
				'label' => 'If you\'re not happy with the results, please do another search',
				'type' => 'text',
				'name' => 'search_not_happy'
			),
			array(
				'label' => 'It seems we can\'t find what you\'re looking for. Perhaps searching can help.',
				'type' => 'text',
				'name' => 'query_not_found'
			),
		)
	));
	
	// Custom Typography
	rs::addOptionTab(array(
		'title' => 'Custom Typography',
		'name' => 'typography_option',
		'icon' => 'flaticon-address16',
		'controls' => array(
			array(
				'label'			=> 'Over-all Website Font',
				'type'			=> 'group',
				'name'			=> 'website-font',
				'show_controls'  => true,
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'lineheight',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H1',
				'type'			=> 'group',
				'name'			=> 'headline1_custom',
				'description'	=> 'Set custom headline H1.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h1'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h1',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h1',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H2',
				'type'			=> 'group',
				'name'			=> 'headline2_custom',
				'description'	=> 'Set custom headline H2.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h2'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h2',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h2',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H3',
				'type'			=> 'group',
				'name'			=> 'headline3_custom',
				'description'	=> 'Set custom headline H3.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h3'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h3',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h3',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H4',
				'type'			=> 'group',
				'name'			=> 'headline4_custom',
				'description'	=> 'Set custom headline H4.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h4'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h4',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h4',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H5',
				'type'			=> 'group',
				'name'			=> 'headline5_custom',
				'description'	=> 'Set custom headline H5.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h5'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h5',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h5',
						'items'		=> $list_size
					)
				)
			),
			array(
				'label'			=> 'Headline H6',
				'type'			=> 'group',
				'name'			=> 'headline6_custom',
				'description'	=> 'Set custom headline H6.',
				'controls'	=> array(
					array(
						'label'		=> 'Font family',
						'type'		=> 'googlefonts',
						'name'		=> 'fonts_h6'
					),
					array(
						'label'		=> 'Font size',
						'type'		=> 'select',
						'name'		=> 'size_h6',
						'items'		=> $list_size
					),
					array(
						'label'		=> 'Line height',
						'type'		=> 'select',
						'name'		=> 'line_h6',
						'items'		=> $list_size
					)
				)
			)
		)
	));
	
	// Social networks
	rs::addOptionTab(array(
		'title' => 'Social Media',
		'name' => 'socials-option',
		'icon' => 'flaticon-arrow423',
		'controls' => array(
			array(
				'type' => 'script',
				'name' => 'socials_header',
				'callback' => 'socials_header'
			),
			array(
				'label' => 'Facebook',
				'type' => 'text',
				'name' => 'social_facebook',
			),
			array(
				'label' => 'Twitter',
				'type' => 'text',
				'name' => 'social_twitter',
			),
			array(
				'label' => 'Youtube',
				'type' => 'text',
				'name' => 'social_youtube',
			),
			array(
				'label' => 'Soundcloud',
				'type' => 'text',
				'name' => 'social_soundcloud',
			),
			array(
				'label' => 'Google Plus',
				'type' => 'text',
				'name' => 'social_google_plus',
			),
			array(
				'label' => 'Instagram',
				'type' => 'text',
				'name' => 'social_instagram',
			),
		)
	));
	
	// Seo option
	rs::addOptionTab(array(
		'title' => 'Seo',
		'name' => 'seo_option',
		'icon' => 'flaticon-zoom22',
		'controls' => array(
			array(
				'label' => 'Meta Description',
				'type' => 'textarea',
				'name' => 'des_seo',
				'description'	=> 'Enter your website meta description for SEO.'
			),
			array(
				'label' => 'Meta Keywords',
				'type' => 'textarea',
				'name' => 'keywords_seo',
				'description'	=> 'Enter your keywords here separated by a comma.'
			),
			array(
				'label' => 'Meta Author',
				'type' => 'text',
				'name' => 'author_seo',
				'description'	=> ''
			)
		)
	));
	
	

	// CSS option
	rs::addOptionTab(array(
		'title' => 'Custom Css',
		'name' => 'css_option',
		'icon' => 'flaticon-codings1',
		'controls' => array(
			array(
				'label' => 'Custom CSS',
				'type' => 'textarea',
				'name' => 'css_custom',
				'description'	=> 'Enter your custom CSS styling here.'
			)
		)
	));
	
	// Import control	
	function import_demo() {
		echo '<div id="css_custom-field" class="rs-field rs-import-demo">';
			echo '<div class="rs-field-label">';
				echo '<label for="css_custom">Import Demo Data</label>';
				echo '<p>Make your site looks like demo.</p>';
			echo '</div>';
			echo '<div class="rs-field-editor">';
				echo '<div class="rs-control rs-textarea-wrap " id="css_custom-wrap">';
					echo '<a id="rs-import" class="rs-button rs-button-primary">Import Demo</a>';
					echo '<span class="spinner"></span>';
					echo '<span class="import_message"></span>';
				echo '</div>';
			echo '</div>';
			echo '<div class="clear"></div>';
			
			echo '<div id="popup_select_style">';
				echo '<div class="list_type">';
					echo '<a rel="default" alt="Home 1 - News" href="javascript:;" class="choose_theme"><img src="'. esc_url( get_template_directory_uri()) .'/rslib/cpanel/images/theme_1.jpg" alt="" /><span>Home 1<br/>News</span></a>';
					echo '<a rel="tech" alt="Home 2 - Tech" href="javascript:;" class="choose_theme"><img src="'. esc_url( get_template_directory_uri()) .'/rslib/cpanel/images/theme_2.jpg" alt="" /><span>Home 2<br/>News - Tech</span></a>';
					echo '<a rel="sport" alt="Home 3 - Sport" href="javascript:;" class="choose_theme"><img src="'. esc_url( get_template_directory_uri()) .'/rslib/cpanel/images/theme_3.jpg" alt="" /><span>Home 3<br/>News - Sport</span></a>';
					echo '<a rel="videos" alt="Home 4 - Video" href="javascript:;" class="choose_theme"><img src="'. esc_url( get_template_directory_uri()) .'/rslib/cpanel/images/theme_4.jpg" alt="" /><span>Home 4<br/>News - Video</span></a>';
				echo '</div>';
			echo '</div>';
			
		echo '</div>';
	} 
	
	//document support
	function document_support() {
	?>
		<div id="css_custom-field" class="rs-field">
			<div class="rs-field-label">
				<label for="css_custom">Support Documentation</label>
				<p>Need Help? Read Doc File.</p>
			</div>
			<div class="rs-field-editor">
				<div class="content-support">
					<a href="#">Read Bloggler Documentation</a> <span>or</span> <a href="#">Contact Support</a>
				</div>
			</div>
			<div class="clear"></div>
		</div>
	<?php }
	//socials header
	function socials_header() {
	?>
		<div id="css_custom-field" class="rs-field rs-socials">
			<h5>Social Media Accounts</h5>
			<p>Insert your custom link to the corresponding social sites to show link icon. Leave blank to hide icon.</p>
		</div>
	<?php }
	//socials header
	function translate_header() {
	?>
		<div id="css_custom-field" class="rs-field rs-socials">
			<h5>Translate or Rename Text</h5>
			<p>You can translate or rename few custom link text we use to your own language using input options below.</p>
		</div>
	<?php }
	// Add style
	function add_style_option(){
		?>
		<style type="text/css" rel="stylesheet">
			.rs-socials h5,.rs-socials p {
				font-size:13px;
				margin:0;
			}	
			.content-support,.content-support a {
				color:#2e8070;
				font-size:12px;
				text-style:italic;
			}
			.content-support {
				padding:10px 0 0 30px;
			}	
			.content-support a {
				font-style: italic;
				text-decoration: underline;
				text-transform: capitalize;
				font-weight:bold !Important;
			}
			.content-support span {
				margin:0 4px 0 5px;
			}
			.rs-import-demo #rs-import {
				
			}
			.rs-import-demo .spinner {
				display:none;
				float:left;
			}
			.rs-panel .rs-textarea{
				height:200px;
			}
			.rs-editor-wrap {
				border:none;
			}
			.rs-sidebar
			{
				background:#3c4b5a
			}
			.rs-menu > ul > li:hover, .rs-menu > ul > li.active
			{
				background:#2c3843;
			}
			.rs-form
			{
				 border-top: 5px solid #8e99a4;
			}
			.rs-avatar img
			{
				border-radius: 100%;
				display: block;
				float: none;
				margin: 0 auto;
				width: 45%;
			}
			.rs-avatar p
			{
				float: none;
				text-align: center;
			}
			.rs-header
			{
				display:none;
			}
			.rs-menu ul li a {
				box-shadow:none;
			}
		</style>
		<?php
		
		?>
		<?php
	}

	add_action('admin_head', 'add_style_option');
?>