<?php
class ubtheme_ads_widget extends WP_Widget {
	
	function ubtheme_ads_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_ads', 'description' => 'A widget that show ads' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-ads-widget', 'Ublog Ads Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		$html .= $args['before_widget'];
		$class = 'col-sm-6';
		if( $instance['column'] == 1 ) 
			$class = 'col-sm-12';
			
		$html .= '<div class="row list-adv clearfix">';
			if( isset($instance['adv1']) && !empty($instance['adv1']) ){
				$html .= '<div class="'.$class.'">';
					if( isset($instance['link_ads1']) && !empty($instance['link_ads1']) )
						$html .= '<a href="'. $instance['link_ads1'] .'">';
					$html .= '<img src="'. ub_get_attachment_image_src($instance['adv1'],'full') .'" alt="" />';
					if( isset($instance['link_ads1']) && !empty($instance['link_ads1']) )
						$html .= '</a>';
				$html .= '</div>';
			}
			if( isset($instance['adv2']) && !empty($instance['adv2']) ){
				$html .= '<div class="'.$class.'">';
					if( isset($instance['link_ads2']) && !empty($instance['link_ads2']) )
						$html .= '<a href="'. $instance['link_ads2'] .'">';
					$html .= '<img src="'. ub_get_attachment_image_src($instance['adv2'],'full') .'" alt="" />';
					if( isset($instance['link_ads2']) && !empty($instance['link_ads2']) )
						$html .= '</a>';
				$html .= '</div>';
			}
			if( isset($instance['adv3']) && !empty($instance['adv3']) ){
				$html .= '<div class="'.$class.'">';
					if( isset($instance['link_ads3']) && !empty($instance['link_ads3']) )
						$html .= '<a href="'. $instance['link_ads3'] .'">';
					$html .= '<img src="'. ub_get_attachment_image_src($instance['adv3'],'full') .'" alt="" />';
					if( isset($instance['link_ads3']) && !empty($instance['link_ads3']) )
						$html .= '</a>';
				$html .= '</div>';
			}
			if( isset($instance['adv4']) && !empty($instance['adv4']) ){
				$html .= '<div class="'.$class.'">';
					if( isset($instance['link_ads4']) && !empty($instance['link_ads4']) )
						$html .= '<a href="'. $instance['link_ads4'] .'">';
					$html .= '<img src="'. ub_get_attachment_image_src($instance['adv4'],'full') .'" alt="" />';
					if( isset($instance['link_ads4']) && !empty($instance['link_ads4']) )
						$html .= '</a>';
				$html .= '</div>';
			}
		$html .= '</div>';
		$html .= $args['after_widget'];
		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Number Columns: <br/></label>
		<label><input type="radio" <?php echo (isset($instance['column']) && $instance['column'] == 1) ? 'checked="checked"' : ''; ?> value="1" name="<?php echo esc_attr($this->get_field_name( 'column' )); ?>" /> 1 Column</label><br/>
		<label><input type="radio" <?php echo (isset($instance['column']) && $instance['column'] == 2) ? 'checked="checked"' : ''; ?> value="2" name="<?php echo esc_attr($this->get_field_name( 'column' )); ?>" /> 2 Columns</label>
		<br/><br/>
		<label>Image Ads 1:
		<?php rs::upload(array('name'=>esc_attr($this->get_field_name( 'adv1' )),'value'=> isset($instance['adv1']) ? esc_attr($instance['adv1']) : '')); ?></label>
		<br/><br/>
		<label>Link Ads 1:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'link_ads1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_ads1' )); ?>" value="<?php echo isset($instance['link_ads1']) ? esc_attr($instance['link_ads1']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Image Ads 2:
		<?php rs::upload(array('name'=>esc_attr($this->get_field_name( 'adv2' )),'value'=> isset($instance['adv2']) ? esc_attr($instance['adv2']) : '')); ?></label>
		<br/><br/>
		<label>Link Ads 2:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'link_ads2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_ads2' )); ?>" value="<?php echo isset($instance['link_ads2']) ? esc_attr($instance['link_ads2']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Image Ads 3:
		<?php rs::upload(array('name'=>esc_attr($this->get_field_name( 'adv3' )),'value'=> isset($instance['adv3']) ? esc_attr($instance['adv3']) : '')); ?></label>
		<br/><br/>
		<label>Link Ads 3:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'link_ads3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_ads3' )); ?>" value="<?php echo isset($instance['link_ads3']) ? esc_attr($instance['link_ads3']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Image Ads 4:
		<?php rs::upload(array('name'=>esc_attr($this->get_field_name( 'adv4' )),'value'=> isset($instance['adv4']) ? esc_attr($instance['adv4']) : '')); ?></label>
		<br/><br/>
		<label>Link Ads 4:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'link_ads4' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_ads4' )); ?>" value="<?php echo isset($instance['link_ads4']) ? esc_attr($instance['link_ads4']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_ads_widget' );

function create_ads_widget(){
	return register_widget("ubtheme_ads_widget");
}