<?php
class ubtheme_news_tab_widget extends WP_Widget {
	
	function ubtheme_news_tab_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_news', 'description' => 'A widget that show news tab' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-news-tab-widget', 'Ublog News Tab Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		$html .= $args['before_widget'];
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		
		$html .= '<ul class="tab-post-new clearfix">';
			if( isset($instance['rst_widget_show_popular']) && $instance['rst_widget_show_popular'] ) $html .= '<li><a href="#">Popular</a></li>';
			if( isset($instance['rst_widget_show_recent']) && $instance['rst_widget_show_recent'] ) $html .= '<li><a href="#">Recent</a></li>';
			if( isset($instance['rst_widget_show_comment']) && $instance['rst_widget_show_comment'] ) $html .= '<li><a href="#">Comment</a></li>';
		$html .= '</ul>';
		if( !(!isset($instance['rst_widget_show_popular']) && !isset($instance['rst_widget_show_recent']) && !isset($instance['rst_widget_show_comment'])) ) {
			$html .= '<div class="info-post-new">';
				if( isset($instance['rst_widget_show_popular']) && $instance['rst_widget_show_popular'] ) {
					$html .= '<ul>';
						$new_posts = get_posts( 
										array(
											'posts_per_page' => isset($instance['rst_widget_number_popular']) ? absint($instance['rst_widget_number_popular']) : 5,
											'orderby'=> 'meta_value_num',
											'meta_key' => 'ub_post_views_count',
											'order' => 'DESC',
										)
						);
						if( is_array($new_posts) && sizeof($new_posts) ) {
							foreach($new_posts as $post) {
								setup_postdata($post);
						$html .= '<li class="clearfix">';
							if( get_post_thumbnail_id($post->ID) ) {
							$html .= '<a class="thumbnail ub-thumbnail ub-post-format-'. sanitize_html_class(get_post_format($post->ID)) .'" href="'. get_permalink($post->ID) .'">';
								$html .= '<img alt="'. get_the_title($post->ID) .'" src="'. ub_get_attachment_image_src(get_post_thumbnail_id($post->ID),'thumbnail') .'" />';
								$html .= '<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>';
							$html .= '</a>';
							}
							$html .= '<h5><a href="'. get_permalink($post->ID) .'">'. get_the_title($post->ID) .'</a></h5>';
							$html .= '<span class="date"><a href="'. get_permalink($post->ID) .'">'. mysql2date('F j, Y', $post->post_date) .'</a></span>';
						$html .= '</li>';
							}
							wp_reset_postdata();
						}
					$html .= '</ul>';
				}
				if( isset($instance['rst_widget_show_recent']) && $instance['rst_widget_show_recent'] ) {
					$html .= '<ul>';
						$new_posts = get_posts( array('posts_per_page' => isset($instance['rst_widget_number_recent']) ? absint($instance['rst_widget_number_recent']) : 5) );
						if( is_array($new_posts) && sizeof($new_posts) ) {
							foreach($new_posts as $post) {
								setup_postdata($post);
						$html .= '<li class="clearfix">';
							if( get_post_thumbnail_id($post->ID) ) {
							$html .= '<a class="thumbnail ub-thumbnail ub-post-format-'. sanitize_html_class(get_post_format($post->ID)) .'" href="'. get_permalink($post->ID) .'">';
								$html .= '<img alt="'. get_the_title($post->ID) .'" src="'. ub_get_attachment_image_src(get_post_thumbnail_id($post->ID),'thumbnail') .'" />';
								$html .= '<span class="wrap-overlay"><span class="fa overlay-icon"></span></span>';
							$html .= '</a>';
							}
							$html .= '<h5><a href="'. get_permalink($post->ID) .'">'. get_the_title($post->ID) .'</a></h5>';
							
							$html .= '<span class="date"><a href="'. get_permalink($post->ID) .'">'. mysql2date('F j, Y', $post->post_date) .'</a></span>';
						$html .= '</li>';
							}
							wp_reset_postdata();
						}
					$html .= '</ul>';
				}
				if( isset($instance['rst_widget_show_comment']) && $instance['rst_widget_show_comment'] ) {
					$html .= '<ul>';
					$number = $instance['rst_widget_number_comment'] ? $instance['rst_widget_number_comment'] : 4;
					global $wpdb;
					$recent_comments = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved, comment_type, comment_author_url, SUBSTRING(comment_content,1,110) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' ORDER BY comment_date_gmt DESC LIMIT $number";
					$the_comments = $wpdb->get_results($recent_comments);
					foreach($the_comments as $comment) {
						$html .= '<li class="rst-comment clearfix">';
							$html .= '<div class="image">';
								$html .= '<a>';
									$html .= get_avatar($comment, '75');
								$html .= '</a>';
							$html .= '</div>';
							$html .= '<div class="post-holder">';
								$html .= '<p class="author-name">'. strip_tags($comment->comment_author). '</p>';
								$html .= '<div class="meta">';
									$html .= '<a class="comment-text-side" href="'. get_permalink($comment->ID) .'#comment-'. $comment->comment_ID .'" title="'. strip_tags($comment->comment_author) .' on '. $comment->post_title .'">'. string_limit_words(strip_tags($comment->com_excerpt), 12) .'...</a>';
								$html .= '</div>';
							$html .= '</div>';
						$html .= '</li>';
					}
					$html .= '</ul>';
				}
			$html .= '</div>';
		}

		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Number of popular posts:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'rst_widget_number_popular' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_number_popular' )); ?>" value="<?php echo isset($instance['rst_widget_number_popular']) ? esc_attr($instance['rst_widget_number_popular']) : ''; ?>" style="width:30px"/></label>
		<br/><br/>
		<label>Number of recent posts:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'rst_widget_number_recent' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_number_recent' )); ?>" value="<?php echo isset($instance['rst_widget_number_recent']) ? esc_attr($instance['rst_widget_number_recent']) : ''; ?>" style="width:30px"/></label>
		<br/><br/>
		<label>Number of comments:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'rst_widget_number_comment' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_number_comment' )); ?>" value="<?php echo isset($instance['rst_widget_number_comment']) ? esc_attr($instance['rst_widget_number_comment']) : ''; ?>" style="width:30px"/></label>
		<br/><br/>
		<label><input id="<?php echo esc_attr($this->get_field_id( 'rst_widget_show_popular' )); ?>" class="checkbox" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_show_popular' )); ?>" value="1" <?php echo (isset($instance['rst_widget_show_popular']) && $instance['rst_widget_show_popular'] == 1) ? 'checked="checked"' : ''; ?>>Show popular posts</label>
		<br/><br/>
		<label><input id="<?php echo esc_attr($this->get_field_id( 'rst_widget_show_recent' )); ?>" class="checkbox" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_show_recent' )); ?>" value="1" <?php echo (isset($instance['rst_widget_show_recent']) && $instance['rst_widget_show_recent'] == 1) ? 'checked="checked"' : ''; ?>>Show recent posts</label>
		<br/><br/>
		<label><input id="<?php echo esc_attr($this->get_field_id( 'rst_widget_show_comment' )); ?>" class="checkbox" type="checkbox" name="<?php echo esc_attr($this->get_field_name( 'rst_widget_show_comment' )); ?>" value="1" <?php echo (isset($instance['rst_widget_show_comment']) && $instance['rst_widget_show_comment'] == 1) ? 'checked="checked"' : ''; ?>>Show comments</label>
		<br/><br/>
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_news_tab_widget' );

function create_news_tab_widget(){
	return register_widget("ubtheme_news_tab_widget");
}