<?php
class ubtheme_post_list_widget extends WP_Widget {
	
	function ubtheme_post_list_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_post_list', 'description' => 'A widget that show post list' );

		/* Create the widget. */
		$this->WP_Widget( 'ubtheme-post-list-widget', 'Ublog Post List Widget', $widget_ops);	
	}
	 
	function widget($args, $instance) {
		$html = '';
		$html .= $args['before_widget'];
		if( !empty($instance['title']) ) {
			$html .= $args['before_title'];
				$html .= $instance['title'];
			$html .= $args['after_title'];
		}
		if( is_array($instance['rst_widget_post_list']) && sizeof($instance['rst_widget_post_list']) ){
			foreach( $instance['rst_widget_post_list'] as $key=>$item ) {
				$post_current = get_post($item['post']);
				if( $key == 0 ){
					$html .= '<div class="ub-post-item-large">';
					if( get_post_thumbnail_id($post_current->ID) ) {
						$html .= '<a class="thumbnail ub-thumbnail ub-post-format-'. sanitize_html_class(get_post_format($post_current->ID)) .'" href="'. get_permalink($post_current->ID) .'"><img alt="'. get_the_title($post_current->ID) .'" src="'. ub_get_attachment_image_src(get_post_thumbnail_id($post_current->ID),'ub_medium') .'" /><span class="wrap-overlay"><span class="fa overlay-icon"></span></span></a>';
						$html .= '<h4><a href="'. get_permalink($post_current->ID) .'">'. get_the_title($post_current->ID) .'</a></h4>';
					}
					$html .= '</div>';
				}
				else {
					$html .= '<div class="ub-post-item"><a href="'. get_permalink($post_current->ID) .'">'. rst_get_icon_postformat($post_current->ID). get_the_title($post_current->ID) .'</a></div>';
				}
			}
		}
		echo force_balance_tags($html);
	}
 
	function update($new_instance, $old_instance) {
		return $new_instance;		
	}
 
	function form($instance) {
		?><br/>
		<label>Widget Title:
		<input type="text" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>" style="width:100%"/></label>
		<br/><br/>
		<label>Select Post Show Widget:</label>
		<?php 
			rs::repeater(array(
				'name' => $this->get_field_name( 'rst_widget_post_list' ),
				'type' => 'repeater',
				'add_row_text' => 'Add Post',
				'min_rows' => 0,
				'controls' => array(
				  array(
					 'name' => 'post',
					 'type'  => 'postlist',
				  )
			   ),
			   'value' => isset($instance['rst_widget_post_list']) ? $instance['rst_widget_post_list'] : ''
			));
		?>
		<br/><br/>
		<?php	
	}
	
}

add_action( 'widgets_init', 'create_post_list_widget' );

function create_post_list_widget(){
	return register_widget("ubtheme_post_list_widget");
}