(function($) {
	/**
	 *
	 * RoyalSlider fullscreen module
	 * @version 1.0.5:
	 *
	 * 1.0.1:
	 * - Added rsEnterFullscreen and rsExitFullscreen events
	 *
	 * 1.0.2
	 * - Added window scroll detection
	 *
	 * 1.0.3
	 * - Fullscreen button now is added to _controlsContainer element
	 *
	 * 1.0.4
	 * - Fixed issue that could cause small image be loaded in fullscreen
	 *
	 * 1.0.5
	 * - Fix "false" native fullscreen on Android
	 * 
	 */
	$.extend($.rsProto, {
		_initFullscreen: function() {
			var self = this;

			self._fullscreenDefaults = {
				enabled: false,
				keyboardNav: true,
				buttonFS: true,
				nativeFS: false,
				doubleTap: true
			};
			self.st.fullscreen = $.extend({}, self._fullscreenDefaults, self.st.fullscreen);

			if(self.st.fullscreen.enabled) {
				self.ev.one('rsBeforeSizeSet', function() {
					self._setupFullscreen();
				});
			}
		},
		_setupFullscreen: function() {
			var self = this;
			self._fsKeyboard = (!self.st.keyboardNavEnabled && self.st.fullscreen.keyboardNav);

			if(self.st.fullscreen.nativeFS) {
				// Thanks to John Dyer http://j.hn/
			    self._fullScreenApi = {
			            supportsFullScreen: false,
			            isFullScreen: function() { return false; },
			            requestFullScreen: function() {},
			            cancelFullScreen: function() {},
			            fullScreenEventName: '',
			            prefix: ''
			        };
			    var browserPrefixes = 'webkit moz o ms khtml'.split(' ');
			    // check for native support
			    if(!self.isAndroid) {
			    
				    if (typeof document.cancelFullScreen != 'undefined') {
				         self._fullScreenApi.supportsFullScreen = true;
				    } else {
				        // check for fullscreen support by vendor prefix
				        for (var i = 0; i < browserPrefixes.length; i++ ) {
				             self._fullScreenApi.prefix = browserPrefixes[i];
				 
				            if (typeof document[ self._fullScreenApi.prefix + 'CancelFullScreen' ] != 'undefined' ) {
				                 self._fullScreenApi.supportsFullScreen = true;
				 
				                break;
				            }
				        }
				    }

			    }
			 
			    // update methods to do something useful
			    if ( self._fullScreenApi.supportsFullScreen) {
			    	self.nativeFS = true;
			         self._fullScreenApi.fullScreenEventName =  self._fullScreenApi.prefix + 'fullscreenchange' + self.ns;
			 	
			         self._fullScreenApi.isFullScreen = function() {
			            switch (this.prefix) {
			                case '':
			                    return document.fullScreen;
			                case 'webkit':
			                    return document.webkitIsFullScreen;
			                default:
			                    return document[this.prefix + 'FullScreen'];
			            }
			        };
			         self._fullScreenApi.requestFullScreen = function(el) {
			            return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
			        };
			         self._fullScreenApi.cancelFullScreen = function(el) {
			            return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
			        };
			    } else {
			    	self._fullScreenApi = false;
			    }
			}


			if(self.st.fullscreen.buttonFS) {
				self._fsBtn = $('<div class="rsFullscreenBtn"><div class="rsFullscreenIcn"></div></div>')
					.appendTo(self._controlsContainer)
					.on('click.rs', function() {
						if(self.isFullscreen) {
							self.exitFullscreen();
						} else {

							self.enterFullscreen();
						}
					});
			}
		},
		enterFullscreen: function(preventNative) {
			var self = this;
			if( self._fullScreenApi ) {
				if(!preventNative) {
					self._doc.on( self._fullScreenApi.fullScreenEventName, function(e) {
						if(!self._fullScreenApi.isFullScreen()) {
							self.exitFullscreen(true);
						} else {
							self.enterFullscreen(true);
						}
					});
					self._fullScreenApi.requestFullScreen($('html')[0]);
					return;
				} else {
					self._fullScreenApi.requestFullScreen($('html')[0]);
				}
			}

			if(self._isFullscreenUpdating) {
				return;
			}
			self._isFullscreenUpdating = true;

			self._doc.on('keyup' + self.ns + 'fullscreen', function(e) {
				if(e.keyCode === 27) {
					self.exitFullscreen();
				}
			});
			if(self._fsKeyboard) {
				self._bindKeyboardNav();
			}

			var win = $(window);
			self._fsScrollTopOnEnter = win.scrollTop();
			self._fsScrollLeftOnEnter = win.scrollLeft();

			self._htmlStyle = $('html').attr('style');
			self._bodyStyle = $('body').attr('style');
			self._sliderStyle = self.slider.attr('style');

			$('body, html').css({
				overflow: 'hidden',
				height: '100%',
				width: '100%',
				margin: '0',
				padding: '0'
			});

			self.slider.addClass('rsFullscreen');
			
		
			var item,
				i;
			for(i = 0; i < self.numSlides; i++) {
				item = self.slides[i];
				
				item.isRendered = false;
				if(item.bigImage) {
					item.isBig = true;
					item.isMedLoaded = item.isLoaded;
					item.isMedLoading = item.isLoading;
					item.medImage = item.image;
					item.medIW = item.iW;
					item.medIH = item.iH;
					item.slideId = -99;

					if(item.bigImage !== item.medImage) {
						item.sizeType = 'big';
					}

					item.isLoaded = item.isBigLoaded;
					item.isLoading = false;
					item.image = item.bigImage;
					item.images[0] = item.bigImage;
					item.iW = item.bigIW;
					item.iH = item.bigIH;

					item.isAppended = item.contentAdded = false;
					self._updateItemSrc(item);
				}
				
			}

			
			self.isFullscreen = true;
			
			self._isFullscreenUpdating = false;
			self.updateSliderSize();
			self.ev.trigger('rsEnterFullscreen');
			
		},
		exitFullscreen: function(preventNative) {
			var self = this;

			if( self._fullScreenApi ) {
				if(!preventNative) {
					self._fullScreenApi.cancelFullScreen($('html')[0]);
					return;
				}
				self._doc.off( self._fullScreenApi.fullScreenEventName );
			}
			if(self._isFullscreenUpdating) {
				return;
			}
			self._isFullscreenUpdating = true;

			self._doc.off('keyup'  + self.ns + 'fullscreen');
			if(self._fsKeyboard) {
				self._doc.off('keydown' + self.ns);
			}

			$('html').attr('style', self._htmlStyle || '');
			$('body').attr('style', self._bodyStyle || '');
			

			
			var item,
				i;
			for(i = 0; i < self.numSlides; i++) {
				item = self.slides[i];
				
				
				item.isRendered = false;
				if(item.bigImage) {
					item.isBig = false;
					item.slideId = -99;
					item.isBigLoaded = item.isLoaded;
					item.isBigLoading = item.isLoading;
					item.bigImage = item.image;
					item.bigIW = item.iW;
					item.bigIH = item.iH;
					item.isLoaded = item.isMedLoaded;
					item.isLoading = false;
					item.image = item.medImage;
					item.images[0] = item.medImage;
					item.iW = item.medIW;
					item.iH = item.medIH;

					item.isAppended = item.contentAdded = false;

					self._updateItemSrc(item, true);
					
					
					if(item.bigImage !== item.medImage) {
						item.sizeType = 'med';
					}
				}
			}
			
			self.isFullscreen = false;

			var win = $(window);
			win.scrollTop( self._fsScrollTopOnEnter );
			win.scrollLeft( self._fsScrollLeftOnEnter );
			
			self._isFullscreenUpdating = false;
			self.slider.removeClass('rsFullscreen');

			self.updateSliderSize();
			// fix overflow bug
			setTimeout(function() {
				self.updateSliderSize();
			},1);
			self.ev.trigger('rsExitFullscreen');
		},
		_updateItemSrc: function(item, exit) {
			var newHTML = (!item.isLoaded && !item.isLoading) ? '<a class="rsImg rsMainSlideImage" href="'+item.image+'"></a>' : '<img class="rsImg rsMainSlideImage" src="'+item.image+'"/>';
			
			if(item.content.hasClass('rsImg')) {
				item.content = $(newHTML);
			} else {
				item.content.find('.rsImg').eq(0).replaceWith(newHTML);
			}
			if(!item.isLoaded && !item.isLoading && item.holder) {
				item.holder.html(item.content);
			}
		}
	});
	$.rsModules.fullscreen = $.rsProto._initFullscreen;
})(jQuery);
