<?php
/**
 * @package Ublog
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('ub-blog-post'); ?>>
	<header class="entry-header">
		<?php 
			global $size_image;
			if( $size_image == NULL ) $size_image = array('width' => 1000,'height' => 490);
			
			$thumbnail = '';
			if( get_post_thumbnail_id(get_the_ID()) )
				$thumbnail = '<a class="thumbnail ub-thumbnail ub-post-format-'. sanitize_html_class(get_post_format(get_the_ID())) .'" href="'. get_permalink(get_the_ID()) .'"><img alt="'. get_the_title(get_the_ID()) .'" src="'. bfi_thumb(ub_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()),'full'), $size_image ) .'"></a>';
		
			if( get_theme_mod('rst_cat_is_show_thumbnail') == 'thumbnail' ) {
				echo force_balance_tags($thumbnail);
			}
			elseif( get_post_format() == 'video' ) {
				if( rsthemes_get_iframe_postformat_video() ) { 
					echo rsthemes_get_iframe_postformat_video();
				}
				else {
					echo force_balance_tags($thumbnail);
				}
			}
			elseif( get_post_format() == 'audio' ) {
				$audio_type = rs::getField('ublog_audio_type',get_the_ID());
				$audio_iframe = rs::getField('ublog_audio_iframe',get_the_ID());
				$audio_upload = rs::getField('ublog_audio_upload',get_the_ID(),'audio','url');
				
				if( $audio_type == 'iframe' && $audio_iframe != '' ) {
					echo force_balance_tags($audio_iframe);
				}
				elseif( $audio_type == 'upload' && $audio_upload ) {
					echo do_shortcode( '[audio src="'. esc_url($audio_upload). '" ]' );
				}
				else {
					echo force_balance_tags($thumbnail);
				}
			}
			elseif( get_post_format() == 'gallery' ) {
				 $gallery = rs::getField('ublog_gallery',get_the_ID(),'gallery');
				 if(sizeof($gallery)){ ?>
					 <div class="thumbnail-slider">
						<ul class="thumbnail-bxslider">
							<?php foreach( $gallery as $img ) { ?>
							  <li><a href="<?php echo get_permalink(get_the_ID()) ?>"><img alt="<?php get_the_title(get_the_ID()) ?>" src="<?php echo ub_get_attachment_image_src( $img['id'], 'large' ) ?>"/></a></li>
							<?php } ?>
						</ul>	                            
					</div>
			<?php
				 }
				 else {
					echo force_balance_tags($thumbnail);
				 }
			}
			elseif( get_post_format() == 'quote' ) {
				$ublog_quote = rs::getField('ublog_quote');
				$ublog_quotesource = rs::getField('ublog_quotesource');
				echo '<blockquote>'. force_balance_tags($ublog_quote) .'<cite>'. force_balance_tags($ublog_quotesource) .'</cite></blockquote>';
				echo force_balance_tags($thumbnail);
			}
			
			the_title( '<h4 class="entry-title"><a href="'. get_permalink(get_the_ID()) .'">', '</a></h4>' ); 
		?>
		<div class="entry-meta">
			<?php rst_display_post_information() ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php 
			the_excerpt();
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'ublog' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
