<?php
/**
 * The template for displaying all page.
 *
 * @package Ublog
 */

get_header(); ?>

	<div id="content">
		<div class="row inner-content">
			<?php
				$single_style = rs::getField('page_template_style') ? rs::getField('page_template_style') : 1;
				$class = 'col-sm-12';
				$sidebar = rs::getField('page_template_style') ? rs::getField('rst_show_widget') : get_theme_mod('rst_page_sidebar');
				if( $single_style == 2 || $single_style == 3 )
					$class = 'col-sm-8';
				if( $single_style == 2 && $sidebar ) {
			?>
				<div id="sidebar" class="widget-area col-sm-4" role="complementary">
					<?php dynamic_sidebar( $sidebar ); ?>
				</div><!-- #secondary -->
			<?php
				}
			?>
			
			<!-- ===== Archive Content ======= -->
			<div id="main_content" class="<?php echo sanitize_html_class($class) ?>">
			
			<?php if( rs::getField('page_is_show_breadcrumb') ) { ?>
				<?php rst_wp_bac_breadcrumb() ?>
			<?php } ?>
			
			<?php if ( have_posts() ) : ?>

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php
						/* Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'content', 'page' );
					?>

				<?php endwhile; ?>

				
				<?php rst_paging_nav(); ?>

			<?php else : ?>

				<?php get_template_part( 'content', 'none' ); ?>

			<?php endif; ?>

			</div>
			<!--End-Archive-Content-->
			<?php
				if( $single_style == 3 && $sidebar ) {
			?>
				<div id="sidebar" class="widget-area col-sm-4" role="complementary">
					<?php dynamic_sidebar( $sidebar ); ?>
				</div><!-- #secondary -->
			<?php
				}
			?>
		</div>
	</div>

<?php get_footer(); ?>
