<?php
/**
 * The template for displaying search results pages.
 *
 * @package Ublog
 */

get_header(); ?>

	<div id="content">
		<div class="row inner-content">
			<?php
				$class = 'col-sm-12';
				if( get_theme_mod('rst_search_layout') == 2 || get_theme_mod('rst_search_layout') == 3 )
					$class = 'col-sm-8';
				if( get_theme_mod('rst_search_layout') == 2 && get_theme_mod('rst_search_sidebar') ) {
			?>
					<div id="sidebar" class="widget-area col-sm-4" role="complementary">
						<?php dynamic_sidebar( get_theme_mod('rst_search_sidebar') ); ?>
					</div><!-- #secondary -->
			<?php
				}
			?>
			
			<!-- ===== Archive Content ======= -->
			<div id="main_content" class="<?php echo sanitize_html_class($class) ?> ub-list-archive">

			<?php if( !get_theme_mod('rst_search_is_hide_breadcrumb') ) { ?>
				<?php rst_wp_bac_breadcrumb() ?>
			<?php } ?>
			
			<?php
				global $ub_agrs;
				$ub_agrs['is_show_thumbnail'] = true;
				get_theme_mod('rst_search_template') ? $ub_agrs['type'] = get_theme_mod('rst_search_template') : $ub_agrs['type'] = 'box';
				get_theme_mod('rst_search_orderby') ? $ub_agrs['order_by'] = get_theme_mod('rst_search_orderby') : $ub_agrs['order_by'] = 'post_date';
				get_theme_mod('rst_search_order') ? $ub_agrs['order'] = get_theme_mod('blog_order') : $ub_agrs['order']='DESC';
				get_theme_mod('rst_search_column') ? $ub_agrs['column'] = get_theme_mod('rst_search_column') : $ub_agrs['column'] = 2;
				get_theme_mod('rst_search_numberpost') ? $ub_agrs['posts_per_page'] = get_theme_mod('rst_search_numberpost') : $ub_agrs['posts_per_page'] = get_option('posts_per_page');
				get_theme_mod('rst_search_is_show_thumbnail') ? $ub_agrs['type_show_thumbnail_video'] = get_theme_mod('rst_search_is_show_thumbnail') : $ub_agrs['type_show_thumbnail_video'] = 'image';
				get_theme_mod('rst_search_is_show_thumbnail') == 'more' ? $ub_agrs['type_show_thumbnail_gallery'] = 'slider' : '';
				get_theme_mod('rst_search_is_show_thumbnail') == 'image' ? $ub_agrs['type_show_thumbnail_gallery'] = get_theme_mod('rst_search_is_show_thumbnail') : '';
				!get_theme_mod('rst_search_is_show_thumbnail') ? $ub_agrs['type_show_thumbnail_gallery'] = 'image' : '';
				get_theme_mod('rst_search_is_hide_category') ? $ub_agrs['is_show_categories'] = false : $ub_agrs['is_show_categories'] = true;
				get_theme_mod('rst_search_is_hide_date') ? $ub_agrs['is_show_date'] = false : $ub_agrs['is_show_date'] = true;
				get_theme_mod('rst_search_is_hide_excerpt') ? $ub_agrs['is_show_excerpt'] = false : $ub_agrs['is_show_excerpt'] = true;
				get_theme_mod('rst_search_excerpt_length') ? $ub_agrs['excerpt_length'] = get_theme_mod('rst_search_excerpt_length') : $ub_agrs['excerpt_length'] = 30;
				get_theme_mod('rst_search_pagenavi') ? $ub_agrs['is_show_pavi'] = get_theme_mod('rst_search_pagenavi') : $ub_agrs['is_show_pavi'] = 'number';
				get_theme_mod('rst_search_is_hide_comment') ? $ub_agrs['is_show_comment'] = false : $ub_agrs['is_show_comment'] = true;
				get_theme_mod('rst_search_is_hide_view') ? $ub_agrs['is_show_view'] = false : $ub_agrs['is_show_view'] = true;
				get_theme_mod('rst_search_is_hide_author') ? $ub_agrs['is_show_author'] = false : $ub_agrs['is_show_author'] = true;
				
				$args = ub_query_shortcode($ub_agrs);
				$args = array_merge( $wp_query->query_vars, $args );
				$args['post_type'] = 'post';
				$the_query = new WP_Query( $args );
				
			?>
			<h1 class="archive-title" itemprop="name">
				<span class="td-search-query"><?php echo get_search_query() ?></span> - <span> <?php rst_the_translate('search results','search_results') ?></span>
			</h1>
			
			<?php get_search_form(); ?>
			
			<div class="ub-search-subtitle"><?php rst_the_translate('If you\'re not happy with the results, please do another search
			','search_not_happy') ?></div>
			
			<?php if ( $the_query->have_posts() ) : ?>
				<?php	
					$output = '';
					$rstkey = uniqid();
					
					$output .= '<script type="text/javascript">';
						$output .= 'var rst_'. esc_html($rstkey) .' = new rst_blocks();';
						$output .= 'rst_'. esc_html($rstkey) .'.atts = \''. json_encode($ub_agrs) .'\';';
						$output .= 'rst_'. esc_html($rstkey) .'.url = \''. admin_url( "admin-ajax.php" ) .'\';';
					$output .= '</script>';
					
					if( $ub_agrs['type'] == 'grid' ) {
						
						$args = ub_query_shortcode($ub_agrs);
					
						$the_query = new WP_Query( $args );
						if( !empty($attr['title']) )
							$output .= '<h2 class="rs-title-box">'. $attr['title'] .'</h2>';
						$output .= '<div class="'. (isset($attr['extra_class_name']) ? sanitize_html_class($attr['extra_class_name']) : '') .' wrap_ajax '. (isset($attr['section_type']) ? ' ub-blog-grid ub-type-'.$attr['section_type'] : '') .'">';
						$output .= '<div class="row wrap_inner_ajax wrap_ajax ub-blog-box masonry">';
						while ($the_query->have_posts() ) : $the_query->the_post();
							$output .= ub_get_template_part( 'content', get_post_format()  ); 
						endwhile;
						$output .= '</div>';
						if( $ub_agrs['is_show_pavi'] ) $output .= rst_paging_nav_vc($the_query,$ub_agrs,$rstkey);
						$output .= '</div>';
						wp_reset_query(); wp_reset_postdata();
					}
					if( $ub_agrs['type'] == 'box' ) {
						
						$args = ub_query_shortcode($ub_agrs);
					
						$the_query = new WP_Query( $args );
					
						$output .= '<div class="'. (isset($attr['extra_class_name']) ? sanitize_html_class($attr['extra_class_name']) : '') .' row wrap_ajax ub-blog-box '. (isset($attr['column']) ? 'ub-blog-'.sanitize_html_class($attr['column']).'-column' : '') .' '. (isset($attr['section_type']) ? 'ub-type-'.$attr['section_type'] : '') .'">';
						$output .= '<div class="wrap_inner_ajax">';
						$rst_key = 0;
						while ($the_query->have_posts() ) : $the_query->the_post();
							$rst_key++;
							$output .= ub_get_template_part( 'content', get_post_format()  ); 
							if( $rst_key % $ub_agrs['column'] == 0 ) $output .= '<div class="clear"></div>';
						endwhile; 
						$output .= '</div>';
						$output .= '<div class="clear"></div>';
						if( $ub_agrs['is_show_pavi'] ) {
							$output .= '<div class="col-sm-12">';
							$output .= rst_paging_nav_vc($the_query,$ub_agrs,$rstkey);
							$output .= '</div>';
						}
						wp_reset_query(); wp_reset_postdata();
						$output .= '</div>';
					}
					if( $ub_agrs['type'] == 'large' ) {
					
						$output .= '<div class="'. (isset($attr['extra_class_name']) ? sanitize_html_class($attr['extra_class_name']) : '') .' ub-blog-box wrap_ajax ub-blog-large '. (isset($attr['section_type']) ? 'ub-type-'.$attr['section_type'] : '') .'">';
						$output .= '<div class="wrap_inner_ajax">';
						while ($the_query->have_posts() ) : $the_query->the_post();
							$output .= ub_get_template_part( 'content', get_post_format()  ); 
						endwhile;
						$output .= '</div>';
						if( $ub_agrs['is_show_pavi'] ) $output .= rst_paging_nav_vc($the_query,$ub_agrs,$rstkey);
						wp_reset_query(); wp_reset_postdata();
						$output .= '</div>';
					}
					if( $ub_agrs['type'] == 'medium' ) {
						
						$args = ub_query_shortcode($ub_agrs);
						$the_query = new WP_Query( $args );
					
						$output .= '<div class="'. (isset($attr['extra_class_name']) ? sanitize_html_class($attr['extra_class_name']) : '') .' wrap_ajax '. (isset($attr['section_type']) ? ' ub-blog-medium ub-type-'.$attr['section_type'] : '') .'">';
						$output .= '<div class="wrap_inner_ajax">';
						while ($the_query->have_posts() ) : $the_query->the_post();
							$output .= ub_get_template_part( 'content', get_post_format()  ); 
						endwhile;
						$output .= '</div>';
						if( $ub_agrs['is_show_pavi'] ) $output .= rst_paging_nav_vc($the_query,$ub_agrs,$rstkey);
						wp_reset_query(); wp_reset_postdata();
						$output .= '</div>';
					}
					echo $output;
				?>
				
			<?php endif; ?>

			</div>
			<!--End-Archive-Content-->
			<?php 
				if( get_theme_mod('rst_search_layout') == 3 && get_theme_mod('rst_search_sidebar') ) {
			?>
					<div id="sidebar" class="widget-area col-sm-4" role="complementary">
						<?php dynamic_sidebar( get_theme_mod('rst_search_sidebar') ); ?>
					</div><!-- #secondary -->
			<?php
				}
			?>
		</div>
	</div>

<?php get_footer(); ?>

