<div class="rst-thumbnail">
<?php 
	if( get_post_format() == 'video' ) {
		if( rsthemes_get_iframe_postformat_video() ) { 
			echo rsthemes_get_iframe_postformat_video();
		}
		else {
			the_post_thumbnail();
		}
	}
	elseif( get_post_format() == 'audio' ) {
		the_post_thumbnail();
		$audio_type = rs::getField('ublog_audio_type',get_the_ID());
		$audio_iframe = rs::getField('ublog_audio_iframe',get_the_ID());
		$audio_upload = rs::getField('ublog_audio_upload',get_the_ID(),'audio','url');
		
		if( $audio_type == 'iframe' && $audio_iframe != '' ) {
			echo force_balance_tags($audio_iframe);
		}
		elseif( $audio_type == 'upload' && $audio_upload ) {
			echo do_shortcode( '[audio src="'. esc_url($audio_upload). '" ]' );
		}
	}
	elseif( get_post_format() == 'gallery' ) {
		 $gallery = rs::getField('ublog_gallery',get_the_ID(),'gallery');
		 if(sizeof($gallery)){ ?>
			 <div class="thumbnail-slider">
				<ul class="thumbnail-bxslider">
					<?php foreach( $gallery as $img ) { ?>
					  <li><a href="<?php echo get_permalink(get_the_ID()) ?>"><img alt="<?php echo esc_attr(get_the_title(get_the_ID())) ?>" src="<?php echo esc_url(ub_get_attachment_image_src( $img['id'], 'large' )) ?>"/></a></li>
					<?php } ?>
				</ul>	                            
			</div>
	<?php
		 }
		 else {
			 the_post_thumbnail();
		 }
	}
	elseif( get_post_format() == 'quote' ) {
		$ublog_quote = rs::getField('ublog_quote');
		$ublog_quotesource = rs::getField('ublog_quotesource');
		echo force_balance_tags('<blockquote>'. force_balance_tags($ublog_quote) .'<cite>'. force_balance_tags($ublog_quotesource) .'</cite></blockquote>');
		the_post_thumbnail();
	}
	elseif( get_post_format() == 'link' ) {
		if( rs::getField('ublog_link_url') ) $link = rs::getField('ublog_link_url');
		rs::getField('ublog_link_title') ? $title = rs::getField('ublog_link_title') : $title = get_the_title(get_the_ID());
		if( $link ) echo '<a href="'. $link .'">'. $title .'</a>';
	}
	else {
		the_post_thumbnail();
	}
?>
</div>