<?php
if( ! function_exists( 'ub_vc_breaking' ) ) {
	function ub_vc_breaking( $attr, $content = null )
	{
		extract(shortcode_atts(array(
			'title'							=> '',
			'terms'							=> '',
			'tags'							=> '',
			'sort_order_by' 				=> '',
			'sort_order' 					=> '',
			'posts_per_page'				=> '',
			'extra_class_name' 				=> ''
		), $attr));
		
		global $ub_agrs;
		$ub_agrs['type'] = 'breaking';
		
		$ub_agrs['title'] = isset($attr['title']) ? $attr['title'] : '';
		$ub_agrs['category'] = isset($attr['terms']) ? $attr['terms'] : '';
		$ub_agrs['tags'] = isset($attr['tags']) ? $attr['tags'] : ''; $ub_agrs['tags'] = str_replace(",", "+", $ub_agrs['tags']);
		$ub_agrs['order_by'] = isset($attr['sort_order_by']) ? $attr['sort_order_by'] : 'post_date';
		$ub_agrs['order'] = isset($attr['sort_order']) ? $attr['sort_order'] : 'DESC';
		$ub_agrs['column'] = isset($attr['column']) ? $attr['column'] : 3;
		$ub_agrs['posts_per_page'] = isset($attr['posts_per_page']) ? $attr['posts_per_page'] : get_option('posts_per_page');
		$ub_agrs['extra_class_name'] = isset($attr['extra_class_name']) ? $attr['extra_class_name'] : '';
		
		$agrs = ub_query_shortcode($ub_agrs);
		$beaking_post = get_posts($agrs);
				
		$html = '';
		
		if( is_array($beaking_post) && sizeof($beaking_post) ) { 
			$html .= '<div class="social rst-breaking">';
				$html .= '<div class="rst-breaking-news">';
					$html .= '<span class="breaking"><i class="fa fa-bullhorn"></i>'. $ub_agrs['title'] .'</span>';
					
					$html .= '<div class="rst-list-breaking-news">';
						$html .= '<ul>';
							
						foreach($beaking_post as $beaking) {
							$html .= '<li><a href="'. get_permalink($beaking->ID) .'">'. esc_html($beaking->post_title) .'</a></li>';
						}
								
						$html .= '</ul>';
					$html .= '</div>';
				$html .= '</div>';
			$html .= '</div>';
		}
		return $html;
	}
}
add_shortcode( 'ub_breaking', 'ub_vc_breaking' );


vc_map( array (
	'base' 			=> 'ub_breaking',
	'name' 			=> __('Breaking', 'mfn-opts'),
	'category' 		=> __('Content', 'mfn-opts'),
	'icon' 			=> 'ub_icon_shortcode',
	'params' 		=> array (
		array (
			'param_name' 	=> 'title',
			'type' 			=> 'textfield',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Title', 'mfn-opts'),
			'admin_label'	=> true,
		),
		array (
			'param_name' 	=> 'terms',
			'type' 			=> 'terms',
			'taxonomies' 	=> 'category',
			'heading' 		=> __('Categories', 'mfn-opts'),
			'admin_label'	=> true,
		),
		
		array (
			'param_name' 	=> 'tags',
			'type' 			=> 'textfield',
			'heading' 		=> __('Filter by tag slug', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'Example: tag1,tag2,tag3...'
		),
		
		array (
			'param_name' 	=> 'sort_order_by',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Sort Order', 'mfn-opts'),
			'value'			=> array(
									'Date Time' => 'date',
									'Title' => 'title',
									'Popular' => 'popular',
									'Popular On Week' => 'popular_week',
									'Popular On Month' => 'popular_month',
									'Featured' => 'featured',
									'Highest rated' => 'reviews',
									'Random' => 'random'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'sort_order',
			'type' 			=> 'dropdown',
			'heading' 		=> __('Order', 'mfn-opts'),
			'value'			=> array(
									'DESC' => 'DESC',
									'ASC' => 'ASC'
								),
			'admin_label'	=> true
		),
		
		array (
			'param_name' 	=> 'posts_per_page',
			'type' 			=> 'textfield',
			'heading' 		=> __('Number Posts', 'mfn-opts'),
			'admin_label'	=> true,
			'value'			=> 10,
			'description' 	=> 'Input integer value for Number Posts.'
		),
		
		array (
			'param_name' 	=> 'extra_class_name',
			'type' 			=> 'textfield',
			'heading' 		=> __('Extra class name', 'mfn-opts'),
			'admin_label'	=> true,
			'description' 	=> 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.'
		)
	)
));
